/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportShadersCommand
implements ICommand<IAssetWrapper<GlShaderAsset>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<GlShaderAsset>> selection) {
        ArrayList<@NonNull GlShaderAsset> shaderAssets = new ArrayList<GlShaderAsset>();
        for (IAssetWrapper<GlShaderAsset> iAssetWrapper : selection) {
            GlShaderAsset shader = iAssetWrapper.getAsset();
            if (shader == null) continue;
            shaderAssets.add(shader);
        }
        File file = FileDialogHelper.promptForDirectory(null);
        if (file != null) {
            Job j = GUIExporterController.exportSelectedShaders(shaderAssets, file);
            FileDialogHelper.openFileAfterJobComplete(j, file);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Export Shaders";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<GlShaderAsset>> selection) {
        return ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved() && !selection.isEmpty();
    }
}

