/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.IExportable;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.IBackgroundAssetExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportSelectedTableViewItemsCommand<ASSET_TYPE extends @NonNull IAssetItem, EXPORTABLE_TYPE extends IExportable<ASSET_TYPE>, ASSET_EXPORTER_TYPE extends IBackgroundAssetExporter<ASSET_TYPE>>
implements ICommand<IExportable<ASSET_TYPE>> {
    private final @NonNull ASSET_EXPORTER_TYPE assetExporter;
    private final @NonNull String label;

    public ExportSelectedTableViewItemsCommand(@NonNull ASSET_EXPORTER_TYPE assetExporter, @NonNull String label) {
        this.assetExporter = assetExporter;
        this.label = label;
    }

    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IExportable<ASSET_TYPE>> selection) {
        File selectedDir;
        ArrayList assets = new ArrayList();
        for (IExportable<ASSET_TYPE> tableViewItem : selection) {
            @Nullable T assetItem = tableViewItem.getAsset();
            if (assetItem == null) continue;
            assets.add(assetItem);
        }
        if (!assets.isEmpty() && (selectedDir = FileDialogHelper.promptForDirectory(null)) != null) {
            Job j = this.assetExporter.exportSelectedAssets(assets, selectedDir);
            FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return this.label;
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IExportable<ASSET_TYPE>> selection) {
        if (!ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved() || selection.isEmpty()) {
            return false;
        }
        for (IExportable<ASSET_TYPE> item : selection) {
            if (item.isAvailable()) continue;
            return false;
        }
        return true;
    }
}

