/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportFunctionCallShadersCommand
implements ICommand<FunctionCall> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FunctionCall> selection) {
        if (selection.size() == 1) {
            FunctionCall fc = selection.get(0);
            TraceDataModel fcModel = fc.getModel();
            File selectedDir = FileDialogHelper.promptForDirectory(null);
            if (selectedDir != null) {
                Job j = GUIExporterController.exportAllShadersAtFunction(fcModel, fc.getIndex(), selectedDir);
                FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
            }
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Export Shaders";
    }

    @Override
    public boolean isEnabled(TraceDataModel model, List<? extends FunctionCall> selection) {
        return ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved() && selection.size() == 1;
    }
}

