/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportFramebuffersCommand
implements ICommand<INavigationElement<?>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends INavigationElement<?>> selection) {
        HashMap<@NonNull TraceDataModel, Set<Integer>> modelToSelectedDrawCallsMap = new HashMap<TraceDataModel, Set<Integer>>();
        HashSet<FrameRenderPass> selectedFBOs = new HashSet<FrameRenderPass>();
        Function<@NonNull TraceDataModel, @NonNull Set> getModelFunctionArrayList = modelKey -> {
            HashSet drawCallSet = (HashSet)modelToSelectedDrawCallsMap.get(modelKey);
            if (drawCallSet == null) {
                drawCallSet = new HashSet();
                modelToSelectedDrawCallsMap.put((TraceDataModel)modelKey, drawCallSet);
            }
            return drawCallSet;
        };
        for (INavigationElement<?> item : selection) {
            if (item instanceof DrawFunctionCall) {
                DrawFunctionCall fc = (DrawFunctionCall)item;
                TraceDataModel traceDataModel = fc.getModel();
                Set selectedDrawCalls = getModelFunctionArrayList.apply(traceDataModel);
                selectedDrawCalls.add(fc.getIndex());
                continue;
            }
            if (item instanceof FrameRenderPass) {
                selectedFBOs.add((FrameRenderPass)item);
                continue;
            }
            if (item instanceof Frame) {
                selectedFBOs.addAll(((Frame)item).getRenderPassList());
                continue;
            }
            if (item instanceof TraceDataModel) {
                TraceDataModel traceDataModel = (TraceDataModel)item;
                for (Frame f : traceDataModel.getFrames().getFrames()) {
                    selectedFBOs.addAll(f.getRenderPassList());
                }
                continue;
            }
            if (!(item instanceof FunctionCall)) assert (false) : "Unknown INavigationElement";
        }
        for (FrameRenderPass fbo : selectedFBOs) {
            Set selectedDrawCalls = getModelFunctionArrayList.apply(fbo.getFrame().getParentModel());
            for (DrawFunctionCall fc : fbo.getDrawCalls()) {
                selectedDrawCalls.add(fc.getIndex());
            }
        }
        File selectedDir = FileDialogHelper.promptForDirectory(null);
        if (selectedDir != null && modelToSelectedDrawCallsMap.size() > 0) {
            Job j = GUIExporterController.exportCapturedFramebuffers(modelToSelectedDrawCallsMap, selectedDir);
            FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Export Captured Framebuffers";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends INavigationElement<?>> selection) {
        if (!ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved()) {
            return false;
        }
        for (INavigationElement<?> item : selection) {
            Frame parentFrame = null;
            if (item instanceof DrawFunctionCall) {
                parentFrame = ((DrawFunctionCall)item).getParentFrame();
            } else if (item instanceof FrameRenderPass) {
                parentFrame = ((FrameRenderPass)item).getFrame();
            } else if (item instanceof Frame) {
                parentFrame = (Frame)item;
            } else if (item instanceof TraceDataModel) {
                TraceDataModel traceDataModel = (TraceDataModel)item;
                for (Frame frame : traceDataModel.getFrames().getFrames()) {
                    if (!ExportFramebuffersCommand.isFrameGLES(parentFrame) || !ExportFramebuffersCommand.isFrameCaptured(frame)) continue;
                    return true;
                }
            } else {
                if (item instanceof FunctionCall) continue;
                assert (false) : "Unknown INavigationElement";
            }
            if (!ExportFramebuffersCommand.isFrameGLES(parentFrame) || !ExportFramebuffersCommand.isFrameCaptured(parentFrame)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFrameGLES(@Nullable Frame frame) {
        if (frame == null) {
            return false;
        }
        @NonNull TraceDataModel model = frame.getParentModel();
        if (model.count() == 0) {
            return false;
        }
        @NonNull FunctionCall frameFirstFunctionCall = model.getCallItem(frame.getFirstFunctionIndex());
        return KapiSpec.GLES.equals(frameFirstFunctionCall.getFunctionSpec().getKapiSpec()) || KapiSpec.EGL.equals(frameFirstFunctionCall.getFunctionSpec().getKapiSpec());
    }

    private static boolean isFrameCaptured(@Nullable Frame frame) {
        return frame != null && frame.isCaptured();
    }
}

