/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportBuffersCommand
implements ICommand<IAssetWrapper<IBufferItem>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<IBufferItem>> selection) {
        File selectedDir = FileDialogHelper.promptForDirectory(null);
        if (selectedDir != null) {
            @NonNull List<@NonNull IBufferItem> assets = selection.stream().map(wrapper -> (IBufferItem)wrapper.getAsset()).filter(asset -> asset != null).collect(Collectors.toList());
            Job j = GUIExporterController.exportSelectedBuffers(assets, selectedDir);
            FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Export Buffer";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<IBufferItem>> selection) {
        return ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved() && !selection.isEmpty();
    }
}

