/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.IBackgroundAssetExporter;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportAssetsFromSelectedFunctionCallCommand<ASSET_TYPE extends @NonNull IAssetItem, ASSET_EXPORTER_TYPE extends IBackgroundAssetExporter<ASSET_TYPE>>
implements ICommand<FunctionCall> {
    private @NonNull KapiSpec kapiSpec;
    private @NonNull ASSET_EXPORTER_TYPE assetExporter;
    private @NonNull String label;

    public ExportAssetsFromSelectedFunctionCallCommand(@NonNull ASSET_EXPORTER_TYPE assetExporter, @NonNull KapiSpec kapiSpec, @NonNull String label) {
        this.kapiSpec = kapiSpec;
        this.assetExporter = assetExporter;
        this.label = label;
    }

    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FunctionCall> selectedItems) {
        if (selectedItems.size() == 1) {
            FunctionCall item = selectedItems.get(0);
            TraceDataModel fcModel = item.getModel();
            File selectedDir = FileDialogHelper.promptForDirectory(null);
            if (selectedDir != null) {
                Job j = this.assetExporter.exportAllAssetsAtFunction(fcModel, item.getIndex(), selectedDir);
                FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
            }
        }
    }

    @Override
    public @NonNull String getLabel() {
        return this.label;
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FunctionCall> selectedItems) {
        if (!ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved() || selectedItems.size() != 1) {
            return false;
        }
        FunctionCall functionCall = selectedItems.get(0);
        return this.isSelectedFunctionCallRelevant(functionCall);
    }

    protected boolean isSelectedFunctionCallRelevant(@NonNull FunctionCall functionCall) {
        return functionCall.getFunctionSpec().getKapiSpec().equals(this.kapiSpec);
    }
}

