/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.shader.ForcePrecisionModeOverride;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.replay.texture.TextureOverride;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.FrameOverridesViewListItem;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.OverrideWizardHelper;
import com.arm.mgd.ui.dialogs.replayoverridewizard.MinimalFrameReplayOverrideWizard;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EditFrameOverrideCommand
implements ICommand<FrameOverridesViewListItem> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FrameOverridesViewListItem> selection) {
        if (this.isEnabled(model, selection)) {
            AbstractFrameOverride override = selection.get(0).getOverride();
            OverrideWizardHelper.createSnapshotWizard(this.getLabel(), model, (latestSnapshot, selectedSnapshot) -> {
                if (override instanceof TextureOverride) {
                    return new MinimalFrameReplayOverrideWizard(latestSnapshot, selectedSnapshot, FrameOverrides.OverrideType.TEXTURE_OVERRIDE, override);
                }
                if (override instanceof ForcePrecisionModeOverride) {
                    return new MinimalFrameReplayOverrideWizard(latestSnapshot, selectedSnapshot, FrameOverrides.OverrideType.FORCE_PRECISION_OVERRIDE, override);
                }
                if (override instanceof ProgramOverride) {
                    return new MinimalFrameReplayOverrideWizard(latestSnapshot, selectedSnapshot, FrameOverrides.OverrideType.PROGRAM_OVERRIDE, override);
                }
                throw new AssertionError((Object)("Unkown type of override" + override));
            });
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Edit Frame Override";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FrameOverridesViewListItem> selection) {
        if (model != null && model.getParentProcessTarget().getParentTarget().isLiveTarget() && selection.size() == 1) {
            AbstractFrameOverride override = selection.get(0).getOverride();
            return model.getCurrentActiveOverrides().contains(override);
        }
        return false;
    }
}

