/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.texture.TextureOverride;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.dialogs.replayoverridewizard.SelectTextureAssetPage;
import com.arm.mgd.ui.propertytesters.OverridePropertyTester;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AddTextureOverrideCommand
implements ICommand<IAssetWrapper<GlTextureAsset>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<GlTextureAsset>> selectedItems) {
        IAssetWrapper<GlTextureAsset> item;
        GlTextureAsset assetItem;
        assert (selectedItems.size() != 0);
        if (selectedItems.size() == 1 && (assetItem = (item = selectedItems.get(0)).getAsset()) != null) {
            AddTextureOverrideCommand.handleSelectedAssetItem(model, assetItem);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Add Texture Override";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<GlTextureAsset>> selectedItems) {
        IAssetWrapper<GlTextureAsset> item;
        GlTextureAsset textureAsset;
        if (selectedItems.size() == 1 && (textureAsset = (item = selectedItems.get(0)).getAsset()) != null) {
            return OverridePropertyTester.testTexture(model, textureAsset, OverridePropertyTester.OverrideProperty.ADD_TEXTURE);
        }
        return false;
    }

    private static void handleSelectedAssetItem(@Nullable TraceDataModel model, @NonNull GlTextureAsset textureAsset) {
        if (model != null) {
            TextureOverride textureOverride = new TextureOverride(SelectTextureAssetPage.TEXTURE_COORDINATE_256, textureAsset.getId().longValue());
            FrameOverrides modelOverrides = model.getCurrentActiveOverrides();
            if (!modelOverrides.containsSimilar((AbstractFrameOverride)textureOverride)) {
                modelOverrides.add((AbstractFrameOverride)textureOverride);
            }
        }
    }
}

