/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.commands.AbstractShaderOverrideCommand;
import com.arm.mgd.ui.controllers.commands.OverrideWizardHelper;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.MinimalFrameReplayOverrideWizard;
import com.arm.mgd.ui.dialogs.replayoverridewizard.ModifyProgramAssetPage;
import com.arm.mgd.ui.propertytesters.OverridePropertyTester;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class AddProgramOverrideCommand
extends AbstractShaderOverrideCommand {
    @Override
    protected void handleSelectedAssetItem(TraceDataModel model, @NonNull GlProgramAsset assetItem) {
        if (model != null) {
            ProgramOverride po = new ProgramOverride(assetItem);
            FrameOverrides modelOverrides = model.getCurrentActiveOverrides();
            if (!modelOverrides.containsSimilar((AbstractFrameOverride)po)) {
                ModifyProgramAssetPage.openEditor(po, model);
                modelOverrides.add((AbstractFrameOverride)po);
            }
        }
    }

    @Override
    protected void handleSelectedAssetItem(TraceDataModel model, @NonNull List<@NonNull ? extends GlProgramAsset> assetItemList) {
        assert (!assetItemList.isEmpty());
        OverrideWizardHelper.createSnapshotWizard(this.getLabel(), model, (latestSnapshot, selectedSnapshot) -> new MinimalFrameReplayOverrideWizard(latestSnapshot, selectedSnapshot, FrameOverrides.OverrideType.PROGRAM_OVERRIDE, assetItemList, AbstractSecondPage.Mode.ADD));
    }

    @Override
    public @NonNull String getLabel() {
        return "Add Program Override";
    }

    @Override
    protected boolean isEnabledFor(TraceDataModel model, GlProgramAsset assetItem) {
        return OverridePropertyTester.testProgramOverride(model, assetItem, OverridePropertyTester.OverrideProperty.ADD_PROGRAM);
    }
}

