/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.commands.ICommand;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractShaderOverrideCommand
implements ICommand<IAssetWrapper<GlShaderAsset>> {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final void execute(TraceDataModel model, List<? extends IAssetWrapper<GlShaderAsset>> selection) {
        assert (selection.size() != 0);
        IAssetWrapper<GlShaderAsset> element = selection.get(0);
        assert (element != null);
        GlShaderAsset shader = element.getAsset();
        if (shader != null) {
            @NonNull @NonNull List linkedProgramList = shader.getLinkedToProgramList();
            assert (!linkedProgramList.isEmpty());
            if (linkedProgramList.size() == 1) {
                GlProgramAsset asset = (GlProgramAsset)linkedProgramList.iterator().next();
                assert (asset != null);
                this.handleSelectedAssetItem(model, asset);
            } else {
                this.handleSelectedAssetItem(model, linkedProgramList);
            }
        }
    }

    @Override
    public final boolean isEnabled(TraceDataModel model, List<? extends IAssetWrapper<GlShaderAsset>> selection) {
        List linkedProgramList;
        GlShaderAsset shader;
        IAssetWrapper<GlShaderAsset> firstItem;
        if (selection.size() == 1 && (firstItem = selection.get(0)) != null && (shader = firstItem.getAsset()) != null && !(linkedProgramList = shader.getLinkedToProgramList()).isEmpty()) {
            for (GlProgramAsset program : linkedProgramList) {
                if (!this.isEnabledFor(model, program)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void handleSelectedAssetItem(@Nullable TraceDataModel var1, @NonNull GlProgramAsset var2);

    protected abstract void handleSelectedAssetItem(@Nullable TraceDataModel var1, @NonNull List<@NonNull ? extends GlProgramAsset> var2);

    protected abstract boolean isEnabledFor(@Nullable TraceDataModel var1, @NonNull GlProgramAsset var2);
}

