/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.DrawCallData;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.programvariable.ShaderAttribute;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.kapi.AbstractConstantOrAliasSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.DialogFileTypes;
import com.arm.mgd.ui.filterruler.MarkerSet;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.geometry.Point3D;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.paint.Color;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.PlatformUI;

public class VerticesViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ObservableList<@NonNull VertexAttributeColumnItem> columns = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ObservableList<Integer> uniqueVertexIndices = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ReadOnlyStringWrapper indicesText = new ReadOnlyStringWrapper();
    private final @NonNull ReadOnlyStringWrapper noIndicesDataMessage = new ReadOnlyStringWrapper("The selected function is not a draw call");
    private final @NonNull ReadOnlyStringWrapper noGeometryDataMessage = new ReadOnlyStringWrapper();
    private final @NonNull ReadOnlyBooleanWrapper indicesDataAvailableProperty = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyBooleanWrapper geometryDataAvailableProperty = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ObservableSet<@NonNull MarkerSet> markerSets = (ObservableSet)NullUtils.neverNull((Object)FXCollections.observableSet(new LinkedHashSet()));
    private final @NonNull MarkerSet indicesMarker = new MarkerSet((Color)NullUtils.neverNull((Object)Color.GREEN), true);
    private final @NonNull ReadOnlyIntegerWrapper firstVertexIndex = new ReadOnlyIntegerWrapper();
    private final @NonNull ReadOnlyIntegerWrapper lastVertexIndex = new ReadOnlyIntegerWrapper();
    private final @NonNull ObjectProperty<@Nullable VertexAttributeViewInput> currentInput = new SimpleObjectProperty();
    private final @NonNull ObservableFloatArray points = (ObservableFloatArray)NullUtils.neverNull((Object)FXCollections.observableFloatArray());
    private final @NonNull ObservableIntegerArray faces = (ObservableIntegerArray)NullUtils.neverNull((Object)FXCollections.observableIntegerArray());
    private final @NonNull ObservableFloatArray texCoords = (ObservableFloatArray)NullUtils.neverNull((Object)FXCollections.observableFloatArray());
    private final @NonNull ObjectProperty<@Nullable VertexAttributeColumnItem> selectedPositionColumn = new SimpleObjectProperty(null);
    private @Nullable VertexAttributeColumnItem suggestedPositionColumn = null;
    private final @NonNull ReadOnlyDoubleWrapper maxDimensionRangeSize = new ReadOnlyDoubleWrapper();
    private final @NonNull ObjectProperty<Point3D> verticesCenter = new SimpleObjectProperty((Object)new Point3D(0.0, 0.0, 0.0));
    private final @NonNull ReadOnlyDoubleWrapper verticesCenterX = new ReadOnlyDoubleWrapper();
    private final @NonNull ReadOnlyDoubleWrapper verticesCenterY = new ReadOnlyDoubleWrapper();
    private final @NonNull ReadOnlyDoubleWrapper verticesCenterZ = new ReadOnlyDoubleWrapper();
    private final @NonNull ExecutorService executor = NamedExecutors.cachedFiniteThreadPool((int)1, (long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("Mesh Creator Executor"));
    private @NonNull AtomicReference<@Nullable FutureTask<Void>> meshCreationTask = new AtomicReference();

    public VerticesViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.markerSets.add((Object)this.indicesMarker);
        this.selectedPositionColumn.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.suggestedPositionColumn = newValue;
                VertexAttributeViewInput input = (VertexAttributeViewInput)this.currentInput.get();
                if (input != null) {
                    FutureTask<Object> newTask = new FutureTask<Object>(new MeshCreator(input, (VertexAttributeColumnItem)newValue), null);
                    this.executor.execute(newTask);
                    this.setMeshCreationTask(newTask);
                }
            }
        });
        this.verticesCenterX.bind((ObservableValue)Bindings.createObjectBinding(() -> ((Point3D)this.verticesCenter.get()).getX(), (Observable[])new Observable[]{this.verticesCenter}));
        this.verticesCenterY.bind((ObservableValue)Bindings.createObjectBinding(() -> ((Point3D)this.verticesCenter.get()).getY(), (Observable[])new Observable[]{this.verticesCenter}));
        this.verticesCenterZ.bind((ObservableValue)Bindings.createObjectBinding(() -> ((Point3D)this.verticesCenter.get()).getZ(), (Observable[])new Observable[]{this.verticesCenter}));
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        Platform.runLater(() -> this.currentInput.set(null));
        this.executor.shutdown();
    }

    private void setMeshCreationTask(@Nullable FutureTask<Void> newTask) {
        FutureTask<Void> oldTask = this.meshCreationTask.getAndSet(newTask);
        if (oldTask != null) {
            oldTask.cancel(true);
        }
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        this.setMeshCreationTask(null);
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> this.refreshData(snapshot));
    }

    private void refreshData(@Nullable TraceStateSnapshot snapshot) {
        ArrayList<Integer> newVertexIndices = new ArrayList<Integer>();
        ArrayList<PositionVertexAttributeColumnItem> newColumns = new ArrayList<PositionVertexAttributeColumnItem>();
        VertexAttributeViewInput newInput = null;
        boolean indicesDataAvailable = false;
        String indices = "";
        String noDataReason = "The selected function is not a draw call";
        int minimumIndex = 0;
        int maximumIndex = 0;
        FunctionCall function = snapshot != null ? snapshot.getCurrentFunctionCall() : null;
        DrawFunctionCall drawCall = function instanceof DrawFunctionCall ? (DrawFunctionCall)function : null;
        DrawCallData data = drawCall != null ? drawCall.getDrawCallData() : null;
        this.clearMesh();
        if (snapshot != null && drawCall != null && data != null) {
            indices = Arrays.toString(data.getIndices(snapshot));
            GlProgramAsset program = GlProgramHelper.getCurrentProgramAsset((TraceStateSnapshot)snapshot, (AbstractConstantOrAliasSpecExtended)KapiSpec.GLES.constants.GL_VERTEX_SHADER);
            int @NonNull [] orderedUniqueIndices = data.getOrderedUniqueIndices(snapshot);
            if (program == null) {
                noDataReason = "Unable to find the program for this draw call";
            } else if (orderedUniqueIndices.length == 0) {
                noDataReason = "No indices for this draw call.";
            } else {
                indicesDataAvailable = true;
                maximumIndex = orderedUniqueIndices[orderedUniqueIndices.length - 1];
                minimumIndex = orderedUniqueIndices[0];
                int[] nArray = orderedUniqueIndices;
                int n = orderedUniqueIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int vertexIndex = nArray[n2];
                    newVertexIndices.add(vertexIndex);
                    ++n2;
                }
                List attributes = program.getAttributes();
                int attributeIndex = 0;
                while (attributeIndex < attributes.size()) {
                    ShaderAttribute attribute = (ShaderAttribute)attributes.get(attributeIndex);
                    PositionVertexAttributeColumnItem column = new PositionVertexAttributeColumnItem(attribute.name, attribute.type.getName(), attribute.getRowSize(), attributeIndex);
                    newColumns.add(column);
                    ++attributeIndex;
                }
                newInput = new VertexAttributeViewInput(snapshot, data, program, orderedUniqueIndices);
            }
        }
        String localIndices = indices;
        boolean localIndicesDataAvailable = indicesDataAvailable;
        String localNoDataReason = noDataReason;
        int localMinimumIndex = minimumIndex;
        int localMaximumIndex = maximumIndex;
        VertexAttributeViewInput localNewInput = newInput;
        Platform.runLater(() -> {
            this.currentInput.set((Object)localNewInput);
            this.calculateSuggestedPositionColumn(newColumns);
            this.uniqueVertexIndices.clear();
            this.uniqueVertexIndices.addAll((Collection)newVertexIndices);
            this.indicesText.set(localIndices);
            this.indicesDataAvailableProperty.set(localIndicesDataAvailable);
            this.geometryDataAvailableProperty.set(localIndicesDataAvailable);
            this.noIndicesDataMessage.set(localNoDataReason);
            this.noGeometryDataMessage.set(localNoDataReason);
            this.indicesMarker.setActivePositions(newVertexIndices);
            this.lastVertexIndex.set(localMaximumIndex);
            this.firstVertexIndex.set(localMinimumIndex);
            this.columns.setAll((Collection)newColumns);
        });
    }

    private void calculateSuggestedPositionColumn(@NonNull ArrayList<@NonNull PositionVertexAttributeColumnItem> newColumns) {
        if (!newColumns.contains(this.selectedPositionColumn.get())) {
            if (newColumns.size() != 0) {
                ArrayList<@NonNull PositionVertexAttributeColumnItem> columnsCopy = new ArrayList<PositionVertexAttributeColumnItem>(newColumns);
                Collections.sort(columnsCopy);
                this.suggestedPositionColumn = columnsCopy.get(0);
            } else {
                this.suggestedPositionColumn = null;
            }
        }
    }

    private void clearMesh() {
        Platform.runLater(() -> {
            this.currentInput.set(null);
            this.points.clear();
            this.faces.clear();
            this.texCoords.clear();
        });
    }

    private boolean checkGeometrySupport(@Nullable AbstractConstantOrAliasSpec drawCallMode) {
        String notSupportedMessage;
        boolean supported;
        if (!Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D)) {
            supported = false;
            notSupportedMessage = "Your computer does not meet the minimum requirements for the Geometry view.";
        } else if (drawCallMode == null) {
            supported = false;
            notSupportedMessage = "Cannot detect the current draw mode.";
        } else if (drawCallMode != KapiSpec.GLES.constants.GL_TRIANGLES && drawCallMode != KapiSpec.GLES.constants.GL_TRIANGLE_STRIP && drawCallMode != KapiSpec.GLES.constants.GL_POINTS) {
            supported = false;
            notSupportedMessage = "The current draw mode (" + drawCallMode.getName() + ") is not supported, only GL_TRIANGLES, GL_TRIANGLE_STRIP, and GL_POINTS are supported at the moment.";
        } else {
            supported = true;
            notSupportedMessage = "";
        }
        Platform.runLater(() -> {
            this.geometryDataAvailableProperty.set(supported);
            this.noGeometryDataMessage.set(notSupportedMessage);
        });
        return supported;
    }

    public String getVertexAttributeValue(int vertexIndex, int instance, VertexAttributeColumnItem attribute) {
        VertexAttributeViewInput input = (VertexAttributeViewInput)this.currentInput.get();
        if (input == null) {
            return "<No Data>";
        }
        ShaderAttribute shaderAttribute = (ShaderAttribute)input.program.getAttributes().get(attribute.getIndex());
        try {
            Number[] attributeValue = shaderAttribute.getVertexAttributeAsset(input.currentState).getVertex(vertexIndex, instance);
            return StringUtils.arrayToString((Object[])Arrays.copyOfRange(attributeValue, 0, attribute.getRowSize()));
        }
        catch (UnsupportedTypeException e) {
            return "<No Data>";
        }
        catch (NullPointerException e) {
            FramebufferFeature.CaptureMode feature;
            FrameRenderPass firstRenderPass;
            FunctionCall fc = input.currentState.getCurrentFunctionCall();
            Frame parentFrame = fc.getParentFrame();
            if (parentFrame != null && (firstRenderPass = parentFrame.getFirstRenderPass()) != null && ((feature = firstRenderPass.getCaptureMode()) == FramebufferFeature.CaptureMode.FRAGMENT_COUNT || feature == FramebufferFeature.CaptureMode.OVERDRAW || feature == FramebufferFeature.CaptureMode.SHADER_MAP)) {
                return "<Not available due to capture mode>";
            }
            return "<No Data>";
        }
    }

    public ReadOnlyStringProperty indicesTextProperty() {
        return this.indicesText.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty indicesDataAvailableProperty() {
        return this.indicesDataAvailableProperty.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty geometryDataAvailableProperty() {
        return this.geometryDataAvailableProperty.getReadOnlyProperty();
    }

    public @NonNull ObservableList<@NonNull VertexAttributeColumnItem> getVertexAttributes() {
        return this.columns;
    }

    public ObservableList<Integer> getUniqueVertexIndices() {
        return this.uniqueVertexIndices;
    }

    public ObservableSet<@NonNull MarkerSet> markerSetsProperty() {
        return this.markerSets;
    }

    public ReadOnlyIntegerProperty firstVertexIndexProperty() {
        return this.firstVertexIndex.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty lastVertexIndexProperty() {
        return this.lastVertexIndex.getReadOnlyProperty();
    }

    public ReadOnlyStringProperty noIndicesDataReasonProperty() {
        return this.noIndicesDataMessage.getReadOnlyProperty();
    }

    public ReadOnlyStringProperty noGeometryDataReasonProperty() {
        return this.noGeometryDataMessage.getReadOnlyProperty();
    }

    public void copyVertexAttibutes(ObservableList<Integer> selectedVertexIndices) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer selectedIndex : selectedVertexIndices) {
            stringBuilder.append(selectedIndex);
            for (VertexAttributeColumnItem attribute : this.columns) {
                stringBuilder.append(" ").append(attribute.name).append("=[");
                stringBuilder.append(this.getVertexAttributeValue(selectedIndex, 0, attribute));
                stringBuilder.append("]");
            }
            stringBuilder.append("\n");
        }
        String stringToCopy = stringBuilder.toString();
        if (!stringToCopy.isEmpty()) {
            content.putString(stringToCopy);
            clipboard.setContent((Map)content);
        }
    }

    public void exportGeometryToObj() {
        File selectedFile = FileDialogHelper.promptForFile(DialogFileTypes.EXPORT_GEOMETRY, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true, new File("Geometry.obj"));
        if (selectedFile != null) {
            float[] pointsArray = this.points.toArray(null);
            int[] facesArray = this.faces.toArray(null);
            @NonNull Job j = GUIExporterController.exportSelectedGeometry(pointsArray, facesArray, selectedFile);
            FileDialogHelper.openFileAfterJobComplete(j, selectedFile);
        }
    }

    public @NonNull ObservableFloatArray getPoints() {
        return this.points;
    }

    public @NonNull ObservableIntegerArray getFaces() {
        return this.faces;
    }

    public @NonNull ObservableFloatArray getTexCoords() {
        return this.texCoords;
    }

    public ObjectProperty<VertexAttributeColumnItem> selectedPositionProperty() {
        return this.selectedPositionColumn;
    }

    public ObjectProperty<Point3D> verticesCenterProperty() {
        return this.verticesCenter;
    }

    public ReadOnlyDoubleProperty verticesCenterXProperty() {
        return this.verticesCenterX.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty verticesCenterYProperty() {
        return this.verticesCenterY.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty verticesCenterZProperty() {
        return this.verticesCenterZ.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty maxDimensionRangeProperty() {
        return this.maxDimensionRangeSize.getReadOnlyProperty();
    }

    public @Nullable VertexAttributeColumnItem getSuggestedPositionColumn() {
        return this.suggestedPositionColumn;
    }

    private class MeshCreator
    implements Runnable {
        private final @NonNull VertexAttributeViewInput input;
        private final @NonNull VertexAttributeColumnItem positionAttribute;

        private MeshCreator(@NonNull VertexAttributeViewInput input, VertexAttributeColumnItem positionAttribute) {
            this.input = input;
            this.positionAttribute = positionAttribute;
        }

        @Override
        public void run() {
            int[] localFaces;
            float[] positions;
            AbstractConstantOrAliasSpec drawCallMode = this.input.data.getMode();
            if (!VerticesViewController.this.checkGeometrySupport(drawCallMode)) {
                return;
            }
            ShaderAttribute shaderAttribute = (ShaderAttribute)this.input.program.getAttributes().get(this.positionAttribute.getIndex());
            GlVertexAttributeAsset vertexAttributeAsset = shaderAttribute.getVertexAttributeAsset(this.input.currentState);
            int maximumIndex = this.input.orderedUniqueIndices[this.input.orderedUniqueIndices.length - 1];
            int minimumIndex = this.input.orderedUniqueIndices[0];
            int[] indices = this.input.data.getIndices(this.input.currentState);
            float[] originalPositions = new float[(maximumIndex + 1 - minimumIndex) * 3];
            MeshStatistics meshStatistics = new MeshStatistics();
            int index = minimumIndex;
            while (index <= maximumIndex) {
                Number[] attributeValue = null;
                try {
                    attributeValue = vertexAttributeAsset.getVertex(index, 0);
                }
                catch (UnsupportedTypeException e) {
                    Platform.runLater(() -> {
                        VerticesViewController.this.geometryDataAvailableProperty.set(false);
                        VerticesViewController.this.noGeometryDataMessage.set("An error occured while reading data for attribute '" + shaderAttribute.name + "'. " + e.getMessage());
                    });
                    break;
                }
                if (attributeValue == null) {
                    Platform.runLater(() -> VerticesViewController.this.geometryDataAvailableProperty.set(false));
                    break;
                }
                float originalPositionX = attributeValue[0].floatValue();
                float originalPositionY = attributeValue[1].floatValue();
                float originalPositionZ = attributeValue[2].floatValue();
                int adjustedIndex = (index - minimumIndex) * 3;
                originalPositions[adjustedIndex + 0] = originalPositionX;
                originalPositions[adjustedIndex + 1] = originalPositionY;
                originalPositions[adjustedIndex + 2] = originalPositionZ;
                meshStatistics.addPoint(originalPositionX, originalPositionY, originalPositionZ);
                ++index;
            }
            if (KapiSpec.GLES.constants.GL_POINTS.equals(drawCallMode)) {
                float delta = (float)meshStatistics.getSize() / 1500.0f;
                positions = new float[originalPositions.length * 4];
                int index2 = minimumIndex;
                while (index2 <= maximumIndex) {
                    int originalPositionIndex = (index2 - minimumIndex) * 3;
                    int adjustedIndex = originalPositionIndex * 4;
                    float originalPositionX = originalPositions[originalPositionIndex + 0];
                    float originalPositionY = originalPositions[originalPositionIndex + 1];
                    float originalPositionZ = originalPositions[originalPositionIndex + 2];
                    positions[adjustedIndex + 0] = originalPositionX + 0.0f;
                    positions[adjustedIndex + 1] = originalPositionY - delta;
                    positions[adjustedIndex + 2] = originalPositionZ - delta;
                    positions[adjustedIndex + 3] = originalPositionX + 0.0f;
                    positions[adjustedIndex + 4] = originalPositionY + delta;
                    positions[adjustedIndex + 5] = originalPositionZ + 0.0f;
                    positions[adjustedIndex + 6] = originalPositionX + delta;
                    positions[adjustedIndex + 7] = originalPositionY - delta;
                    positions[adjustedIndex + 8] = originalPositionZ + delta;
                    positions[adjustedIndex + 9] = originalPositionX - delta;
                    positions[adjustedIndex + 10] = originalPositionY - delta;
                    positions[adjustedIndex + 11] = originalPositionZ + delta;
                    ++index2;
                }
            } else {
                positions = originalPositions;
            }
            if (KapiSpec.GLES.constants.GL_TRIANGLES.equals(drawCallMode)) {
                localFaces = new int[indices.length * 2];
                int indicesIndex = 0;
                while (indicesIndex < indices.length) {
                    int indexBase = indicesIndex * 2;
                    localFaces[indexBase + 0] = indices[indicesIndex] - minimumIndex;
                    localFaces[indexBase + 1] = 0;
                    ++indicesIndex;
                }
            } else if (KapiSpec.GLES.constants.GL_TRIANGLE_STRIP.equals(drawCallMode) && indices.length >= 2) {
                localFaces = new int[(indices.length - 2) * 6];
                int indicesIndex = 2;
                while (indicesIndex < indices.length) {
                    int indexBase = (indicesIndex - 2) * 6;
                    if (indicesIndex % 2 == 0) {
                        localFaces[indexBase + 0] = indices[indicesIndex - 2] - minimumIndex;
                        localFaces[indexBase + 1] = 0;
                        localFaces[indexBase + 2] = indices[indicesIndex - 1] - minimumIndex;
                        localFaces[indexBase + 3] = 0;
                    } else {
                        localFaces[indexBase + 0] = indices[indicesIndex - 1] - minimumIndex;
                        localFaces[indexBase + 1] = 0;
                        localFaces[indexBase + 2] = indices[indicesIndex - 2] - minimumIndex;
                        localFaces[indexBase + 3] = 0;
                    }
                    localFaces[indexBase + 4] = indices[indicesIndex] - minimumIndex;
                    localFaces[indexBase + 5] = 0;
                    ++indicesIndex;
                }
            } else if (KapiSpec.GLES.constants.GL_POINTS.equals(drawCallMode)) {
                localFaces = new int[indices.length * 4 * 6];
                int indicesIndex = 0;
                while (indicesIndex < indices.length) {
                    int indexBase = indicesIndex * 4 * 6;
                    int positionIndexBase = (indices[indicesIndex] - minimumIndex) * 4;
                    int a = positionIndexBase + 0;
                    int b = positionIndexBase + 1;
                    int c = positionIndexBase + 2;
                    int d = positionIndexBase + 3;
                    localFaces[indexBase + 0] = a;
                    localFaces[indexBase + 1] = 0;
                    localFaces[indexBase + 2] = d;
                    localFaces[indexBase + 3] = 0;
                    localFaces[indexBase + 4] = c;
                    localFaces[indexBase + 5] = 0;
                    localFaces[indexBase + 6] = c;
                    localFaces[indexBase + 7] = 0;
                    localFaces[indexBase + 8] = b;
                    localFaces[indexBase + 9] = 0;
                    localFaces[indexBase + 10] = a;
                    localFaces[indexBase + 11] = 0;
                    localFaces[indexBase + 12] = a;
                    localFaces[indexBase + 13] = 0;
                    localFaces[indexBase + 14] = b;
                    localFaces[indexBase + 15] = 0;
                    localFaces[indexBase + 16] = d;
                    localFaces[indexBase + 17] = 0;
                    localFaces[indexBase + 18] = d;
                    localFaces[indexBase + 19] = 0;
                    localFaces[indexBase + 20] = b;
                    localFaces[indexBase + 21] = 0;
                    localFaces[indexBase + 22] = a;
                    localFaces[indexBase + 23] = 0;
                    ++indicesIndex;
                }
            } else {
                localFaces = new int[]{};
            }
            Platform.runLater(() -> {
                VerticesViewController.this.points.setAll(positions);
                VerticesViewController.this.texCoords.setAll(new float[2]);
                VerticesViewController.this.faces.setAll(localFaces);
                VerticesViewController.this.verticesCenter.set((Object)meshStatistics.getCenter());
                VerticesViewController.this.maxDimensionRangeSize.set(meshStatistics.getSize());
            });
        }
    }

    private class MeshStatistics {
        private boolean intialisedValues = false;
        private float maxX = 0.0f;
        private float maxY = 0.0f;
        private float maxZ = 0.0f;
        private float minX = 0.0f;
        private float minY = 0.0f;
        private float minZ = 0.0f;

        private MeshStatistics() {
        }

        void addPoint(float x, float y, float z) {
            if (!this.intialisedValues) {
                this.maxX = x;
                this.maxY = y;
                this.maxZ = z;
                this.minX = x;
                this.minY = y;
                this.minZ = z;
                this.intialisedValues = true;
            }
            this.maxX = Math.max(this.maxX, x);
            this.maxY = Math.max(this.maxY, y);
            this.maxZ = Math.max(this.maxZ, z);
            this.minX = Math.min(this.minX, x);
            this.minY = Math.min(this.minY, y);
            this.minZ = Math.min(this.minZ, z);
        }

        Point3D getCenter() {
            return new Point3D((double)((this.maxX - this.minX) / 2.0f + this.minX), (double)((this.maxY - this.minY) / 2.0f + this.minY), (double)((this.maxZ - this.minZ) / 2.0f + this.minZ));
        }

        double getSize() {
            return Math.max(Math.max(this.maxX - this.minX, this.maxY - this.minY), this.maxZ - this.minZ);
        }
    }

    static class PositionVertexAttributeColumnItem
    extends VertexAttributeColumnItem
    implements Comparable<PositionVertexAttributeColumnItem> {
        private final Pattern findPos = Pattern.compile("pos", 2);
        private final Pattern findVert = Pattern.compile("vert", 2);
        private final Pattern findTex = Pattern.compile("tex", 2);

        public PositionVertexAttributeColumnItem(@NonNull String name, @NonNull String type, int rowSize, int attributeIndex) {
            super(name, type, rowSize, attributeIndex);
        }

        @Override
        public int compareTo(PositionVertexAttributeColumnItem other) {
            int sizeRank = this.compareSizeTo(other);
            if (sizeRank != 0) {
                return sizeRank;
            }
            int posRank = this.compareNameTo(this.findPos, other);
            if (posRank != 0) {
                return posRank;
            }
            int vertRank = this.compareNameTo(this.findVert, other);
            if (vertRank != 0) {
                return vertRank;
            }
            int texRank = -this.compareNameTo(this.findTex, other);
            if (texRank != 0) {
                return texRank;
            }
            return other.rowSize - this.rowSize;
        }

        private int compareSizeTo(PositionVertexAttributeColumnItem other) {
            if (this.rowSize >= 3 && other.rowSize < 3) {
                return -1;
            }
            if (this.rowSize < 3 && other.rowSize >= 3) {
                return 1;
            }
            return 0;
        }

        private int compareNameTo(Pattern stringToMatch, PositionVertexAttributeColumnItem other) {
            boolean foundInThis = stringToMatch.matcher(this.name).find();
            boolean foundInOther = stringToMatch.matcher(other.name).find();
            if (foundInThis && !foundInOther) {
                return -1;
            }
            if (!foundInThis && foundInOther) {
                return 1;
            }
            return 0;
        }
    }

    public static class VertexAttributeColumnItem {
        protected final @NonNull String name;
        protected final int rowSize;
        private final @NonNull String type;
        private final int index;

        public VertexAttributeColumnItem(@NonNull String name, @NonNull String type, int rowSize, int attributeIndex) {
            this.name = name;
            this.type = type;
            this.rowSize = rowSize;
            this.index = attributeIndex;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getRowSize() {
            return this.rowSize;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.rowSize;
        }

        public boolean equals(Object other) {
            if (!(other instanceof VertexAttributeColumnItem)) {
                return false;
            }
            VertexAttributeColumnItem otherVertexAttributeColumnItem = (VertexAttributeColumnItem)other;
            return this.name.equals(otherVertexAttributeColumnItem.name) && this.rowSize == otherVertexAttributeColumnItem.rowSize;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.rowSize;
            return result;
        }
    }

    private static class VertexAttributeViewInput {
        private final @NonNull GlProgramAsset program;
        private final @NonNull TraceStateSnapshot currentState;
        private final @NonNull DrawCallData data;
        private final int @NonNull [] orderedUniqueIndices;

        VertexAttributeViewInput(@NonNull TraceStateSnapshot snapshot, @NonNull DrawCallData data, @NonNull GlProgramAsset program, int @NonNull [] orderedUniqueIndices) {
            this.currentState = snapshot;
            this.program = program;
            this.data = data;
            this.orderedUniqueIndices = orderedUniqueIndices;
        }
    }
}

