/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UniformsViewItem {
    private final StringProperty program = new SimpleStringProperty((Object)this, "program");
    private final SimpleObjectProperty<Long> blockBinding = new SimpleObjectProperty((Object)this, "blockBinding");
    private final StringProperty blockName = new SimpleStringProperty((Object)this, "blockName");
    private final SimpleObjectProperty<Long> index = new SimpleObjectProperty((Object)this, "index");
    private final SimpleObjectProperty<UniformLocation> location = new SimpleObjectProperty((Object)this, "location");
    private final StringProperty name = new SimpleStringProperty((Object)this, "name");
    private final WeakReference<ShaderUniform> shaderUniform;
    private final StringProperty type = new SimpleStringProperty((Object)this, "type");
    private final StringProperty value = new SimpleStringProperty((Object)this, "value");

    public UniformsViewItem(@NonNull GlProgramAsset program) {
        this.shaderUniform = NullUtils.emptyWeakReference();
        this.setProgram("Program " + program.getId().toString());
    }

    public UniformsViewItem(@NonNull ShaderUniform shaderUniform) {
        this.shaderUniform = new WeakReference<ShaderUniform>(shaderUniform);
        this.setIndex(shaderUniform.getIndex());
        boolean isInDefaultBlock = shaderUniform.isInDefaultBlock();
        long locationValue = isInDefaultBlock ? (long)shaderUniform.getLocation() : shaderUniform.getResourceDescriptor().resolveOffset();
        this.setLocation(new UniformLocation(locationValue, isInDefaultBlock, shaderUniform.getBlockName()));
        this.setBlockName(shaderUniform.getBlockName());
        this.setBlockBinding(shaderUniform.getUniformBlockBinding());
        if (shaderUniform.isArrayVariable()) {
            this.setName(String.format("%s[%s]", shaderUniform.getName(), String.valueOf(shaderUniform.getArrayLength())));
        } else {
            this.setName(shaderUniform.getName());
        }
        this.setType(shaderUniform.getType().getName());
        this.setValue(shaderUniform.getValuesString());
    }

    public SimpleObjectProperty<Long> blockBindingProperty() {
        return this.blockBinding;
    }

    public StringProperty blockNameProperty() {
        return this.blockName;
    }

    public final Long getBlockBinding() {
        return (Long)this.blockBindingProperty().get();
    }

    public final String getBlockName() {
        return (String)this.blockNameProperty().get();
    }

    public final Long getIndex() {
        return (Long)this.indexProperty().get();
    }

    public final UniformLocation getLocation() {
        return (UniformLocation)this.locationProperty().get();
    }

    public String getProgram() {
        return (String)this.program.get();
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public @Nullable ShaderUniform getShaderUniform() {
        return (ShaderUniform)this.shaderUniform.get();
    }

    public final String getType() {
        return (String)this.typeProperty().get();
    }

    public final String getValue() {
        return (String)this.valueProperty().get();
    }

    public SimpleObjectProperty<Long> indexProperty() {
        return this.index;
    }

    public SimpleObjectProperty<UniformLocation> locationProperty() {
        return this.location;
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public final void setBlockBinding(Long blockBinding) {
        this.blockBindingProperty().set((Object)blockBinding);
    }

    public final void setBlockName(String blockName) {
        this.blockNameProperty().set((Object)blockName);
    }

    public final void setIndex(long index) {
        this.indexProperty().set((Object)index);
    }

    public final void setLocation(UniformLocation location) {
        this.locationProperty().set((Object)location);
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final void setValue(String value) {
        this.valueProperty().set((Object)value);
    }

    private void setProgram(String program) {
        this.programProperty().set((Object)program);
    }

    public StringProperty programProperty() {
        return this.program;
    }

    public StringProperty typeProperty() {
        return this.type;
    }

    public StringProperty valueProperty() {
        return this.value;
    }

    public static class UniformLocation
    implements Comparable<UniformLocation> {
        private final String blockName;
        private final boolean isInDefaultBlock;
        private final long uValue;

        public UniformLocation(long value, boolean isInDefaultBlock, String blockName) {
            this.uValue = value;
            this.isInDefaultBlock = isInDefaultBlock;
            this.blockName = blockName;
        }

        public int compareByBlockThenLocation(UniformLocation o) {
            if (o == null) {
                return 1;
            }
            if (this.isInDefaultBlock() != o.isInDefaultBlock()) {
                return this.isInDefaultBlock() ? -1 : 1;
            }
            if (!this.blockName.equals(o.blockName)) {
                return this.blockName.compareTo(o.blockName);
            }
            return this.compareTo(o);
        }

        @Override
        public int compareTo(UniformLocation o) {
            if (this.uValue < o.uValue) {
                return -1;
            }
            if (this.uValue == o.uValue) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            String locationString = this.isInDefaultBlock ? String.valueOf(this.uValue) : String.format("0x%s", StringUtils.toHexString((long)this.uValue, (int)6, (char)'0'));
            return locationString;
        }

        boolean isInDefaultBlock() {
            return this.isInDefaultBlock;
        }
    }
}

