/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.controllers.UniformsViewItem;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.control.TreeItem;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class UniformsViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyObjectWrapper<TreeItem<UniformsViewItem>> root = new ReadOnlyObjectWrapper();

    public UniformsViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
    }

    public ReadOnlyObjectProperty<TreeItem<UniformsViewItem>> rootProperty() {
        return this.root.getReadOnlyProperty();
    }

    private void buildTree(@Nullable TraceStateSnapshot snapshot) {
        TreeItem rootNode;
        if (snapshot != null) {
            rootNode = new TreeItem();
            for (GlProgramAsset program : GlProgramHelper.getCurrentProgramAssets((TraceStateSnapshot)snapshot)) {
                TreeItem programTreeItem = new TreeItem((Object)new UniformsViewItem(program));
                programTreeItem.setExpanded(true);
                rootNode.getChildren().add((Object)programTreeItem);
                for (UniformsViewItem uniformViewItem : UniformsViewController.getUniformItemsForProgram(program)) {
                    programTreeItem.getChildren().add((Object)new TreeItem((Object)uniformViewItem));
                }
            }
        } else {
            rootNode = null;
        }
        Platform.runLater(() -> this.root.set((Object)rootNode));
    }

    private static List<UniformsViewItem> getUniformItemsForProgram(@NonNull GlProgramAsset currentProgramAsset) {
        ArrayList<UniformsViewItem> itemsToAdd = new ArrayList<UniformsViewItem>();
        for (ShaderUniform shaderUniform : currentProgramAsset.getUniformsContainer().getAllVariables()) {
            if (shaderUniform == null) continue;
            UniformsViewItem item = new UniformsViewItem(shaderUniform);
            itemsToAdd.add(item);
        }
        return itemsToAdd;
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> this.buildTree(snapshot));
    }
}

