/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.INavigationUriVisitor;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.Neighbours;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.UIUpdateTimerListener;
import com.arm.mgd.ui.controllers.TraceOutlineItem;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.utils.DynamicTreeItemWrapper;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.ui.utils.WeakSelection;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TreeItem;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceOutlineViewController
implements UIUpdateTimerListener,
ICommandDispatcher<INavigationElement<?>> {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyObjectWrapper<DynamicTreeItemWrapper> root = new ReadOnlyObjectWrapper();
    private boolean updating = false;
    private final @NonNull ReadOnlyBooleanWrapper collapseAllDisabled = new ReadOnlyBooleanWrapper(true);
    private final @NonNull ReadOnlyBooleanWrapper traceOutlineDataAvailable = new ReadOnlyBooleanWrapper(false);
    private @Nullable List<? extends TreeItem<TraceOutlineItem>> selectedTreeItems;
    private @Nullable TraceDataModel model;
    private @Nullable AbstractTarget target;
    private final @NonNull BooleanProperty filterTree = new SimpleBooleanProperty();
    private @Nullable DynamicTreeItemWrapper currentRootWrapper;
    private ReadOnlyObjectWrapper<WeakSelection<DynamicTreeItemWrapper>> weakSelection = new ReadOnlyObjectWrapper();
    private @Nullable NavigationUri currentNavigationURI;

    public TraceOutlineViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.traceOutlineDataAvailable.bind((ObservableValue)this.root.getReadOnlyProperty().isNotNull());
        this.collapseAllDisabled.bind((ObservableValue)this.root.isNull());
        this.filterTree.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!$assertionsDisabled && !Platform.isFxApplicationThread()) {
                    throw new AssertionError();
                }
                TraceOutlineViewController.this.updateSelection();
            }
        });
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
        Activator.uiUpdateTimer.addListener(this);
    }

    public void dispose() {
        assert (Platform.isFxApplicationThread());
        Activator.uiUpdateTimer.removeListener(this);
        this.navigationChangedListener.dispose();
        this.root.set(null);
        this.selectedTreeItems = null;
        this.model = null;
        this.target = null;
    }

    private synchronized void reloadData() {
        if (this.currentRootWrapper == null && this.model != null) {
            DynamicTreeItemWrapper newRootWrapper = new DynamicTreeItemWrapper(new TraceOutlineItem((INavigationElement<?>)this.model.getParentProcessTarget().getParentTarget()));
            newRootWrapper.refreshData(false);
            newRootWrapper.filterChildrenProperty().bind((ObservableValue)this.filterTree);
            this.currentRootWrapper = newRootWrapper;
            Platform.runLater(() -> this.root.set((Object)newRootWrapper));
        } else if (this.currentRootWrapper != null) {
            this.currentRootWrapper.refreshData(true);
        } else {
            Platform.runLater(() -> this.root.set(null));
        }
    }

    public @NonNull ReadOnlyObjectProperty<DynamicTreeItemWrapper> rootProperty() {
        return (ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.root.getReadOnlyProperty());
    }

    @Override
    public void onTick() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        this.reloadData();
        this.updating = false;
    }

    public void select(TreeItem<TraceOutlineItem> treeItem) {
        INavigationElement<?> item;
        @Nullable WeakSelection oldWeakSelection = (WeakSelection)this.weakSelection.get();
        if (oldWeakSelection != null) {
            ((TraceOutlineItem)((DynamicTreeItemWrapper)((Object)oldWeakSelection.getReferenceItem())).getValue()).setSelectionPosition(null);
        }
        if ((item = ((TraceOutlineItem)treeItem.getValue()).getItem()) != null) {
            CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri(item), (Object)this);
        }
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        this.currentNavigationURI = navigationUriChangeEvent.getNewNavigationUri();
        if (navigationUriChangeEvent.didNotOriginateHere((Object)this)) {
            navigationUriChangeEvent.newUriAccept((INavigationUriVisitor)new INavigationUriVisitor<Void>(){

                public Void dontCare() {
                    TraceOutlineViewController.this.model = null;
                    TraceOutlineViewController.this.target = null;
                    TraceOutlineViewController.this.currentRootWrapper = null;
                    return null;
                }

                public Void visit(@NonNull AbstractTarget newTarget, @NonNull TraceDataModel newModel) {
                    TraceOutlineViewController.this.model = newModel;
                    if (newTarget != TraceOutlineViewController.this.target) {
                        TraceOutlineViewController.this.target = newTarget;
                        TraceOutlineViewController.this.currentRootWrapper = null;
                    }
                    return null;
                }
            });
            this.reloadData();
            Platform.runLater(() -> this.updateSelection());
        }
    }

    private void updateSelection() {
        WeakSelection<DynamicTreeItemWrapper> newWeakSelection;
        assert (Platform.isFxApplicationThread());
        @Nullable WeakSelection oldWeakSelection = (WeakSelection)this.weakSelection.get();
        if (oldWeakSelection != null) {
            ((TraceOutlineItem)((DynamicTreeItemWrapper)((Object)oldWeakSelection.getReferenceItem())).getValue()).setSelectionPosition(null);
        }
        if ((newWeakSelection = this.getSelection(this.currentNavigationURI)) != null) {
            ((TraceOutlineItem)newWeakSelection.getReferenceItem().getValue()).setSelectionPosition(newWeakSelection.getSelectionPosition());
        }
        this.weakSelection.set(newWeakSelection);
    }

    public @Nullable WeakSelection<DynamicTreeItemWrapper> getSelection(@Nullable NavigationUri newValue) {
        final @Nullable DynamicTreeItemWrapper localCurrentRootWrapper = this.currentRootWrapper;
        if (localCurrentRootWrapper == null) {
            return null;
        }
        Neighbours neighbours = (Neighbours)NavigationUri.accept((NavigationUri)newValue, (INavigationUriVisitor)new INavigationUriVisitor<Neighbours<DynamicTreeItemWrapper>>(){

            public Neighbours<DynamicTreeItemWrapper> dontCare() {
                return null;
            }

            public Neighbours<DynamicTreeItemWrapper> visit(@NonNull AbstractTarget newTarget, @NonNull TraceDataModel newModel) {
                return TraceOutlineViewController.getProcessItemNeighbours(newModel, localCurrentRootWrapper);
            }

            public Neighbours<DynamicTreeItemWrapper> visit(@NonNull AbstractTarget newTarget, @NonNull TraceDataModel newModel, @NonNull Frame newFrame) {
                return TraceOutlineViewController.getFrameItemNeighbours(newModel, newFrame, localCurrentRootWrapper);
            }

            public Neighbours<DynamicTreeItemWrapper> visit(@NonNull AbstractTarget newTarget, @NonNull TraceDataModel newModel, @NonNull Frame newFrame, @NonNull FrameRenderPass newFrameRenderPass) {
                return TraceOutlineViewController.getRenderPassItemNeighbours(newModel, newFrame, newFrameRenderPass, localCurrentRootWrapper);
            }

            public Neighbours<DynamicTreeItemWrapper> visit(@NonNull AbstractTarget newTarget, @NonNull TraceDataModel newModel, @NonNull Frame newFrame, @NonNull FrameRenderPass newFrameRenderPass, @NonNull FunctionCall newFunctionCall) {
                return TraceOutlineViewController.getFunctionCallItemNeighbours(newModel, newFrame, newFrameRenderPass, newFunctionCall, localCurrentRootWrapper);
            }
        });
        if (neighbours != null) {
            return TraceOutlineViewController.getWeakTreeSelectionFromNeighbours((Neighbours<DynamicTreeItemWrapper>)neighbours);
        }
        return null;
    }

    private static @Nullable WeakSelection<DynamicTreeItemWrapper> getWeakTreeSelectionFromNeighbours(@NonNull Neighbours<DynamicTreeItemWrapper> neighbours) {
        DynamicTreeItemWrapper before = (DynamicTreeItemWrapper)((Object)neighbours.getBefore());
        DynamicTreeItemWrapper after = (DynamicTreeItemWrapper)((Object)neighbours.getAfter());
        DynamicTreeItemWrapper matching = (DynamicTreeItemWrapper)((Object)neighbours.getMatching());
        if (matching != null && matching.getValue() != null) {
            return new WeakSelection<DynamicTreeItemWrapper>(matching, WeakSelection.SelectionPosition.EXACT);
        }
        if (after != null && after.getValue() != null) {
            return new WeakSelection<DynamicTreeItemWrapper>(after, WeakSelection.SelectionPosition.BEFORE);
        }
        if (before != null && before.getValue() != null) {
            return new WeakSelection<DynamicTreeItemWrapper>(before, WeakSelection.SelectionPosition.AFTER);
        }
        return null;
    }

    private static <T extends INavigationElement<T>> @NonNull Neighbours<DynamicTreeItemWrapper> getTreeItemNeighbours(@NonNull T itemToFind, @NonNull DynamicTreeItemWrapper rootItem) {
        return BinarySearchList.findNeighbours(rootItem.getFilteredChildren(), that -> {
            assert (that != null);
            INavigationElement<?> treeItemValue = ((TraceOutlineItem)that.getValue()).getItem();
            return treeItemValue == null ? 1 : treeItemValue.compareTo((Object)itemToFind);
        });
    }

    private static @NonNull Neighbours<DynamicTreeItemWrapper> getProcessItemNeighbours(@NonNull TraceDataModel newModel, @NonNull DynamicTreeItemWrapper rootNode) {
        return TraceOutlineViewController.getTreeItemNeighbours(newModel, rootNode);
    }

    private static @NonNull Neighbours<DynamicTreeItemWrapper> getFrameItemNeighbours(@NonNull TraceDataModel newModel, @NonNull Frame newFrame, @NonNull DynamicTreeItemWrapper processNode) {
        Neighbours<DynamicTreeItemWrapper> processNeighbours = TraceOutlineViewController.getProcessItemNeighbours(newModel, processNode);
        DynamicTreeItemWrapper matchingProcess = (DynamicTreeItemWrapper)((Object)processNeighbours.getMatching());
        if (matchingProcess == null) {
            return processNeighbours;
        }
        return TraceOutlineViewController.getTreeItemNeighbours(newFrame, matchingProcess);
    }

    private static @NonNull Neighbours<DynamicTreeItemWrapper> getRenderPassItemNeighbours(@NonNull TraceDataModel newModel, @NonNull Frame newFrame, @NonNull FrameRenderPass newFrameRenderPass, @NonNull DynamicTreeItemWrapper frameNode) {
        Neighbours<DynamicTreeItemWrapper> frameNeighbours = TraceOutlineViewController.getFrameItemNeighbours(newModel, newFrame, frameNode);
        DynamicTreeItemWrapper matchingFrame = (DynamicTreeItemWrapper)((Object)frameNeighbours.getMatching());
        if (matchingFrame == null) {
            return frameNeighbours;
        }
        return TraceOutlineViewController.getTreeItemNeighbours(newFrameRenderPass, matchingFrame);
    }

    private static @NonNull Neighbours<DynamicTreeItemWrapper> getFunctionCallItemNeighbours(@NonNull TraceDataModel newModel, @NonNull Frame newFrame, @NonNull FrameRenderPass newFrameRenderPass, @NonNull FunctionCall newFunctionCall, @NonNull DynamicTreeItemWrapper functionCallNode) {
        Neighbours<DynamicTreeItemWrapper> renderPassNeighbours = TraceOutlineViewController.getRenderPassItemNeighbours(newModel, newFrame, newFrameRenderPass, functionCallNode);
        DynamicTreeItemWrapper matchingRenderPass = (DynamicTreeItemWrapper)((Object)renderPassNeighbours.getMatching());
        if (matchingRenderPass == null) {
            return renderPassNeighbours;
        }
        Neighbours<DynamicTreeItemWrapper> functionCallNeighbours = TraceOutlineViewController.getTreeItemNeighbours(newFunctionCall, matchingRenderPass);
        if (functionCallNeighbours.getMatching() == null && functionCallNeighbours.getBefore() == null && functionCallNeighbours.getAfter() == null) {
            return renderPassNeighbours;
        }
        return functionCallNeighbours;
    }

    public void collapseAll() {
        assert (Platform.isFxApplicationThread());
        if (this.currentRootWrapper != null) {
            this.currentRootWrapper.collapseAllChildren();
        }
    }

    public @NonNull ReadOnlyBooleanProperty collapseAllDisabledProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.collapseAllDisabled.getReadOnlyProperty());
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super INavigationElement<?>> command) {
        command.execute(null, this.getSelectedItems());
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super INavigationElement<?>> command) {
        return command.isEnabled(null, this.getSelectedItems());
    }

    private @NonNull List<@NonNull INavigationElement<?>> getSelectedItems() {
        ArrayList<@NonNull INavigationElement<?>> selectedItems = new ArrayList();
        if (this.selectedTreeItems != null) {
            for (TreeItem<TraceOutlineItem> treeItem : this.selectedTreeItems) {
                assert (treeItem != null) : "Not expecting a null item in tree view.";
                INavigationElement<?> item = ((TraceOutlineItem)treeItem.getValue()).getItem();
                if (item == null) continue;
                selectedItems.add(item);
            }
        }
        return selectedItems;
    }

    public void setSelectedItems(ObservableList<? extends TreeItem<TraceOutlineItem>> observableList) {
        this.selectedTreeItems = new SortedList(observableList);
    }

    public @NonNull String getDescriptionForItem(@Nullable INavigationElement<?> item) {
        if (item == null) {
            return "";
        }
        if (item instanceof InterestingFunctionCall) {
            return ((InterestingFunctionCall)item).getInterestingCallData().getDescriptiveText();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean printedFirstStatistic = false;
        int statisticTypeIndex = 0;
        while (statisticTypeIndex < CommonStatistics.values().length) {
            IStatisticType statisticType = (IStatisticType)NullUtils.neverNull((Object)CommonStatistics.values()[statisticTypeIndex]);
            if (item.hasDataForStatisticType(statisticType)) {
                if (printedFirstStatistic) {
                    stringBuilder.append(", ");
                } else {
                    printedFirstStatistic = true;
                }
                stringBuilder.append(item.getStatistic(statisticType).getValueString());
            }
            ++statisticTypeIndex;
        }
        return (String)NullUtils.neverNull((Object)stringBuilder.toString());
    }

    public ReadOnlyObjectProperty<WeakSelection<DynamicTreeItemWrapper>> weakSelectionProperty() {
        return this.weakSelection.getReadOnlyProperty();
    }

    public @NonNull BooleanProperty filterTreeProperty() {
        return this.filterTree;
    }

    public ReadOnlyBooleanProperty isTraceDataAvailable() {
        return this.traceOutlineDataAvailable.getReadOnlyProperty();
    }
}

