/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.BookmarkModel;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.DialogFileTypes;
import com.arm.mgd.ui.UIHandler;
import com.arm.mgd.ui.UIUpdateTimerListener;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.editorinput.TargetEditorInput;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.ui.views.TraceEditorMarkerSets;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.util.Callback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.PlatformUI;

public class TraceEditorController
implements UIUpdateTimerListener,
ICommandDispatcher<FunctionCall> {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ObservableList<@NonNull FunctionCall> functionCallList = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull TargetEditorInput traceEditorInput;
    private final @NonNull AbstractTarget target;
    private int prevItemCount = 0;
    private volatile boolean isRefreshing = false;
    private final @NonNull StringProperty editorName = new SimpleStringProperty();
    private final @NonNull ObjectProperty<@Nullable TraceDataModel> currentModel = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<FunctionCall> selectedFunctionCall = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable ObservableList<FunctionCall>> selectedFunctionCallsList = new SimpleObjectProperty();
    private @Nullable SelectedFunctionCalls currentlySelectedFunctionCalls = null;
    private final @NonNull InvalidationListener currentlySelectedFunctionCallsInvalidationListener = observable -> {
        SelectedFunctionCalls selectedFunctionCalls = this.currentlySelectedFunctionCalls = null;
    };
    private final @NonNull IntegerProperty preferredTraceSelection;
    private final @NonNull ReadOnlyObjectWrapper<@Nullable FunctionCall> currentResolvedLocation = new ReadOnlyObjectWrapper(null);
    private final @NonNull BooleanProperty refreshUi = new SimpleBooleanProperty(false);
    private final @NonNull TraceEditorMarkerSets markerSets = new TraceEditorMarkerSets();
    private final @NonNull List<WeakReference<ExternallyUpdateableStringProperty>> listOfNoteProperties = new ArrayList<WeakReference<ExternallyUpdateableStringProperty>>();
    private final @NonNull ICommand<FunctionCall> copyCommand = new ICommand<FunctionCall>(){

        @Override
        public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FunctionCall> selection) {
            TraceEditorController.copySelected(selection);
        }

        @Override
        public @NonNull String getLabel() {
            return "Copy";
        }

        @Override
        public boolean isEnabled(@Nullable TraceDataModel model, List<@NonNull ? extends FunctionCall> selection) {
            return !selection.isEmpty();
        }
    };
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull BookmarkModel.IBookmarkChangeListener bookmarksListener;
    private final @NonNull AtomicBoolean isUpdatingBookmarks = new AtomicBoolean(false);

    public TraceEditorController(@NonNull ReadOnlyBooleanProperty enabledProperty, @NonNull TargetEditorInput ei) {
        this.traceEditorInput = ei;
        this.target = ei.getTargetConnection().getTarget();
        this.preferredTraceSelection = new SimpleIntegerProperty();
        this.bookmarksListener = new BookmarkModel.IBookmarkChangeListener(){

            public boolean onBookmarksChange(@NonNull TraceDataModel model, @NonNull Map<@NonNull FunctionCall, // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable BookmarkModel.Bookmark> modifiedBookmarks) {
                if (!TraceEditorController.this.isUpdatingBookmarks.compareAndSet(false, true)) {
                    return false;
                }
                Platform.runLater(() -> {
                    try {
                        TraceEditorController.this.updateBookmarks(model, modifiedBookmarks);
                    }
                    finally {
                        TraceEditorController.this.isUpdatingBookmarks.set(false);
                    }
                });
                return true;
            }
        };
        this.currentModel.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.getBookmarkModel().removeListener(this.bookmarksListener);
                this.functionCallList.clear();
                this.markerSets.clearAll();
                this.preferredTraceSelection.set(0);
                this.prevItemCount = 0;
            }
            if (newValue != null) {
                ArrayList<@NonNull E> newMarkerSets = new ArrayList();
                newValue.getBookmarkModel().addListener((fc, bookmark) -> {
                    boolean bl = newMarkerSets.add(NullUtils.intValueOf((int)fc.getIndex()));
                }, this.bookmarksListener);
                this.markerSets.getNotesMarkerSet().setActivePositions(newMarkerSets);
                this.refreshContent();
            }
        });
        this.selectedFunctionCall.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (newValue != null && this.currentResolvedLocation.get() != newValue) {
                this.currentResolvedLocation.set(newValue);
                CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)newValue), (Object)this);
            }
        });
        this.currentModel.addListener(this.currentlySelectedFunctionCallsInvalidationListener);
        this.selectedFunctionCallsList.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeListener(this.currentlySelectedFunctionCallsInvalidationListener);
            }
            if (newValue != null) {
                newValue.addListener(this.currentlySelectedFunctionCallsInvalidationListener);
            }
        });
        Activator.uiUpdateTimer.addListener(this);
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        Activator.uiUpdateTimer.removeListener(this);
        this.currentResolvedLocation.set(null);
        this.selectedFunctionCall.unbind();
        this.selectedFunctionCallsList.set(null);
        this.functionCallList.clear();
        this.traceEditorInput.release();
    }

    public void bindSelectedFunctionCalls(@NonNull ReadOnlyObjectProperty<FunctionCall> selectedFunctionCallProperty, @NonNull ObservableList<FunctionCall> selectedFunctionCalls) {
        this.selectedFunctionCall.bind(selectedFunctionCallProperty);
        this.selectedFunctionCallsList.set(selectedFunctionCalls);
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable FunctionCall> currentResolvedLocationProperty() {
        return (ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.currentResolvedLocation.getReadOnlyProperty());
    }

    public @NonNull BooleanProperty refreshUi() {
        return this.refreshUi;
    }

    @Override
    public void onTick() {
        if (this.isRefreshing) {
            return;
        }
        this.isRefreshing = true;
        Platform.runLater(() -> {
            try {
                this.refreshContent();
                this.refreshUi.set(!this.refreshUi.get());
            }
            finally {
                this.isRefreshing = false;
            }
        });
    }

    public @NonNull ObservableList<@NonNull FunctionCall> getFunctionCallList() {
        return this.functionCallList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void refreshContent() {
        assert (Platform.isFxApplicationThread());
        TraceDataModel model = (TraceDataModel)this.currentModel.get();
        if (model == null) {
            return;
        }
        int newNumberOfItems = model.count();
        int numberOfItemsToProcess = newNumberOfItems - this.prevItemCount;
        if (numberOfItemsToProcess > 0) {
            @NonNull List newCalls = model.getCallItems(this.prevItemCount, numberOfItemsToProcess);
            this.functionCallList.addAll((Collection)newCalls);
            this.prevItemCount = newNumberOfItems;
        }
        this.editorName.setValue(this.traceEditorInput.getName());
    }

    public @NonNull TargetEditorInput getTraceEditorInput() {
        return this.traceEditorInput;
    }

    public void doSave(@NonNull IProgressMonitor monitor) {
        TargetConnectionManager.pauseAllLiveTraces();
        File selectedFile = this.getTraceEditorInput().canSave() ? this.getTraceEditorInput().getCurrentFile() : FileDialogHelper.promptForFile(DialogFileTypes.SAVE_TRACE, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true, this.traceEditorInput.getCurrentFile());
        if (selectedFile == null) {
            monitor.setCanceled(true);
            return;
        }
        Job job = this.saveTraceFileJob(selectedFile);
        job.setUser(true);
        job.setRule(TargetEditorInput.EDITOR_CLOSE_SCHEDULING_RULE);
        job.schedule();
    }

    private Job saveTraceFileJob(final @NonNull File selectedFile) {
        return new Job("Saving trace file"){

            protected IStatus run(IProgressMonitor progressMonitor) {
                try {
                    if (!$assertionsDisabled && progressMonitor == null) {
                        throw new AssertionError();
                    }
                    TraceEditorController.this.getTraceEditorInput().saveAs(progressMonitor, selectedFile);
                    Platform.runLater(() -> TraceEditorController.this.editorName.set((Object)TraceEditorController.this.getTraceEditorInput().getName()));
                    return progressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
                catch (Exception e) {
                    UIHandler.errorMessage("Unable to Save", e.getLocalizedMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
    }

    public boolean isSaveAsAllowed() {
        return this.traceEditorInput.getTargetConnection().getTarget().getTotalFunctionCallCount() > 0;
    }

    public void doSaveAs() {
        TargetConnectionManager.pauseAllLiveTraces();
        File selectedFile = FileDialogHelper.promptForFile(DialogFileTypes.SAVE_TRACE, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true, this.traceEditorInput.getCurrentFile());
        if (selectedFile == null) {
            return;
        }
        Job job = this.saveTraceFileJob(selectedFile);
        job.setUser(true);
        job.setRule(TargetEditorInput.EDITOR_CLOSE_SCHEDULING_RULE);
        job.schedule();
    }

    public @NonNull ReadOnlyStringProperty getEditorName() {
        return this.editorName;
    }

    public @NonNull ReadOnlyIntegerProperty getPreferredTraceSelection() {
        return this.preferredTraceSelection;
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        if (!navigationUriChangeEvent.didNotOriginateHere((Object)this)) {
            return;
        }
        navigationUriChangeEvent.getNewResolvedFunctionCall(newFunction -> {
            if (newFunction != null && newFunction.getModel().getParentProcessTarget().getParentTarget() == this.target) {
                Platform.runLater(() -> {
                    this.currentModel.set((Object)newFunction.getModel());
                    this.currentResolvedLocation.set(newFunction);
                });
            }
            return null;
        });
    }

    public void navigateToNewFunctionNumber(int functionCallIndex, @NonNull Object source) {
        assert (Platform.isFxApplicationThread());
        TraceDataModel model = (TraceDataModel)this.currentModel.get();
        assert (model != null);
        CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)model.getCallItem(functionCallIndex)), source);
    }

    public @NonNull ICommand<FunctionCall> getCopyCommand() {
        return this.copyCommand;
    }

    private @NonNull SelectedFunctionCalls getSelectedFunctionCalls() {
        assert (Platform.isFxApplicationThread());
        SelectedFunctionCalls selected = this.currentlySelectedFunctionCalls;
        if (selected == null) {
            selected = new SelectedFunctionCalls();
        }
        this.currentlySelectedFunctionCalls = selected;
        return selected;
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super FunctionCall> command) {
        assert (Platform.isFxApplicationThread());
        SelectedFunctionCalls selected = this.getSelectedFunctionCalls();
        if (selected.model != null) {
            command.execute(selected.model, selected.selectedFunctionCalls);
        }
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super FunctionCall> command) {
        assert (Platform.isFxApplicationThread());
        SelectedFunctionCalls selected = this.getSelectedFunctionCalls();
        if (selected.model != null) {
            return command.isEnabled(selected.model, selected.selectedFunctionCalls);
        }
        return false;
    }

    private static void copySelected(@NonNull List<? extends @NonNull FunctionCall> selectedItems) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (FunctionCall functionCall : selectedItems) {
            stringBuilder.append(functionCall.getIndex()).append("\t");
            stringBuilder.append(functionCall.getFullNameAndArguments()).append("\n");
        }
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            content.putString(string);
            clipboard.setContent((Map)content);
        }
    }

    public void toggleNotes() {
        Platform.runLater(() -> this.markerSets.getNotesMarkerSet().setVisible(!this.markerSets.getNotesMarkerSet().isVisible()));
    }

    public @NonNull TraceEditorMarkerSets getMarkerSets() {
        return this.markerSets;
    }

    public @NonNull AbstractTarget getTarget() {
        return this.target;
    }

    public void addEmptyBookmarks() {
        assert (Platform.isFxApplicationThread());
        SelectedFunctionCalls selected = this.getSelectedFunctionCalls();
        if (selected.model != null) {
            selected.model.getBookmarkModel().addEmptyBookmarks(selected.selectedFunctionCalls);
        }
    }

    public void removeBookmarks() {
        assert (Platform.isFxApplicationThread());
        SelectedFunctionCalls selected = this.getSelectedFunctionCalls();
        if (selected.model != null) {
            selected.model.getBookmarkModel().removeBookmarks(selected.selectedFunctionCalls);
        }
    }

    public Callback<TableColumn.CellDataFeatures<FunctionCall, String>, ObservableValue<String>> getNotesCellFactory() {
        return new Callback<TableColumn.CellDataFeatures<FunctionCall, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<FunctionCall, String> param) {
                FunctionCall fc = (FunctionCall)param.getValue();
                BookmarkModel.Bookmark b = fc.getModel().getBookmarkModel().getBookmark(fc);
                String note = b != null ? b.getNote() : null;
                ExternallyUpdateableStringProperty stringProperty = new ExternallyUpdateableStringProperty(note);
                TraceEditorController.this.listOfNoteProperties.add(new WeakReference<ExternallyUpdateableStringProperty>(stringProperty));
                return stringProperty;
            }
        };
    }

    private void updateBookmarks(@NonNull TraceDataModel model, @NonNull Map<@NonNull FunctionCall, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable BookmarkModel.Bookmark> modifiedBookmarks) {
        if (model.equals(this.currentModel.get())) {
            @NonNull LinkedHashSet<@NonNull Integer> additions = new LinkedHashSet<Integer>();
            @NonNull LinkedHashSet<@NonNull Integer> removals = new LinkedHashSet<Integer>();
            for (Map.Entry<FunctionCall, BookmarkModel.Bookmark> entry : modifiedBookmarks.entrySet()) {
                @NonNull FunctionCall fc = entry.getKey();
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable BookmarkModel.Bookmark bookmark = entry.getValue();
                if (bookmark != null) {
                    additions.add(NullUtils.intValueOf((int)fc.getIndex()));
                    continue;
                }
                removals.add(NullUtils.intValueOf((int)fc.getIndex()));
            }
            this.markerSets.getNotesMarkerSet().removeActivePositions(removals);
            this.markerSets.getNotesMarkerSet().addActivePositions(additions);
            this.updateNoteProperties();
        }
    }

    private void updateNoteProperties() {
        ArrayList<WeakReference<ExternallyUpdateableStringProperty>> nullItemsToRemove = new ArrayList<WeakReference<ExternallyUpdateableStringProperty>>();
        for (WeakReference<ExternallyUpdateableStringProperty> property : this.listOfNoteProperties) {
            ExternallyUpdateableStringProperty externallyUpdateableStringProperty = (ExternallyUpdateableStringProperty)((Object)property.get());
            if (externallyUpdateableStringProperty != null) {
                externallyUpdateableStringProperty.fireChangedEvent();
                continue;
            }
            nullItemsToRemove.add(property);
        }
        this.listOfNoteProperties.removeAll(nullItemsToRemove);
    }

    private class ExternallyUpdateableStringProperty
    extends SimpleStringProperty {
        public ExternallyUpdateableStringProperty(String string) {
            super(string);
        }

        public void fireChangedEvent() {
            this.fireValueChangedEvent();
        }
    }

    private class SelectedFunctionCalls {
        private final @Nullable TraceDataModel model;
        private final @NonNull List<@NonNull FunctionCall> selectedFunctionCalls;

        private SelectedFunctionCalls() {
            assert (Platform.isFxApplicationThread());
            this.model = (TraceDataModel)TraceEditorController.this.currentModel.get();
            List fcs = (List)TraceEditorController.this.selectedFunctionCallsList.get();
            if (this.model != null && fcs != null) {
                ArrayList<@NonNull FunctionCall> selected = new ArrayList<FunctionCall>(fcs.size());
                for (FunctionCall fc : fcs) {
                    if (fc == null || fc.getModel() != this.model) continue;
                    selected.add(fc);
                }
                this.selectedFunctionCalls = NullUtils.unmodifiableList(selected);
            } else {
                this.selectedFunctionCalls = NullUtils.EMPTY_LIST;
            }
        }
    }
}

