/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModelListener;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.UIUpdateTimerListener;
import com.arm.mgd.ui.controllers.TraceAnalysisItem;
import com.arm.mgd.ui.filterruler.MarkerSet;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.ObjectChangeWrapper;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.ui.views.TraceEditor;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceAnalysisViewController
implements TraceAnalysisModelListener,
UIUpdateTimerListener,
InvalidationListener {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull BooleanProperty copyEnabled = new SimpleBooleanProperty(false);
    private final @NonNull ObjectChangeWrapper<ModelAndMarkers> modelAndMarkers;
    private final @NonNull ObjectChangeWrapper.RebindInterface<ModelAndMarkers> modelAndMarkersListenerBinder;
    private final @NonNull ObservableList<TraceAnalysisItem> selectedItems = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull SelectionChangeListener selectionChangeListener = new SelectionChangeListener();
    private final @NonNull ObservableList<TraceAnalysisItem> traceAnalysisList = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull Map<TraceAnalysis, TraceAnalysisItem> traceAnalysisMap = new HashMap<TraceAnalysis, TraceAnalysisItem>();
    private @NonNull WeakReference<@Nullable TraceDataModel> currentModel = NullUtils.emptyWeakReference();

    public TraceAnalysisViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.modelAndMarkersListenerBinder = new ObjectChangeWrapper.RebindInterface<ModelAndMarkers>(){

            @Override
            public void addNewListeners(@NonNull ModelAndMarkers newObject) {
                newObject.traceAnalysisModel.listeners.add((Object)TraceAnalysisViewController.this);
                Activator.uiUpdateTimer.addListener(TraceAnalysisViewController.this);
            }

            @Override
            public void removeOldListeners(@NonNull ModelAndMarkers oldObject) {
                Activator.uiUpdateTimer.removeListener(TraceAnalysisViewController.this);
                oldObject.traceAnalysisModel.listeners.remove((Object)TraceAnalysisViewController.this);
            }
        };
        this.modelAndMarkers = new ObjectChangeWrapper<ModelAndMarkers>(this.modelAndMarkersListenerBinder);
        this.copyEnabled.bind((ObservableValue)Bindings.size(this.selectedItems).greaterThan(0));
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        this.modelAndMarkers.set(null);
        this.selectedItems.clear();
    }

    public BooleanProperty copyEnabledProperty() {
        return this.copyEnabled;
    }

    public EventHandler<ActionEvent> getCopyHandler() {
        return event -> Platform.runLater(() -> this.copySelected());
    }

    public SelectionChangeListener getSelectionChangeListener() {
        return this.selectionChangeListener;
    }

    public ObservableList<TraceAnalysisItem> getTraceAnalyses() {
        return this.traceAnalysisList;
    }

    public void invalidated(Observable ignored) {
        this.reloadData();
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> navigationUriChangeEvent.getNewModel(newModel -> {
            TraceDataModel oldModel = (TraceDataModel)this.currentModel.get();
            if (newModel != oldModel) {
                this.modelAndMarkers.set(null);
                if (newModel != null) {
                    TraceAnalysisModel newTraceAnalysesModel = newModel.getTraceAnalysisModel();
                    TraceEditor traceEditor = TargetConnectionManager.findEditorForModel(newModel);
                    assert (traceEditor != null);
                    MarkerSet newAnalysesMarkerSet = traceEditor.getMarkerSets().getAnalysisMarkerSet();
                    this.modelAndMarkers.set(new ModelAndMarkers(newTraceAnalysesModel, newAnalysesMarkerSet));
                }
                this.reloadData();
                this.selectedItems.clear();
                this.currentModel = new WeakReference<TraceDataModel>((TraceDataModel)newModel);
            }
            return null;
        }));
    }

    @Override
    public void onTick() {
        try {
            ModelAndMarkers currentModelAndMarkers = this.modelAndMarkers.get();
            if (currentModelAndMarkers != null && !currentModelAndMarkers.traceAnalysisModel.getTraceModel().isClosed()) {
                currentModelAndMarkers.traceAnalysisModel.evaluateAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onTraceAnalysisAdded(TraceAnalysis problemAdded) {
        TraceAnalysisItem newItem = new TraceAnalysisItem(problemAdded);
        TraceAnalysisItem oldItem = this.traceAnalysisMap.put(problemAdded, newItem);
        assert (oldItem == null);
        Platform.runLater(() -> {
            boolean bl = this.traceAnalysisList.add((Object)newItem);
        });
    }

    public void onTraceAnalysisChanged(TraceAnalysis problemChanged) {
        TraceAnalysisItem problemToUpdate = this.traceAnalysisMap.get(problemChanged);
        if (problemToUpdate != null) {
            Platform.runLater(() -> problemToUpdate.reloadData());
        }
    }

    public void onTraceAnalysisRemoved(TraceAnalysis problemRemoved) {
        TraceAnalysisItem problemToRemove = this.traceAnalysisMap.get(problemRemoved);
        if (problemToRemove != null) {
            Platform.runLater(() -> {
                boolean bl = this.traceAnalysisList.remove((Object)problemToRemove);
            });
        }
    }

    private void copySelected() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (TraceAnalysisItem traceAnalysisItem : this.selectedItems) {
            assert (traceAnalysisItem != null);
            stringBuilder.append(traceAnalysisItem.getType());
            stringBuilder.append(" " + traceAnalysisItem.messageProperty().getValue());
            stringBuilder.append(" " + traceAnalysisItem.countProperty().getValue());
            stringBuilder.append("\n");
        }
        String stringToCopy = stringBuilder.toString();
        if (!stringToCopy.isEmpty()) {
            content.putString(stringToCopy);
            clipboard.setContent((Map)content);
        }
    }

    private void reloadData() {
        this.traceAnalysisMap.clear();
        Platform.runLater(() -> this.traceAnalysisList.clear());
        ModelAndMarkers currentModelAndMarkers = this.modelAndMarkers.get();
        if (currentModelAndMarkers != null) {
            for (TraceAnalysis problem : currentModelAndMarkers.traceAnalysisModel.getAnalyses()) {
                this.onTraceAnalysisAdded(problem);
            }
        }
    }

    private static class ModelAndMarkers {
        public final @NonNull MarkerSet analysisMarkerSet;
        public final @NonNull TraceAnalysisModel traceAnalysisModel;

        public ModelAndMarkers(@NonNull TraceAnalysisModel traceAnalysisModel, @NonNull MarkerSet analysisMarkerSet) {
            this.traceAnalysisModel = traceAnalysisModel;
            this.analysisMarkerSet = analysisMarkerSet;
        }
    }

    private class SelectionChangeListener
    implements ListChangeListener<TraceAnalysisItem> {
        private SelectionChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TraceAnalysisItem> change) {
            ModelAndMarkers currentModelAndMarkers = TraceAnalysisViewController.this.modelAndMarkers.get();
            if (currentModelAndMarkers != null) {
                TraceAnalysisViewController.this.selectedItems.clear();
                HashSet<@NonNull E> newMarkers = new HashSet();
                while (change.next()) {
                    TraceAnalysisViewController.this.selectedItems.addAll((Collection)change.getList());
                }
                for (TraceAnalysisItem problemItem : TraceAnalysisViewController.this.selectedItems) {
                    problemItem.copyLocations(newMarkers);
                }
                currentModelAndMarkers.analysisMarkerSet.setActivePositions(newMarkers);
            }
        }
    }
}

