/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import java.util.Set;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import org.eclipse.jdt.annotation.NonNull;

public class TraceAnalysisItem {
    private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper();
    private final ReadOnlyIntegerWrapper count = new ReadOnlyIntegerWrapper();
    private final TraceAnalysis analysis;

    public TraceAnalysisItem(TraceAnalysis analysis) {
        this.analysis = analysis;
        this.message.set(analysis.getMessage());
        this.count.set(analysis.getCount());
    }

    public boolean equals(Object other) {
        if (!(other instanceof TraceAnalysisItem)) {
            return false;
        }
        TraceAnalysisItem otherItem = (TraceAnalysisItem)other;
        return this.analysis.equals((Object)otherItem.analysis);
    }

    public void reloadData() {
        this.message.set(this.analysis.getMessage());
        this.count.set(this.analysis.getCount());
    }

    public String getDescription() {
        return this.analysis.getDescription();
    }

    public final ReadOnlyStringProperty messageProperty() {
        return this.message.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty countProperty() {
        return this.count.getReadOnlyProperty();
    }

    public TraceAnalysis.AnalysisType getType() {
        return this.analysis.getType();
    }

    public void copyLocations(@NonNull Set<? super Integer> into) {
        this.analysis.copyLocations(into);
    }

    public int hashCode() {
        return this.analysis.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": message= " + this.message + ", count= " + this.count;
    }
}

