/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.texture.GlTextureCompositor;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.EditorInputManager;
import com.arm.mgd.ui.controllers.commands.IExportable;
import com.arm.mgd.ui.controllers.commands.IOpenable;
import com.arm.mgd.ui.views.widgets.WeakProxyImageProvider;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.StringJoiner;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TexturesViewItem
implements IOpenable,
IExportable<GlTextureAsset> {
    private @NonNull WeakReference<@Nullable GlTextureAsset> textureAsset = NullUtils.emptyWeakReference();
    private final @NonNull ObjectProperty<@Nullable WeakProxyImageProvider> thumbnail = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable IImageProvider> imageProviderProperty = new SimpleObjectProperty();
    private final @NonNull LongProperty textureId = new SimpleLongProperty();
    private final @NonNull StringProperty textureTarget = new SimpleStringProperty();
    private final @NonNull ObjectProperty<@Nullable Dimension> size = new SimpleObjectProperty();
    private final @NonNull StringProperty internalFormat = new SimpleStringProperty();
    private final @NonNull StringProperty formatTypePairs = new SimpleStringProperty();
    private final @NonNull StringProperty note = new SimpleStringProperty();

    public TexturesViewItem() {
        this.imageProviderProperty.bind(this.thumbnail);
    }

    public void set(@NonNull GlTextureAsset textureAssetParam) {
        @Nullable GlTextureAsset oldTextureAsset = (GlTextureAsset)this.textureAsset.get();
        this.textureAsset = new WeakReference<GlTextureAsset>(textureAssetParam);
        this.textureId.set(textureAssetParam.getId().longValue());
        this.note.set((Object)textureAssetParam.getNote());
        AbstractConstantOrAliasSpecExtended targetConst = textureAssetParam.getTextureTarget();
        this.textureTarget.set((Object)(targetConst != null ? targetConst.getName() : null));
        GlTextureImageAsset textureImage = textureAssetParam.getTextureMipmapImage();
        GlTextureCompositor newImageProvider = null;
        if (textureImage != null) {
            GlTextureImageAsset mappedImageAsset;
            this.formatTypePairs.set((Object)textureImage.getGlTextureCompositor().getGlFormatTypeDescription());
            boolean isCubemapCrossImage = textureImage.getParentAsset().isCubeMapCrossImageSurface();
            GlTextureImageAsset glTextureImageAsset = mappedImageAsset = isCubemapCrossImage ? textureImage.mapCubeMapFaceCrossCompositorToAnyCubeMapFace() : textureImage;
            if (mappedImageAsset != null) {
                this.internalFormat.set((Object)mappedImageAsset.getInternalFormat().getName());
                this.size.set((Object)mappedImageAsset.getSize());
                newImageProvider = textureImage.getGlTextureCompositor();
            }
        }
        if (newImageProvider == null) {
            this.thumbnail.set(null);
        } else {
            WeakProxyImageProvider proxyProvider = (WeakProxyImageProvider)this.thumbnail.get();
            if (proxyProvider == null || TexturesViewItem.hasAssetChanged(oldTextureAsset, textureAssetParam)) {
                this.thumbnail.set((Object)new WeakProxyImageProvider((IImageProvider)newImageProvider));
            } else {
                proxyProvider.updateImageProvider((IImageProvider)newImageProvider);
            }
        }
    }

    private static boolean hasAssetChanged(@Nullable GlTextureAsset oldAsset, @NonNull GlTextureAsset newAsset) {
        @Nullable FunctionCall oldLastModificationCall = oldAsset != null ? (FunctionCall)NullUtils.nonNullOrDefault((Object)oldAsset.getPreviousModificationFunction(), (Object)oldAsset.getCreatedByFunction()) : null;
        @NonNull FunctionCall newLastModificationCall = (FunctionCall)NullUtils.nonNullOrDefault((Object)newAsset.getPreviousModificationFunction(), (Object)newAsset.getCreatedByFunction());
        return !newLastModificationCall.equals((Object)oldLastModificationCall);
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable IImageProvider> imageProviderProperty() {
        return this.imageProviderProperty;
    }

    public @NonNull ReadOnlyLongProperty textureIdProperty() {
        return this.textureId;
    }

    public @NonNull ReadOnlyStringProperty textureTargetProperty() {
        return this.textureTarget;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Dimension> sizeProperty() {
        return this.size;
    }

    public @NonNull ReadOnlyStringProperty formatTypePairsProperty() {
        return this.formatTypePairs;
    }

    public @NonNull ReadOnlyStringProperty noteProperty() {
        return this.note;
    }

    public @NonNull ReadOnlyStringProperty internalFormatProperty() {
        return this.internalFormat;
    }

    @Override
    public @Nullable GlTextureAsset getAsset() {
        return (GlTextureAsset)this.textureAsset.get();
    }

    @Override
    public @NonNull String getClipboardContent() {
        StringJoiner stringJoiner = new StringJoiner(",");
        @Nullable Dimension itemSize = (Dimension)this.size.getValue();
        String sizeString = itemSize != null ? itemSize.toString() : "";
        stringJoiner.add(this.textureIdProperty().getValue().toString()).add(sizeString).add(this.internalFormatProperty().getValue()).add(this.formatTypePairsProperty().getValue()).add(this.noteProperty().getValue());
        return (String)NullUtils.neverNull((Object)stringJoiner.toString());
    }

    @Override
    public boolean isAvailable() {
        return this.thumbnail.get() != null;
    }

    @Override
    public void open() {
        GlTextureAsset asset = this.getAsset();
        if (asset != null) {
            EditorInputManager.openEditor(asset);
        }
    }
}

