/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.FutureExceptionFunction;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.StateVariableTypeSpec;
import com.arm.mgd.lightweight.model.IApiModelWithState;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemBase;
import com.arm.mgd.lightweight.state.IStateItemContainer;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.StateItemValueFormatter;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetStateViewController
implements ICommandDispatcher<TargetStateViewItem> {
    private @Nullable GetStateDataTask activeTask = null;
    private final @NonNull ICommand<TargetStateViewItem> copyCommand = new ICommand<TargetStateViewItem>(){

        @Override
        public void execute(TraceDataModel model, List<? extends TargetStateViewItem> selection) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void execute(TracedProcess model, FunctionCall functionCall, List<? extends TargetStateViewItem> selection) {
            TargetStateViewController.copySelected((List)NullUtils.neverNull(selection));
        }

        @Override
        public @NonNull String getLabel() {
            return "Copy";
        }

        @Override
        public boolean isEnabled(TraceDataModel model, List<? extends TargetStateViewItem> selection) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }

        @Override
        public boolean isEnabled(TracedProcess model, FunctionCall functionCall, List<? extends TargetStateViewItem> selection) {
            return !selection.isEmpty();
        }
    };
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private @Nullable FunctionCall currentFunctionCall;
    private @Nullable TracedProcess currentLightweightProcessModel;
    private final @NonNull ExecutorService executor = NamedExecutors.cachedFiniteThreadPool((int)1, (long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("TargetStateViewController Executor"));
    private final FilteredList<TargetStateViewItem> filteredData;
    private final @NonNull ObjectProperty<StateFilterMode> filterOnlyChangedThisFunction = new SimpleObjectProperty();
    private final @NonNull ReadOnlyStringWrapper filterPatternError = new ReadOnlyStringWrapper();
    private final @NonNull StringProperty filterText = new SimpleStringProperty("");
    private final @NonNull ReadOnlyBooleanWrapper isFilterPatternValid = new ReadOnlyBooleanWrapper(true);
    private final @NonNull ReadOnlyBooleanWrapper isNotCurrent = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyBooleanWrapper noFunctionCallSelected = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper();
    private final @NonNull ReadOnlyStringWrapper progressLabel = new ReadOnlyStringWrapper();
    private final @NonNull ObservableList<Integer> selectedIndicies = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull SortedList<TargetStateViewItem> sortedData;
    private final @NonNull ObservableList<TargetStateViewItem> states = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());

    private static void copySelected(@NonNull List<?> selectedItems) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object selectedObj : selectedItems) {
            assert (selectedObj instanceof TargetStateViewItem);
            TargetStateViewItem tmp = (TargetStateViewItem)selectedObj;
            stringBuilder.append(String.valueOf(tmp.getStateName()) + " " + tmp.getValueString() + "\n");
        }
        String stringToCopy = stringBuilder.toString();
        if (!stringToCopy.isEmpty()) {
            content.putString(stringToCopy);
            clipboard.setContent((Map)content);
        }
    }

    public TargetStateViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.filteredData = new FilteredList(this.states, (Predicate)new StateItemPredicate(null, StateFilterMode.SHOW_ALL));
        this.sortedData = new SortedList(this.filteredData);
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
        this.executor.shutdown();
    }

    public void addComparator(ReadOnlyObjectProperty<Comparator<TargetStateViewItem>> comparator) {
        this.sortedData.comparatorProperty().bind(comparator);
    }

    public void bindFilterOnlySelected(ReadOnlyObjectProperty<StateFilterMode> viewFilterOnlyChangedThisFunction) {
        this.filterOnlyChangedThisFunction.bind(viewFilterOnlyChangedThisFunction);
        this.filterOnlyChangedThisFunction.addListener((ChangeListener)new ChangeListener<StateFilterMode>(){

            public void changed(ObservableValue<? extends StateFilterMode> observable, StateFilterMode oldValue, StateFilterMode newValue) {
                StateItemPredicate currentPredicate = (StateItemPredicate)TargetStateViewController.this.filteredData.getPredicate();
                TargetStateViewController.this.filteredData.setPredicate((Predicate)new StateItemPredicate(currentPredicate.filterPattern, newValue != null ? newValue : StateFilterMode.SHOW_ALL));
            }
        });
    }

    public void bindFilterText(StringProperty viewFilterText) {
        this.filterText.bind((ObservableValue)viewFilterText);
        this.filterText.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StateItemPredicate currentPredicate = (StateItemPredicate)TargetStateViewController.this.filteredData.getPredicate();
                Pattern newFilterPattern = null;
                if (newValue == null || newValue.isEmpty()) {
                    TargetStateViewController.this.filterPatternError.set(null);
                    TargetStateViewController.this.isFilterPatternValid.set(true);
                } else {
                    try {
                        newFilterPattern = Pattern.compile(newValue, 2);
                    }
                    catch (PatternSyntaxException exception) {
                        TargetStateViewController.this.isFilterPatternValid.set(false);
                        TargetStateViewController.this.filterPatternError.set("This regular expression is invalid. Specifically:\n\n" + exception.getMessage() + "\n\nSee the Help for more information.");
                    }
                }
                if (newFilterPattern != null) {
                    TargetStateViewController.this.isFilterPatternValid.set(true);
                    TargetStateViewController.this.filterPatternError.set(null);
                }
                TargetStateViewController.this.filteredData.setPredicate((Predicate)new StateItemPredicate(newFilterPattern, currentPredicate.filterMode));
            }
        });
    }

    public void bindSelectedIndices(final ObservableList<Integer> selectedIndices) {
        Bindings.bindContent(this.selectedIndicies, selectedIndices);
        this.sortedData.comparatorProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                Bindings.bindContent(TargetStateViewController.this.selectedIndicies, (ObservableList)selectedIndices);
            }
        });
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super TargetStateViewItem> command) {
        return command.isEnabled(this.currentLightweightProcessModel, this.currentFunctionCall, Commands.makeSelectionList(this.selectedIndicies, this.sortedData));
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super TargetStateViewItem> command) {
        command.execute(this.currentLightweightProcessModel, this.currentFunctionCall, Commands.makeSelectionList(this.selectedIndicies, this.sortedData));
    }

    public ReadOnlyStringProperty filterPatternErrorProperty() {
        return this.filterPatternError.getReadOnlyProperty();
    }

    public @NonNull ICommand<TargetStateViewItem> getCopyCommand() {
        return this.copyCommand;
    }

    public ObservableList<TargetStateViewItem> getData() {
        return this.sortedData;
    }

    public ReadOnlyBooleanProperty isFilterPatternValidProperty() {
        return this.isFilterPatternValid.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty isNotCurrentProperty() {
        return this.isNotCurrent.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty noFunctionCallSelectedProperty() {
        return this.noFunctionCallSelected.getReadOnlyProperty();
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> {
            this.states.clear();
            this.noFunctionCallSelected.set(true);
            this.currentLightweightProcessModel = null;
            this.currentFunctionCall = null;
            this.progress.unbind();
            this.progressLabel.unbind();
            if (this.activeTask != null) {
                this.activeTask.cancel();
                this.activeTask = null;
            }
            navigationUriChangeEvent.getNewResolvedFunctionCall(functionCall -> {
                if (functionCall != null) {
                    TracedProcess lightweightProcess = functionCall.getModel().getParentProcessTarget().getLightweightProcess();
                    this.showStateFor((FunctionCall)functionCall, lightweightProcess.getAllApiModelsWithState());
                    this.noFunctionCallSelected.set(false);
                    this.currentLightweightProcessModel = lightweightProcess;
                    this.currentFunctionCall = functionCall;
                }
                return null;
            });
        });
    }

    public ReadOnlyStringProperty progressLabelProperty() {
        return this.progressLabel.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty progressProperty() {
        return this.progress.getReadOnlyProperty();
    }

    public void selectNextChangedLocation() {
        TargetStateViewItem selectedItem = this.getSingleSelectedStateItem();
        if (selectedItem == null) {
            return;
        }
        FunctionCall selectedFunction = selectedItem.findNextAffectingCallAfter();
        if (selectedFunction == null) {
            return;
        }
        this.selectLocation(selectedFunction);
    }

    public void selectPreviousChangeLocation() {
        TargetStateViewItem selectedItem = this.getSingleSelectedStateItem();
        if (selectedItem == null) {
            return;
        }
        FunctionCall selectedFunction = selectedItem.findLastAffectingCallBefore();
        if (selectedFunction == null) {
            return;
        }
        this.selectLocation(selectedFunction);
    }

    private TargetStateViewItem getSingleSelectedStateItem() {
        if (this.selectedIndicies.size() != 1) {
            return null;
        }
        int selectedIndex = (Integer)this.selectedIndicies.get(0);
        return (TargetStateViewItem)this.sortedData.get(selectedIndex);
    }

    private void selectLocation(@NonNull FunctionCall function) {
        CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)function), (Object)this);
    }

    private void showStateFor(@NonNull FunctionCall functionCall, @NonNull List<@NonNull IApiModelWithState> allApiModelsWithState) {
        assert (Platform.isFxApplicationThread());
        assert (this.activeTask == null);
        GetStateDataTask newTask = new GetStateDataTask(functionCall, allApiModelsWithState);
        this.progress.bind((ObservableValue)newTask.progressProperty());
        this.progressLabel.bind((ObservableValue)newTask.titleProperty());
        newTask.valueProperty().addListener((observable, oldValue, newValue) -> {
            assert (newValue != null);
            this.states.setAll((Collection)newValue);
            this.isNotCurrent.set(false);
        });
        newTask.exceptionProperty().addListener((observable, oldValue, newValue) -> {
            assert (newValue != null);
            FutureExceptionFunction.get().apply(newValue);
            this.isNotCurrent.set(false);
        });
        this.isNotCurrent.set(true);
        this.activeTask = newTask;
        this.executor.execute((Runnable)((Object)newTask));
    }

    private static class GetStateDataTask
    extends Task<List<TargetStateViewItem>>
    implements ICoreProgressMonitor {
        private final @NonNull List<@NonNull IApiModelWithState> allApiModelsWithState;
        private final @NonNull FunctionCall functionCall;
        private int totalWork;
        private int workSoFar;

        private static @NonNull String formatChangedValueSuffix(int i) {
            return "[" + i + "]";
        }

        private static @NonNull String formatUnchangedValueSuffix(int firstUnchangedIndex, int lastUnchangedIndex) {
            if (firstUnchangedIndex != lastUnchangedIndex) {
                return "[" + firstUnchangedIndex + " ... " + lastUnchangedIndex + "]";
            }
            return "[" + firstUnchangedIndex + "]";
        }

        private static Stream<@NonNull TargetStateViewItem> makeTargetStateViewItems(@NonNull IStateItemBase stateItem, @NonNull List<@NonNull IStateItemValue<?>> values, @NonNull FunctionCall functionCall) {
            ArrayList<@NonNull TargetStateViewItem> result = new ArrayList<TargetStateViewItem>();
            if (stateItem instanceof IIndexedStateItem) {
                IIndexedStateItem indexedStateItem = (IIndexedStateItem)stateItem;
                int valuesSize = values.size();
                int indexCount = indexedStateItem.getIndexCount();
                int loopCount = Math.max(indexCount, valuesSize);
                if (loopCount == 0) {
                    result.add(new TargetStateViewItem(indexedStateItem, "[]", null, functionCall));
                } else {
                    int firstUnchangedIndex = 0;
                    int lastUnchangedIndex = 0;
                    IStateItemValue<?> unchangedValue = null;
                    boolean isUnchangedRangeValid = false;
                    int i = 0;
                    while (i < loopCount) {
                        IStateItemValue<?> value;
                        IStateItemValue<?> iStateItemValue = value = i < valuesSize ? values.get(i) : null;
                        if (value == null || value.getParent().getFunctionCallCount() == 0) {
                            if (!isUnchangedRangeValid) {
                                isUnchangedRangeValid = true;
                                unchangedValue = value;
                                firstUnchangedIndex = i;
                            }
                            lastUnchangedIndex = i;
                        } else {
                            if (isUnchangedRangeValid) {
                                isUnchangedRangeValid = false;
                                result.add(new TargetStateViewItem(indexedStateItem, GetStateDataTask.formatUnchangedValueSuffix(firstUnchangedIndex, lastUnchangedIndex), unchangedValue, functionCall));
                            }
                            result.add(new TargetStateViewItem(indexedStateItem, GetStateDataTask.formatChangedValueSuffix(i), value, functionCall));
                        }
                        ++i;
                    }
                    if (isUnchangedRangeValid) {
                        result.add(new TargetStateViewItem(indexedStateItem, GetStateDataTask.formatUnchangedValueSuffix(firstUnchangedIndex, lastUnchangedIndex), unchangedValue, functionCall));
                    }
                }
            } else {
                assert (values.size() == 1);
                result.add(new TargetStateViewItem((IStateItem)stateItem, values.get(0), functionCall));
            }
            return result.stream();
        }

        public GetStateDataTask(@NonNull FunctionCall functionCall, @NonNull List<@NonNull IApiModelWithState> allApiModelsWithState) {
            this.functionCall = functionCall;
            this.allApiModelsWithState = allApiModelsWithState;
            this.totalWork = 0;
            this.workSoFar = 0;
        }

        public void incProgress(int n) {
            this.workSoFar += n;
            this.updateProgress(this.workSoFar, this.totalWork);
        }

        public void setTask(String name, int totalWork) {
            this.totalWork = totalWork;
            this.workSoFar = 0;
            this.updateTitle(name);
            this.updateProgress(0L, totalWork);
        }

        protected List<@NonNull TargetStateViewItem> call() throws Exception {
            try {
                ArrayList<@NonNull TargetStateViewItem> result = new ArrayList<TargetStateViewItem>();
                for (IApiModelWithState apiModel : this.allApiModelsWithState) {
                    Map stateItemValues;
                    IStateItemContainer stateItems = apiModel.waitForStateForFunction((ICoreProgressMonitor)this, this.functionCall);
                    if (stateItems == null || (stateItemValues = stateItems.waitForAllStateItemValues((ICoreProgressMonitor)this, this.functionCall)) == null) continue;
                    result.addAll(stateItemValues.entrySet().stream().flatMap(entry -> GetStateDataTask.makeTargetStateViewItems((IStateItemBase)entry.getKey(), (List)entry.getValue(), this.functionCall)).collect(Collectors.toList()));
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public static enum StateFilterMode {
        SHOW_ALL,
        CHANGED,
        NOT_CHANGED,
        CURRENTLY_NOT_DEFAULT,
        CHANGED_IN_THIS_FUNCTION,
        READ_ONLY;

    }

    private static class StateItemPredicate
    implements Predicate<TargetStateViewItem> {
        private final StateFilterMode filterMode;
        private final @Nullable Pattern filterPattern;

        public StateItemPredicate(@Nullable Pattern filterPattern, StateFilterMode filterMode) {
            this.filterPattern = filterPattern;
            this.filterMode = filterMode;
        }

        @Override
        public boolean test(TargetStateViewItem stateItem) {
            Pattern localFilterPattern = this.filterPattern;
            if (localFilterPattern != null && !localFilterPattern.matcher(stateItem.getStateName()).find() && !localFilterPattern.matcher(stateItem.getValueString()).find()) {
                return false;
            }
            switch (this.filterMode) {
                case SHOW_ALL: {
                    return true;
                }
                case CHANGED: {
                    if (stateItem.isEverChanged() && !stateItem.isReadOnlyStateItem()) break;
                    return false;
                }
                case NOT_CHANGED: {
                    if (!stateItem.isEverChanged() && !stateItem.isReadOnlyStateItem()) break;
                    return false;
                }
                case CURRENTLY_NOT_DEFAULT: {
                    if (stateItem.isChanged() && !stateItem.isReadOnlyStateItem()) break;
                    return false;
                }
                case CHANGED_IN_THIS_FUNCTION: {
                    if (stateItem.isAffectedByCurrentFunction() && !stateItem.isReadOnlyStateItem()) break;
                    return false;
                }
                case READ_ONLY: {
                    if (stateItem.isReadOnlyStateItem()) break;
                    return false;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return true;
        }
    }

    public static class TargetStateViewItem {
        private final @NonNull WeakReference<FunctionCall> functionCall;
        private final @NonNull WeakReference<IStateItemBase> stateItem;
        private final @NonNull String suffix;
        private final @NonNull WeakReference<IStateItemValue<?>> value;
        private final @NonNull String valueString;
        private final @NonNull StateSpec spec;

        private static <T> @NonNull String makeValuesString(@NonNull IStateItemValue<? extends T> value) {
            return (String)StateItemValueFormatter.format(value, FormatterSettings::new);
        }

        public TargetStateViewItem(@NonNull IIndexedStateItem<?> stateItem, @NonNull String suffix, @Nullable IStateItemValue<?> value, @NonNull FunctionCall functionCall) {
            this.stateItem = new WeakReference(stateItem);
            this.valueString = value != null ? TargetStateViewItem.makeValuesString(value) : "";
            this.functionCall = new WeakReference<FunctionCall>(functionCall);
            this.value = new WeakReference(value);
            this.suffix = suffix;
            this.spec = stateItem.getStateSpec();
        }

        public TargetStateViewItem(@NonNull IStateItem<?> stateItem, @NonNull IStateItemValue<?> value, @NonNull FunctionCall functionCall) {
            this.stateItem = new WeakReference(stateItem);
            this.valueString = TargetStateViewItem.makeValuesString(value);
            this.functionCall = new WeakReference<FunctionCall>(functionCall);
            this.value = new WeakReference(value);
            this.suffix = "";
            this.spec = stateItem.getStateSpec();
        }

        public @Nullable FunctionCall findLastAffectingCallBefore() {
            IStateItemBase item = (IStateItemBase)this.stateItem.get();
            FunctionCall call = (FunctionCall)this.functionCall.get();
            if (item == null || call == null) {
                return null;
            }
            return item.findLastAffectingCallBefore(call);
        }

        public @Nullable FunctionCall findNextAffectingCallAfter() {
            IStateItemBase item = (IStateItemBase)this.stateItem.get();
            FunctionCall call = (FunctionCall)this.functionCall.get();
            if (item == null || call == null) {
                return null;
            }
            return item.findNextAffectingCallAfter(call);
        }

        public @Nullable IStateItemBase getStateItem() {
            IStateItemValue val = (IStateItemValue)this.value.get();
            return val != null ? val.getParent() : (IStateItemBase)this.stateItem.get();
        }

        public @NonNull String getStateName() {
            return String.valueOf(this.spec.getName()) + this.suffix;
        }

        public @NonNull StateVariableTypeSpec getStateVariableType() {
            return (StateVariableTypeSpec)NullUtils.neverNull((Object)this.spec.getStateType().getStateVariableType());
        }

        public @NonNull String getValueString() {
            return this.valueString;
        }

        public boolean isAffectedByCurrentFunction() {
            FunctionCall call = (FunctionCall)this.functionCall.get();
            IStateItemValue val = (IStateItemValue)this.value.get();
            if (val != null && call != null) {
                return val.getParent().isAffectedBy(call);
            }
            return false;
        }

        public boolean isChanged() {
            IStateItemValue val = (IStateItemValue)this.value.get();
            return val != null && !val.isDefaultValue();
        }

        public boolean isEverChanged() {
            IStateItemValue val = (IStateItemValue)this.value.get();
            if (val != null) {
                IStateItem parent = val.getParent();
                return parent.getFunctionCallCount() > 0;
            }
            return false;
        }

        public boolean isReadOnlyStateItem() {
            IStateItemValue val = (IStateItemValue)this.value.get();
            if (val != null) {
                IStateItem parent = val.getParent();
                return parent.getStateSpec().isReadOnly();
            }
            return false;
        }

        private static class FormatterSettings<T>
        extends StateItemValueFormatter.DefaultFormatter<T> {
            public FormatterSettings(@NonNull IStateItem<? extends IStateItemValue<? extends T>> parent) {
                super(parent);
            }
        }
    }
}

