/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IClipboardCopyable;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.utils.NullUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SimpleTableViewController<T extends IClipboardCopyable>
implements ICommandDispatcher<T> {
    private final @NonNull ICommand<T> copyCommand = new ICommand<T>(){

        @Override
        public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends T> selection) {
            SimpleTableViewController.this.copySelected(selection);
        }

        @Override
        public @NonNull String getLabel() {
            return "Copy";
        }

        @Override
        public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends T> selection) {
            return !selection.isEmpty();
        }
    };
    private final @NonNull ObservableList<T> itemList = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull FilteredList<T> filteredList = new FilteredList(this.itemList);
    private final @NonNull SortedList<T> sortedItemList = new SortedList(this.filteredList);
    protected final @NonNull ListProperty<Integer> selectedIndices = new SimpleListProperty();

    public abstract void dispose();

    public @NonNull ObservableList<T> getItemList() {
        return this.sortedItemList;
    }

    protected void setItems(@NonNull LinkedHashSet<T> newItems) {
        assert (Platform.isFxApplicationThread());
        this.itemList.removeIf(item -> !newItems.contains(item));
        newItems.removeAll((Collection<?>)this.itemList);
        this.itemList.addAll(newItems);
    }

    protected void clearAndSetItems(@NonNull Collection<T> newItems) {
        assert (Platform.isFxApplicationThread());
        this.itemList.setAll(newItems);
    }

    protected void clearItems() {
        assert (Platform.isFxApplicationThread());
        this.itemList.clear();
    }

    public void bindSelectedIndices(@Nullable ObservableList<Integer> indices) {
        this.selectedIndices.set(indices);
    }

    public void bindComparatorProperty(ObservableValue<? extends Comparator<? super T>> comparatorProperty) {
        this.sortedItemList.comparatorProperty().bind(comparatorProperty);
    }

    protected void copySelected(@NonNull List<? extends @NonNull IClipboardCopyable> list) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent clipboardContent = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (IClipboardCopyable iClipboardCopyable : list) {
            stringBuilder.append(iClipboardCopyable.getClipboardContent()).append("\n");
        }
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            clipboardContent.putString(string);
            clipboard.setContent((Map)clipboardContent);
        }
    }

    public @NonNull ICommand<T> getCopyCommand() {
        return this.copyCommand;
    }

    public void setFilteredListPredicate(Predicate<T> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super T> command) {
        assert (Platform.isFxApplicationThread());
        command.execute(null, Commands.makeSelectionList(this.selectedIndices, this.getItemList()));
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super T> command) {
        assert (Platform.isFxApplicationThread());
        return command.isEnabled(null, Commands.makeSelectionList(this.selectedIndices, this.getItemList()));
    }
}

