/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShadersViewStatisticsGetter {
    private final @NonNull Map<@NonNull GlShaderAsset, @Nullable GlShaderStats> shaderProcessedMap = new WeakHashMap<GlShaderAsset, GlShaderStats>();
    private final @Nullable Float totalShaderCycles;

    public static @NonNull CompletableFuture<@NonNull ShadersViewStatisticsGetter> create(@NonNull GlShaderCompiler shaderCompiler, @NonNull List<@NonNull GlShaderAsset> filteredShaderList) {
        CompletableFuture[] futures = new CompletableFuture[filteredShaderList.size()];
        int i = 0;
        while (i < filteredShaderList.size()) {
            futures[i] = filteredShaderList.get(i).getShaderStats(shaderCompiler);
            ++i;
        }
        return (CompletableFuture)NullUtils.neverNull((Object)CompletableFuture.allOf(futures).handle((nil, error) -> {
            assert (error == null);
            return new ShadersViewStatisticsGetter(filteredShaderList, futures);
        }));
    }

    private ShadersViewStatisticsGetter(@NonNull List<@NonNull GlShaderAsset> filteredShaderList, CompletableFuture<?>[] completedFutures) {
        assert (filteredShaderList.size() == completedFutures.length);
        float totalCycles = 0.0f;
        int i = 0;
        while (i < filteredShaderList.size()) {
            GlShaderAsset shader = filteredShaderList.get(i);
            CompletableFuture<?> future = completedFutures[i];
            assert (future.isDone());
            assert (!future.isCompletedExceptionally());
            assert (!future.isCancelled());
            GlShaderStats stats = (GlShaderStats)future.join();
            assert (stats != null);
            Float shaderTotal = stats.getTotalCycles(shader.getCurrentFrameShaderInvocations());
            if (shaderTotal != null) {
                totalCycles += shaderTotal.floatValue();
            }
            this.shaderProcessedMap.put(shader, stats);
            ++i;
        }
        this.totalShaderCycles = totalCycles > 0.0f ? Float.valueOf(totalCycles) : null;
    }

    public @NonNull GlShaderStats getShaderStats(@NonNull GlShaderAsset shader) {
        return (GlShaderStats)NullUtils.neverNull((Object)this.shaderProcessedMap.get(shader));
    }

    public @Nullable Float getAllShadersTotalCycles() {
        return this.totalShaderCycles;
    }
}

