/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.SourceAsset;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.util.ComparableWeakReference;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.EditorInputManager;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.ShadersViewStatisticsGetter;
import com.arm.mgd.ui.controllers.commands.IOpenable;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShadersViewListItem
implements IAssetWrapper<GlShaderAsset>,
IOpenable {
    public static final String PROPERTY_NAME_BINARY_FORMAT = "binaryFormat";
    public static final String PROPERTY_NAME_INSTANCES_RUN = "instancesRun";
    public static final String PROPERTY_NAME_NOTE = "note";
    public static final String PROPERTY_NAME_PERCENT_CYCLES = "percentCycles";
    public static final String PROPERTY_NAME_PROGRAM_COLOR = "programColour";
    public static final String PROPERTY_NAME_PROGRAM_ID = "linkedPrograms";
    public static final String PROPERTY_NAME_SHADER_ID = "shaderId";
    public static final String PROPERTY_NAME_TOTAL_CYCLES = "totalCycles";
    private final @NonNull SimpleObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormatPropertyValue;
    private final @NonNull SimpleLongProperty instancesRunPropertyValue;
    private final @NonNull SimpleStringProperty notePropertyValue;
    private final @NonNull SimpleObjectProperty<@Nullable Float> percentCyclesPropertyValue;
    private final @NonNull SimpleObjectProperty<@NonNull List<@NonNull ComparableWeakReference<@NonNull GlProgramAsset>>> linkedProgramsValue;
    private final @NonNull WeakReference<@Nullable GlShaderAsset> weakShader;
    private final @NonNull SimpleLongProperty shaderIdPropertyValue;
    private final @NonNull SimpleObjectProperty<@Nullable GlShaderStats> shaderStatsPropertyValue = new SimpleObjectProperty();
    private final @NonNull SimpleObjectProperty<@Nullable Float> totalCyclesPropertyValue;

    public boolean isShaderActive() {
        GlShaderAsset weakShaderValue = (GlShaderAsset)this.weakShader.get();
        return weakShaderValue == null ? false : weakShaderValue.isAssetActive();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ShadersViewListItem(@NonNull GlShaderAsset shader, @NonNull SimpleObjectProperty<ShadersViewStatisticsGetter> statisticsGetter) {
        this.weakShader = new WeakReference<GlShaderAsset>(shader);
        ArrayList<@NonNull @NonNull E> weakLinkedPrograms = new ArrayList();
        shader.getLinkedToProgramList().forEach(program -> {
            boolean bl = weakLinkedPrograms.add(new ComparableWeakReference((Comparable)program));
        });
        this.linkedProgramsValue = new SimpleObjectProperty(weakLinkedPrograms);
        this.shaderIdPropertyValue = new SimpleLongProperty(shader.getId().longValue());
        this.instancesRunPropertyValue = new SimpleLongProperty(shader.getCurrentFrameShaderInvocations());
        this.totalCyclesPropertyValue = new SimpleObjectProperty(null);
        this.binaryFormatPropertyValue = new SimpleObjectProperty((Object)shader.getBinaryFormat());
        this.percentCyclesPropertyValue = new SimpleObjectProperty(null);
        this.notePropertyValue = new SimpleStringProperty(shader.getNote());
        statisticsGetter.addListener((observable, oldValue, newValue) -> {
            GlShaderAsset asset = (GlShaderAsset)this.weakShader.get();
            if (newValue == null || asset == null) {
                return;
            }
            GlShaderStats stats = newValue.getShaderStats(asset);
            this.shaderStatsPropertyValue.set((Object)stats);
            Float shaderTotalCycles = stats.getTotalCycles(asset.getCurrentFrameShaderInvocations());
            if (shaderTotalCycles != null) {
                this.totalCyclesPropertyValue.set((Object)shaderTotalCycles);
                Float allShaderstotalCycles = newValue.getAllShadersTotalCycles();
                if (allShaderstotalCycles != null) {
                    this.percentCyclesPropertyValue.set((Object)Float.valueOf(100.0f * shaderTotalCycles.floatValue() / allShaderstotalCycles.floatValue()));
                }
            }
        });
    }

    ShadersViewListItem(@NonNull GlShaderAsset shader, @NonNull SimpleObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormat, @NonNull SimpleLongProperty instancesRun, @NonNull SimpleStringProperty note, @NonNull SimpleObjectProperty<@NonNull List<@NonNull ComparableWeakReference<@NonNull GlProgramAsset>>> linkedPrograms, @NonNull SimpleLongProperty shaderId, @NonNull SimpleObjectProperty<@Nullable Float> totalCycles, @NonNull SimpleObjectProperty<@Nullable Float> percentCycles) {
        this.binaryFormatPropertyValue = binaryFormat;
        this.instancesRunPropertyValue = instancesRun;
        this.notePropertyValue = note;
        this.linkedProgramsValue = linkedPrograms;
        this.shaderIdPropertyValue = shaderId;
        this.totalCyclesPropertyValue = totalCycles;
        this.percentCyclesPropertyValue = percentCycles;
        this.weakShader = new WeakReference<GlShaderAsset>(shader);
    }

    public ReadOnlyProperty<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormatProperty() {
        return this.binaryFormatPropertyValue;
    }

    public @Nullable GlShaderAsset getShader() {
        return (GlShaderAsset)this.weakShader.get();
    }

    public @NonNull ReadOnlyLongProperty instancesRunProperty() {
        return this.instancesRunPropertyValue;
    }

    public @NonNull ReadOnlyStringProperty noteProperty() {
        return this.notePropertyValue;
    }

    public ReadOnlyProperty<@Nullable Float> percentCyclesProperty() {
        return this.percentCyclesPropertyValue;
    }

    public @NonNull ReadOnlyProperty<@NonNull List<@NonNull ComparableWeakReference<@NonNull GlProgramAsset>>> linkedProgramsProperty() {
        return this.linkedProgramsValue;
    }

    public ReadOnlyLongProperty shaderIdProperty() {
        return this.shaderIdPropertyValue;
    }

    public ReadOnlyProperty<@Nullable Float> totalCyclesProperty() {
        return this.totalCyclesPropertyValue;
    }

    @Override
    public @Nullable GlShaderAsset getAsset() {
        return (GlShaderAsset)this.weakShader.get();
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable GlShaderStats> shaderStatsProperty() {
        return this.shaderStatsPropertyValue;
    }

    @NonNull String getLinkedProgramsAsString() {
        @NonNull Stream<GlProgramAsset> programStream = ((List)this.linkedProgramsProperty().getValue()).stream().map(Reference::get).filter(Objects::nonNull);
        return NullUtils.mappedStream(programStream, asset -> asset.getId().toString()).collect(Collectors.joining(" "));
    }

    @Override
    public @NonNull String getClipboardContent() {
        return this.shaderIdProperty().getValue() + "," + this.getLinkedProgramsAsString() + "," + NullUtils.nonNullOrDefault((Object)this.instancesRunProperty().getValue(), (Object)"") + "," + NullUtils.nonNullOrDefault((Object)((Serializable)this.totalCyclesProperty().getValue()), (Object)"") + "," + NullUtils.nonNullOrDefault((Object)((Serializable)this.percentCyclesProperty().getValue()), (Object)"") + "," + NullUtils.nonNullOrDefault((Object)((Serializable)this.binaryFormatProperty().getValue()), (Object)"") + "," + (String)NullUtils.nonNullOrDefault((Object)this.noteProperty().getValue(), (Object)"");
    }

    public static @NonNull String getClipboardCSVHeader() {
        return "Shader,Linked Programs,Instances Run,Total Cycles,Percent Cycles,Binary Format,Additional Information";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void open() {
        EditorInputManager.openEditor((SourceAsset)this.weakShader.get());
    }
}

