/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlShaderHelper;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.offlinecompiler.IGlStatistic;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.ShadersViewListItem;
import com.arm.mgd.ui.controllers.ShadersViewStatisticsGetter;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShadersViewController
implements ICommandDispatcher<ShadersViewListItem> {
    public static final @NonNull BooleanProperty showActiveOnly = new SimpleBooleanProperty(false);
    private final @NonNull ICommand<ShadersViewListItem> copyCommand = new ICommand<ShadersViewListItem>(){

        @Override
        public void execute(TraceDataModel model, List<? extends @NonNull ShadersViewListItem> selection) {
            ShadersViewController.this.copySelected(selection);
        }

        @Override
        public @NonNull String getLabel() {
            return "Copy";
        }

        @Override
        public boolean isEnabled(TraceDataModel model, List<? extends ShadersViewListItem> selection) {
            return !selection.isEmpty();
        }
    };
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull AbstractConstantOrAliasSpecExtended targetShaderType;
    private final @NonNull GlShaderCompiler shaderCompiler;
    private @NonNull WeakReference<@Nullable TraceDataModel> currentModel = NullUtils.emptyWeakReference();
    private @NonNull WeakReference<@Nullable FrameRenderPass> currentRenderPass = NullUtils.emptyWeakReference();
    private @NonNull SimpleBooleanProperty statisticsFinishedLoadingProperty = new SimpleBooleanProperty(false);
    private final @NonNull SimpleObjectProperty<@Nullable Long> totalCyclesProperty = new SimpleObjectProperty(null);
    private @Nullable CompletableFuture<ShadersViewStatisticsGetter> currentlyRunningStatisticsGetterFuture = null;
    private final @NonNull ObservableList<@NonNull ShadersViewListItem> unfilteredItems = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull FilteredList<@NonNull ShadersViewListItem> filteredItems = new FilteredList(this.unfilteredItems);
    private final @NonNull SortedList<@NonNull ShadersViewListItem> sortedItems = new SortedList(this.filteredItems);
    private final @NonNull ObservableSet<Integer> selectedIndices = (ObservableSet)NullUtils.neverNull((Object)FXCollections.observableSet((Object[])new Integer[0]));
    private final @NonNull ObservableSet<@NonNull IGlStatistic> shaderCompilerStatistics = (ObservableSet)NullUtils.neverNull((Object)FXCollections.observableSet(new TreeSet<IGlStatistic>(new Comparator<IGlStatistic>(){

        @Override
        public int compare(@NonNull IGlStatistic o1, @NonNull IGlStatistic o2) {
            return Integer.compare(o1.getGlShaderStatType().getDefaultOrdering(), o2.getGlShaderStatType().getDefaultOrdering());
        }
    })));

    public ShadersViewController(@NonNull ReadOnlyBooleanProperty enabledProperty, @NonNull AbstractConstantOrAliasSpecExtended targetShaderType) {
        assert (KapiSpec.GLES.constantGroups.SHADERTYPE.contains(targetShaderType)) : "Unexpected targetShaderType - " + targetShaderType;
        this.targetShaderType = targetShaderType;
        this.shaderCompiler = (GlShaderCompiler)NullUtils.neverNull((Object)CoreInstance.getGlShaderCompiler());
        IGlStatistic[] iGlStatisticArray = this.shaderCompiler.getStatistics();
        int n = iGlStatisticArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGlStatistic statistic = iGlStatisticArray[n2];
            this.shaderCompilerStatistics.add((Object)((IGlStatistic)NullUtils.neverNull((Object)statistic)));
            ++n2;
        }
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
        showActiveOnly.addListener((observable, oldValue, newValue) -> this.filteredItems.setPredicate(newValue != false ? ShadersViewListItem::isShaderActive : x -> true));
    }

    public void dispose() {
        assert (Platform.isFxApplicationThread());
        this.navigationChangedListener.dispose();
        this.unfilteredItems.clear();
        this.statisticsFinishedLoadingProperty.set(false);
        this.totalCyclesProperty.set(null);
        this.currentlyRunningStatisticsGetterFuture = null;
    }

    public void bindSelectedIndices(@NonNull ObservableList<Integer> indices) {
        indices.addListener((ListChangeListener)new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> c) {
                ShadersViewController.this.selectedIndices.clear();
                ShadersViewController.this.selectedIndices.addAll((Collection)c.getList());
            }
        });
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super ShadersViewListItem> command) {
        return command.isEnabled((TraceDataModel)this.currentModel.get(), Commands.makeSelectionList(new ArrayList<Integer>((Collection<Integer>)this.selectedIndices), this.sortedItems));
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super ShadersViewListItem> command) {
        command.execute((TraceDataModel)this.currentModel.get(), Commands.makeSelectionList(new ArrayList<Integer>((Collection<Integer>)this.selectedIndices), this.sortedItems));
    }

    public @NonNull ICommand<ShadersViewListItem> getCopyCommand() {
        return this.copyCommand;
    }

    public @Nullable FrameRenderPass getCurrentRenderPass() {
        return (FrameRenderPass)this.currentRenderPass.get();
    }

    public @NonNull ObservableSet<@NonNull IGlStatistic> getShaderCompilerStatistics() {
        return this.shaderCompilerStatistics;
    }

    public @NonNull ObservableList<@NonNull ShadersViewListItem> getShadersList() {
        return this.sortedItems;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getTargetShaderType() {
        return this.targetShaderType;
    }

    public @NonNull ReadOnlyProperty<@Nullable Long> totalCycles() {
        return this.totalCyclesProperty;
    }

    public @NonNull ReadOnlyBooleanProperty statisticsFinishedLoading() {
        return this.statisticsFinishedLoadingProperty;
    }

    private void copySelected(@NonNull List<? extends @NonNull ShadersViewListItem> selectedItems) {
        assert (Platform.isFxApplicationThread());
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        ShadersViewStatisticsGetter statisticsGetter = this.currentlyRunningStatisticsGetterFuture != null ? this.currentlyRunningStatisticsGetterFuture.join() : null;
        for (ShadersViewListItem shadersViewListItem : selectedItems) {
            stringBuilder.append(shadersViewListItem.getClipboardContent());
            GlShaderAsset shader = shadersViewListItem.getShader();
            GlShaderStats statistics = statisticsGetter != null && shader != null ? statisticsGetter.getShaderStats(shader) : null;
            for (IGlStatistic statistic : this.shaderCompilerStatistics) {
                Object value;
                String statString = "N/A";
                if (statistics != null && (value = statistics.getStat(statistic)) != null) {
                    statString = value.toString();
                }
                stringBuilder.append(",").append(statString);
            }
            stringBuilder.append("\n");
        }
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            StringBuilder csvTableBuilder = new StringBuilder();
            csvTableBuilder.append(ShadersViewListItem.getClipboardCSVHeader());
            for (IGlStatistic statistic : this.shaderCompilerStatistics) {
                csvTableBuilder.append(",").append(statistic.getGlShaderStatType().getName());
            }
            csvTableBuilder.append("\n");
            csvTableBuilder.append(string);
            content.putString(csvTableBuilder.toString());
            clipboard.setContent((Map)content);
        }
    }

    public boolean isProgramActive(@NonNull GlProgramAsset program) {
        assert (Platform.isFxApplicationThread());
        TraceDataModel model = (TraceDataModel)this.currentModel.get();
        if (model == null) {
            return false;
        }
        return program.isAssetActive();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void refreshListItems(@Nullable TraceStateSnapshot snapshot) {
        List newListItems;
        SimpleObjectProperty statisticsGetterProperty;
        CompletableFuture<ShadersViewStatisticsGetter> newStatisticsGetterTask;
        assert (!Platform.isFxApplicationThread());
        if (snapshot != null && snapshot.getCurrentSelection() != -1) {
            @NonNull @NonNull List filteredShaderList = GlShaderHelper.getAllLinkedShaders((TraceStateSnapshot)snapshot, (AbstractConstantOrAliasSpecExtended)this.targetShaderType);
            newStatisticsGetterTask = ShadersViewStatisticsGetter.create(this.shaderCompiler, filteredShaderList);
            statisticsGetterProperty = new SimpleObjectProperty();
            newListItems = filteredShaderList.stream().map(shader -> new ShadersViewListItem((GlShaderAsset)shader, (SimpleObjectProperty<ShadersViewStatisticsGetter>)statisticsGetterProperty)).collect(Collectors.toCollection(ArrayList::new));
        } else {
            newStatisticsGetterTask = null;
            statisticsGetterProperty = null;
            newListItems = NullUtils.EMPTY_LIST;
        }
        FunctionCall fc = snapshot != null ? snapshot.getCurrentFunctionCall() : null;
        Platform.runLater(() -> {
            TraceDataModel newModel = null;
            FrameRenderPass newRenderPass = null;
            if (fc != null) {
                Frame frame = fc.getParentFrame();
                assert (frame != null);
                newRenderPass = frame.getRenderPassFor(fc);
                newModel = fc.getModel();
            }
            this.currentModel = new WeakReference<Object>(newModel);
            this.currentRenderPass = new WeakReference<FrameRenderPass>(newRenderPass);
            this.unfilteredItems.setAll((Collection)newListItems);
            this.totalCyclesProperty.set(null);
            this.currentlyRunningStatisticsGetterFuture = newStatisticsGetterTask;
            this.statisticsFinishedLoadingProperty.set(false);
            if (statisticsGetterProperty != null) {
                assert (newStatisticsGetterTask != null);
                statisticsGetterProperty.addListener((observable, oldValue, newValue) -> {
                    assert (Platform.isFxApplicationThread());
                    if (newStatisticsGetterTask == this.currentlyRunningStatisticsGetterFuture) {
                        Float allShadersTotalCycles = newValue.getAllShadersTotalCycles();
                        if (allShadersTotalCycles != null) {
                            this.totalCyclesProperty.set((Object)allShadersTotalCycles.longValue());
                        }
                        this.statisticsFinishedLoadingProperty.set(true);
                    }
                });
                newStatisticsGetterTask.handle((getter, error) -> {
                    assert (getter != null);
                    assert (error == null);
                    Platform.runLater(() -> statisticsGetterProperty.set(getter));
                    return null;
                });
            }
        });
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> this.refreshListItems(snapshot));
    }

    public void addComparator(ReadOnlyObjectProperty<Comparator<ShadersViewListItem>> comparator) {
        this.sortedItems.comparatorProperty().bind(comparator);
    }
}

