/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ITargetEventListener;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.IConsoleCommandsHistory;
import com.arm.mgd.ui.controllers.PythonConsole;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptingViewController
implements ITargetEventListener {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull Map<@NonNull AbstractTarget, PythonConsole> consoles = new HashMap<AbstractTarget, PythonConsole>();
    private final @NonNull ReadOnlyObjectWrapper<@Nullable PythonConsole> currentConsole = new ReadOnlyObjectWrapper();
    private final @NonNull DoubleProperty savedConsoleScrollTop = new ReadOnlyDoubleWrapper(Double.MAX_VALUE);
    private final @NonNull ReadOnlyDoubleWrapper currentConsoleScrollTop = new ReadOnlyDoubleWrapper(Double.MAX_VALUE);
    private final @NonNull ReadOnlyBooleanWrapper isInterpreterBusy = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyIntegerWrapper caretPosition = new ReadOnlyIntegerWrapper(0);
    private final @NonNull ReadOnlyIntegerWrapper currentLineNumber = new ReadOnlyIntegerWrapper(0);
    private final @NonNull ReadOnlyStringWrapper currentPrompt = new ReadOnlyStringWrapper("");
    private final @NonNull ReadOnlyBooleanWrapper anyTrace = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyBooleanWrapper activeLiveTrace = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyBooleanWrapper authorised = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyStringWrapper disabledReason = new ReadOnlyStringWrapper("Loading license information");
    private final @NonNull ChangeListener<Boolean> disabledListener = (observable, oldValue, newValue) -> this.updateDisabledReason();

    private void updateDisabledReason() {
        if (!this.authorised().get()) {
            return;
        }
        String disabledMessage = this.activeLiveTrace().get() ? "Scripting is disabled for live traces" : (!this.anyTrace().get() ? "No trace file loaded" : null);
        Platform.runLater(() -> this.disabledReason.set(disabledMessage));
    }

    public ScriptingViewController(@NonNull ReadOnlyBooleanProperty enabledProperty, @NonNull ProgressBar progressBar, @NonNull Label progressBarLabel, @NonNull DoubleProperty outputConsoleTextAreaScrollTop) {
        this.currentConsoleScrollTop.bind((ObservableValue)outputConsoleTextAreaScrollTop);
        this.anyTrace.bind((ObservableValue)this.currentConsole.isNotNull());
        this.anyTrace.addListener(this.disabledListener);
        this.activeLiveTrace.addListener(this.disabledListener);
        ApplicationFeatureAuthoriser.USER_SCRIPTING.registerAuthorisationConsumer(authorisation -> Platform.runLater(() -> {
            this.authorised.set(authorisation.isAuthorised());
            if (!authorisation.isAuthorised()) {
                String message = "Scripting is not supported by the current license";
                this.disabledReason.set("Scripting is not supported by the current license");
                CoreLogging.info(null, (String)("Scripting is not supported by the current license: " + authorisation.getReason()));
            } else {
                this.updateDisabledReason();
            }
        }));
        this.currentConsole.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.savedScrollTop().set(this.currentConsoleScrollTop.get());
            }
            if (newValue == null) {
                this.isInterpreterBusy.unbind();
                this.caretPosition.unbind();
                this.caretPosition.set(0);
                this.currentLineNumber.unbind();
                this.currentLineNumber.set(0);
                this.currentPrompt.unbind();
                this.currentPrompt.set(">>> ");
                progressBar.progressProperty().unbind();
                progressBar.progressProperty().set(0.0);
                progressBarLabel.textProperty().unbind();
                progressBarLabel.textProperty().set((Object)"");
                this.activeLiveTrace.unbind();
                this.activeLiveTrace.set(false);
                this.savedConsoleScrollTop.set(Double.MAX_VALUE);
            } else {
                this.isInterpreterBusy.bind((ObservableValue)newValue.isInterpreterBusy());
                this.caretPosition.bind((ObservableValue)newValue.caretPosition());
                this.currentLineNumber.bind((ObservableValue)newValue.currentLineNumber());
                this.currentPrompt.bind((ObservableValue)newValue.currentPrompt());
                progressBar.progressProperty().bind((ObservableValue)newValue.taskProgress());
                progressBarLabel.textProperty().bind((ObservableValue)newValue.taskLabel());
                this.activeLiveTrace.bind((ObservableValue)newValue.isStarted().not());
                this.savedConsoleScrollTop.set(newValue.savedScrollTop().get());
            }
        });
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        assert (Platform.isFxApplicationThread());
        this.navigationChangedListener.dispose();
        Map<AbstractTarget, PythonConsole> map = this.consoles;
        synchronized (map) {
            for (AbstractTarget target : this.consoles.keySet()) {
                this.stop(target);
                target.removeTargetEventListener((ITargetEventListener)this);
            }
            this.consoles.clear();
        }
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> navigationUriChangeEvent.getNewTarget(newTarget -> {
            PythonConsole console = null;
            if (newTarget != null && (console = this.consoles.get(newTarget)) == null) {
                console = new PythonConsole();
                this.consoles.put((AbstractTarget)newTarget, console);
                newTarget.addTargetEventListener((ITargetEventListener)this);
            }
            this.currentConsole.set(console);
            return null;
        }));
    }

    public @NonNull CompletableFuture<@NonNull String> runSourceFromConsole(@NonNull String sourceLineWithPrompt) {
        PythonConsole console = (PythonConsole)this.currentConsole.get();
        if (console != null) {
            return console.runSourceFromConsole(sourceLineWithPrompt);
        }
        return (CompletableFuture)NullUtils.neverNull(CompletableFuture.completedFuture(""));
    }

    public @NonNull ReadOnlyBooleanProperty isInterpreterBusy() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.isInterpreterBusy.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable PythonConsole> currentConsole() {
        return (ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.currentConsole.getReadOnlyProperty());
    }

    public @NonNull String getConsoleText() {
        PythonConsole console = (PythonConsole)this.currentConsole.get();
        return console != null ? console.getConsoleText() : "";
    }

    public void clear() {
        PythonConsole console = (PythonConsole)this.currentConsole.get();
        if (console != null) {
            console.clear();
        }
    }

    private void stop(@NonNull AbstractTarget trace) {
        assert (Platform.isFxApplicationThread());
        PythonConsole console = this.consoles.remove(trace);
        if (console != null) {
            console.stop();
        }
        if (this.currentConsole.get() == console) {
            this.currentConsole.set(null);
        }
    }

    public void interrupt() {
        PythonConsole console = (PythonConsole)this.currentConsole.get();
        if (console != null) {
            console.interrupt();
        }
    }

    public void reset() {
        PythonConsole console = (PythonConsole)this.currentConsole.get();
        if (console != null) {
            console.reset();
        }
    }

    public @NonNull DoubleProperty savedConsoleScrollTop() {
        return this.savedConsoleScrollTop;
    }

    public @NonNull ReadOnlyIntegerProperty caretPosition() {
        return (ReadOnlyIntegerProperty)NullUtils.neverNull((Object)this.caretPosition.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyIntegerProperty currentLineNumber() {
        return (ReadOnlyIntegerProperty)NullUtils.neverNull((Object)this.currentLineNumber.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyStringProperty currentPrompt() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.currentPrompt.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyBooleanProperty anyTrace() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.anyTrace.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyBooleanProperty activeLiveTrace() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.activeLiveTrace.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyBooleanProperty authorised() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.authorised.getReadOnlyProperty());
    }

    public @Nullable IConsoleCommandsHistory getConsoleCommandsHistory() {
        PythonConsole console = (PythonConsole)this.currentConsole.get();
        return console != null ? console.getConsoleCommandsHistory() : null;
    }

    public void onTargetClose(@NonNull AbstractTarget target) {
        Platform.runLater(() -> this.stop(target));
    }

    public void onTargetDisconnected(@NonNull AbstractTarget target) {
        Platform.runLater(() -> {
            PythonConsole console = this.consoles.get(target);
            if (console != null) {
                console.startInterpreter(target);
            }
        });
    }

    public @NonNull ReadOnlyStringProperty getDisabledReason() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.disabledReason.getReadOnlyProperty());
    }
}

