/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptProgressMonitor
implements ICoreProgressMonitor {
    private final @NonNull ReadOnlyDoubleWrapper taskProgress = new ReadOnlyDoubleWrapper(0.0);
    private final @NonNull ReadOnlyStringWrapper taskName = new ReadOnlyStringWrapper("");
    private double currentProgress = 0.0;
    private double totalWork = 0.0;
    private @NonNull String name = "";

    public void setTask(@Nullable String name, int totalWork) {
        this.finished();
        this.totalWork = totalWork;
        this.name = (String)NullUtils.nonNullOrDefault((Object)name, (Object)"");
        if (totalWork < 0) {
            Platform.runLater(() -> {
                this.taskProgress.set(-1.0);
                this.taskName.set(name);
            });
        } else {
            Platform.runLater(() -> this.taskName.set("0% " + name));
        }
    }

    public void incProgress(int increment) {
        if (this.currentProgress >= this.totalWork) {
            return;
        }
        this.currentProgress = this.currentProgress + (double)increment >= this.totalWork ? this.totalWork : (this.currentProgress += (double)increment);
        double progressPercentage = this.currentProgress / this.totalWork;
        String newName = String.valueOf(Long.toString(Math.round(progressPercentage * 100.0))) + "% " + this.name;
        Platform.runLater(() -> {
            this.taskProgress.set(progressPercentage);
            this.taskName.set(newName);
        });
    }

    public void finished() {
        this.currentProgress = 0.0;
        this.totalWork = 0.0;
        this.name = "";
        Platform.runLater(() -> {
            this.taskProgress.set(0.0);
            this.taskName.set("");
        });
    }

    public boolean isCancelled() {
        return false;
    }

    public @NonNull ReadOnlyDoubleProperty taskProgress() {
        return (ReadOnlyDoubleProperty)NullUtils.neverNull((Object)this.taskProgress.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyStringProperty taskName() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.taskName.getReadOnlyProperty());
    }
}

