/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class RunnableWatchService<T>
implements Runnable {
    private final @NonNull WatchService watchService;
    private final @NonNull Map<File, Set<@NonNull Watcher>> fileMap = new HashMap<File, Set<Watcher>>();
    private final @NonNull IFileChangedEventListener<T> fileChangedEventListener;

    public RunnableWatchService(@NonNull IFileChangedEventListener<T> fileChangedEventListener) throws IOException {
        this.fileChangedEventListener = fileChangedEventListener;
        this.watchService = (WatchService)NullUtils.neverNull((Object)FileSystems.getDefault().newWatchService());
    }

    /*
     * Exception decompiling
     */
    public synchronized boolean watchDirectory(@NonNull File directoryToWatch, @NonNull T associatedItem, @NonNull FileFilter fileFilter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.pathIterator()" because the return value of "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.access$300(org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated)" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated$Iterator.moveNested(JavaRefTypeInstance.java:200)
         *     at org.benf.cfr.reader.entities.attributes.TypePathPartNested.apply(TypePathPartNested.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:54)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:45)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.handleStatement(TypeAnnotationTransformer.java:141)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:61)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:55)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.applyTypeAnnotations(Op04StructuredStatement.java:733)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:957)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized boolean watchParents(@NonNull File fileToWatchParents, @NonNull T associatedItem) throws IOException {
        File parent = fileToWatchParents.getParentFile();
        File child = fileToWatchParents;
        boolean allWatchesAdded = true;
        while (parent != null) {
            allWatchesAdded &= this.watchDirectory(parent, associatedItem, new ChildFileFilter(child));
            child = parent;
            parent = parent.getParentFile();
        }
        return allWatchesAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (ClosedWatchServiceException cwse) {
                return;
            }
            catch (InterruptedException x) {
                continue;
            }
            RunnableWatchService runnableWatchService = this;
            synchronized (runnableWatchService) {
                if (!key.isValid()) {
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> pathEvent = event;
                    Path filename = (Path)pathEvent.context();
                    File directory = null;
                    try {
                        directory = ((Path)key.watchable()).toFile().getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!this.fileMap.containsKey(directory)) continue;
                    File changed = ((Path)key.watchable()).resolve(filename).toFile();
                    for (Watcher watcher : (Set)NullUtils.neverNull(this.fileMap.get(directory))) {
                        if (!watcher.filter.accept(changed)) continue;
                        this.fileChangedEventListener.directoryUpdated(watcher.itemWatching);
                    }
                }
                boolean valid = key.reset();
                assert (valid) : "Key cancelled while an event was still coming in.";
            }
        }
    }

    public synchronized void stopWatchingDirectory(@NonNull File directoryToStopWatching, @NonNull T associatedItem) {
        File realDirectoryToWatch = null;
        try {
            realDirectoryToWatch = directoryToStopWatching.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Set<@NonNull Watcher> watchers = this.fileMap.get(realDirectoryToWatch);
        Watcher watcherToRemove = null;
        if (watchers != null) {
            for (Watcher watchDatum : watchers) {
                if (watchDatum.itemWatching != associatedItem) continue;
                watcherToRemove = watchDatum;
                break;
            }
            if (watcherToRemove != null) {
                watchers.remove(watcherToRemove);
                if (watchers.isEmpty()) {
                    this.fileMap.remove(realDirectoryToWatch);
                    watcherToRemove.key.cancel();
                }
            }
        }
    }

    public synchronized void stopWatchingParents(@NonNull File fileToStopWatching, @NonNull T associatedItem) {
        File parentFile = fileToStopWatching.getParentFile();
        while (parentFile != null) {
            this.stopWatchingDirectory(parentFile, associatedItem);
            parentFile = parentFile.getParentFile();
        }
    }

    public synchronized void shutdown() {
        try {
            this.watchService.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileMap.clear();
    }

    private static class ChildFileFilter
    implements FileFilter {
        private final @NonNull File child;

        private ChildFileFilter(@NonNull File child) {
            this.child = child;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.equals(this.child);
        }

        public boolean equals(Object other) {
            if (!(other instanceof ChildFileFilter)) {
                return false;
            }
            ChildFileFilter otherFilter = (ChildFileFilter)other;
            return this.child.equals(otherFilter.child);
        }

        public int hashCode() {
            return this.child.hashCode();
        }
    }

    public static interface IFileChangedEventListener<E> {
        public void directoryUpdated(E var1);
    }

    private class Watcher {
        private final @NonNull T itemWatching;
        private final @NonNull WatchKey key;
        private final @NonNull FileFilter filter;

        private Watcher(@NonNull T itemWatching, @NonNull WatchKey key, FileFilter filter) {
            this.itemWatching = itemWatching;
            this.key = key;
            this.filter = filter;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Watcher)) {
                return false;
            }
            Watcher otherWatcher = (Watcher)other;
            return this.itemWatching.equals(this.itemWatching) && this.filter.equals(otherWatcher.filter) && this.key.equals(otherWatcher.key);
        }

        public int hashCode() {
            return Objects.hash(this.itemWatching, this.key, this.filter);
        }
    }
}

