/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.GlesModel;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;

public class RenderbuffersViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GlRenderbufferAsset.Value> tableData = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());

    public RenderbuffersViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
    }

    public ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GlRenderbufferAsset.Value> getFilteredTableData() {
        return this.tableData;
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> {
            this.tableData.clear();
            navigationUriChangeEvent.getNewResolvedFunctionCall(functionCall -> {
                if (functionCall == null) {
                    return null;
                }
                FunctionCallID functionCallID = functionCall.getID();
                GlesModel glesModel = functionCall.getModel().getParentProcessTarget().getLightweightProcess().getGlesModel();
                GlesContext glContext = glesModel.getContextForFunctionCall(functionCall);
                if (glContext != null) {
                    @NonNull Iterator iterator = glesModel.getPerContextGroupAssets(glContext.getContextGroup()).childAssetIterator(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS);
                    while (iterator.hasNext()) {
                        GlRenderbufferAsset renderbuffer = (GlRenderbufferAsset)iterator.next();
                        try {
                            if (!renderbuffer.getLifecycleManager().isAssetLive(functionCallID)) continue;
                            this.tableData.add((Object)((GlRenderbufferAsset.Value)renderbuffer.waitForValue(glContext.getAssetProcessorCallbacks(), functionCall.getID())));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            });
        });
    }
}

