/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationUriVisitor;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.renderpassdependencies.DependencyAnalyserTask;
import com.arm.mgd.core.renderpassdependencies.IRenderPassDependency;
import com.arm.mgd.core.renderpassdependencies.RenderPassDependency;
import com.arm.mgd.core.renderpassdependencies.RenderPassDependencySet;
import com.arm.mgd.core.target.data.CompletableProgressFuture;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.IFunctionCallModelListener;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RenderPassDependencyViewController
implements IFunctionCallModelListener {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final ReadOnlyObjectWrapper<TreeItem<IRenderPassDependency>> rootItem = new ReadOnlyObjectWrapper();
    private final ReadOnlyBooleanWrapper isGenerateButtonDisabled = new ReadOnlyBooleanWrapper(true);
    private final Map<TraceDataModel, TreeItem<IRenderPassDependency>> rootItemCache = new WeakHashMap<TraceDataModel, TreeItem<IRenderPassDependency>>();
    private TraceDataModel currentModel = null;
    private Frame currentFrame = null;
    private DependencyAnalyserTask currentDependencyAnalyserTask = null;
    private CompletableProgressFuture<List<RenderPassDependencySet>> renderDependencyFuture = null;
    private final ReadOnlyBooleanWrapper progressVisible = new ReadOnlyBooleanWrapper(false);
    private final ReadOnlyBooleanWrapper contentToDisplay = new ReadOnlyBooleanWrapper(false);
    private final ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper(0.0);
    private final @NonNull ExecutorService executor = NamedExecutors.cachedFiniteThreadPool((int)1, (long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("RenderPassDependencyViewController Executor"));

    public RenderPassDependencyViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.contentToDisplay.bind((ObservableValue)this.rootItem.isNotNull());
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        this.disposeDependencyAnalyserTask(this.currentModel);
        this.currentModel = null;
        this.currentFrame = null;
        this.executor.shutdown();
    }

    private void disposeDependencyAnalyserTask(@Nullable TraceDataModel model) {
        if (this.renderDependencyFuture != null) {
            this.renderDependencyFuture.cancel(true);
        }
        if (model != null) {
            model.removeListener((IFunctionCallModelListener)this);
        }
    }

    public void generateTree() {
        Platform.runLater(() -> {
            final @Nullable Frame frame = this.currentFrame;
            @Nullable TraceDataModel model = this.currentModel;
            if (frame == null || model == null) {
                return;
            }
            final TreeItem root = new TreeItem((Object)new IRenderPassDependency(){

                public String getAsString() {
                    return frame.getLabelText();
                }
            });
            this.rootItem.set((Object)root);
            if (this.currentDependencyAnalyserTask != null && !this.renderDependencyFuture.isDone()) {
                this.renderDependencyFuture.cancel(true);
                this.progressVisible.set(false);
            }
            this.currentDependencyAnalyserTask = new DependencyAnalyserTask(model, frame);
            this.progressVisible.set(true);
            this.renderDependencyFuture = this.currentDependencyAnalyserTask.getFuture();
            this.renderDependencyFuture.whenComplete((BiConsumer)new BiConsumer<List<RenderPassDependencySet>, Throwable>(){

                @Override
                public void accept(List<RenderPassDependencySet> frameDependencies, Throwable u) {
                    Platform.runLater(() -> {
                        if (frameDependencies != null) {
                            for (RenderPassDependencySet currentRenderPassDependencyList : frameDependencies) {
                                TreeItem renderPassDependencyListTreeItem = new TreeItem((Object)currentRenderPassDependencyList);
                                root.getChildren().add((Object)renderPassDependencyListTreeItem);
                                for (RenderPassDependency currentRenderPassDependency : currentRenderPassDependencyList.getRenderPassDependencies()) {
                                    TreeItem renderPassDependencyItem = new TreeItem((Object)currentRenderPassDependency);
                                    renderPassDependencyListTreeItem.getChildren().add((Object)renderPassDependencyItem);
                                }
                            }
                            RenderPassDependencyViewController.this.progressVisible.set(false);
                        }
                    });
                }
            }).exceptionally(t -> {
                this.progressVisible.set(false);
                return null;
            });
            this.renderDependencyFuture.addMonitor(new ICoreProgressMonitor(){
                private int totalWork;
                private int currentWorkDone;

                public void setTask(String name, int totalWork) {
                    this.totalWork = totalWork;
                    this.currentWorkDone = 0;
                    Platform.runLater(() -> RenderPassDependencyViewController.this.progress.set(0.0));
                }

                public void incProgress(int n) {
                    ++this.currentWorkDone;
                    Platform.runLater(() -> RenderPassDependencyViewController.this.progress.set((double)this.currentWorkDone / (double)this.totalWork));
                }

                public boolean isCancelled() {
                    return false;
                }
            });
            this.executor.execute((Runnable)this.currentDependencyAnalyserTask);
        });
    }

    public ReadOnlyObjectProperty<TreeItem<IRenderPassDependency>> getRootProperty() {
        return this.rootItem.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty isGenerateButtonDisabled() {
        return this.isGenerateButtonDisabled.getReadOnlyProperty();
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> {
            TraceDataModel oldModel = this.currentModel;
            navigationUriChangeEvent.newUriAccept((INavigationUriVisitor)new INavigationUriVisitor<Void>(){

                public Void dontCare() {
                    RenderPassDependencyViewController.this.currentModel = null;
                    RenderPassDependencyViewController.this.currentFrame = null;
                    return null;
                }

                public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model) {
                    RenderPassDependencyViewController.this.currentModel = model;
                    RenderPassDependencyViewController.this.currentFrame = null;
                    return null;
                }

                public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model, @NonNull Frame frame) {
                    RenderPassDependencyViewController.this.currentModel = model;
                    RenderPassDependencyViewController.this.currentFrame = frame;
                    return null;
                }
            });
            this.isGenerateButtonDisabled.set(this.currentFrame == null);
            TraceDataModel newModel = this.currentModel;
            if (oldModel != newModel) {
                if (oldModel != null) {
                    this.rootItemCache.put(oldModel, (TreeItem<IRenderPassDependency>)((TreeItem)this.rootItem.get()));
                    oldModel.removeListener((IFunctionCallModelListener)this);
                }
                TreeItem<IRenderPassDependency> newRootItem = null;
                if (newModel != null) {
                    newModel.addListener((IFunctionCallModelListener)this);
                    newRootItem = this.rootItemCache.get(newModel);
                }
                this.rootItem.set(newRootItem);
                this.progressVisible.set(false);
                this.currentModel = newModel;
            }
        });
    }

    public ReadOnlyDoubleProperty progress() {
        return this.progress.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty progressVisible() {
        return this.progressVisible.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty contentToDisplay() {
        return this.contentToDisplay.getReadOnlyProperty();
    }

    public void onFunctionCallModelComplete(@NonNull TraceDataModel completedModel) {
    }

    public void onFunctionCallModelClose(@NonNull TraceDataModel closingModel, @NonNull ICoreProgressMonitor monitor) {
        this.disposeDependencyAnalyserTask(closingModel);
    }
}

