/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.scripting.python.InterpreterDaemon;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.controllers.ConsoleCommandsHistory;
import com.arm.mgd.ui.controllers.ConsoleTextBuilder;
import com.arm.mgd.ui.controllers.IConsoleCommandsHistory;
import com.arm.mgd.ui.controllers.ScriptProgressMonitor;
import com.arm.mgd.ui.dialogs.ScriptingInputDialog;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PythonConsole {
    public static final @NonNull String PS1 = ">>> ";
    public static final @NonNull String PS2 = "... ";
    public static final int MAX_NO_CONSOLE_LINES = 1500;
    private final @NonNull ReadOnlyBooleanWrapper isInterpreterBusy = new ReadOnlyBooleanWrapper(false);
    private @NonNull StringJoiner source;
    private final @NonNull ConsoleTextBuilder consoleStringBuilder = new ConsoleTextBuilder(1500);
    private final @NonNull ReadOnlyIntegerWrapper caretPosition = new ReadOnlyIntegerWrapper();
    private final @NonNull ReadOnlyIntegerWrapper currentLineNumber = new ReadOnlyIntegerWrapper();
    private final @NonNull ReadOnlyStringWrapper currentPrompt = new ReadOnlyStringWrapper(">>> ");
    private final @NonNull SimpleDoubleProperty savedScrollTop = new SimpleDoubleProperty(Double.MAX_VALUE);
    private final @NonNull ReadOnlyBooleanWrapper started = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ConsoleCommandsHistory consoleCommandsHistory = new ConsoleCommandsHistory(1500);
    private final @NonNull InterpreterOutputWriter outputWriter;
    private final @NonNull InterpreterOutputWriter errorWriter;
    private final @NonNull InterpreterDaemon interpreter;
    private final @NonNull ScriptProgressMonitor monitor = new ScriptProgressMonitor();
    private static final @NonNull String DOCS = "Read a string from a dialog box. The trailing newline is stripped.\nThe optional prompt will be shown in the dialog box.\nIf the user cancels or closes the dialog, the empty string is returned.\n";
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InterpreterDaemon.UserInputFunction uiInputFunction = new InterpreterDaemon.UserInputFunction("Read a string from a dialog box. The trailing newline is stripped.\nThe optional prompt will be shown in the dialog box.\nIf the user cancels or closes the dialog, the empty string is returned.\n", (Function)new Function<String, String>(){

        @Override
        public @NonNull String apply(@Nullable String t) {
            CompletableFuture<@NonNull T> futureOutput = new CompletableFuture();
            Platform.runLater(() -> {
                Optional<@Nullable @NonNull R> dialogOutput = new ScriptingInputDialog(t).showAndWaitForResult();
                if (dialogOutput.isPresent()) {
                    futureOutput.complete((String)NullUtils.neverNull((Object)((String)dialogOutput.get())));
                } else {
                    futureOutput.complete("");
                }
            });
            try {
                return (String)futureOutput.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return "";
            }
        }
    });

    public PythonConsole() {
        this.source = new StringJoiner(ConsoleTextBuilder.LINE_SEPARATOR);
        this.caretPosition.set(this.consoleStringBuilder.getCaretPosition());
        this.currentLineNumber.set(this.consoleStringBuilder.getCurrentLineNumber());
        this.outputWriter = new InterpreterOutputWriter(this.consoleStringBuilder, this.currentLineNumber);
        this.errorWriter = new InterpreterOutputWriter(this.consoleStringBuilder, this.currentLineNumber);
        this.interpreter = new InterpreterDaemon((Writer)this.outputWriter, (Writer)this.errorWriter, (ICoreProgressMonitor)this.monitor, uiInputFunction);
    }

    public void startInterpreter(@NonNull AbstractTarget trace) {
        assert (Platform.isFxApplicationThread());
        assert (trace.isDisconnected());
        assert (!this.started.get());
        this.interpreter.setTarget(trace);
        CompletableFuture.runAsync((Runnable)this.interpreter);
        this.started.set(true);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull CompletableFuture<@NonNull String> runSourceFromConsole(@NonNull String sourceLineWithPrompt) {
        this.isInterpreterBusy.set(true);
        this.consoleStringBuilder.append(String.valueOf(sourceLineWithPrompt) + ConsoleTextBuilder.LINE_SEPARATOR);
        String sourceLine = sourceLineWithPrompt.substring(PS1.length());
        this.source.add(sourceLine);
        if (!sourceLine.isEmpty()) {
            this.consoleCommandsHistory.append(String.valueOf(sourceLine) + ConsoleTextBuilder.LINE_SEPARATOR);
        }
        @NonNull @NonNull CompletableFuture moreFuture = this.interpreter.runSource((String)NullUtils.neverNull((Object)this.source.toString()));
        @NonNull CompletableFuture<@NonNull String> promptFuture = new CompletableFuture<String>();
        ((CompletableFuture)moreFuture.thenAccept(partialStatement -> {
            if (partialStatement.booleanValue()) {
                this.currentPrompt.set(PS2);
                promptFuture.complete(PS2);
            } else {
                this.source = new StringJoiner(ConsoleTextBuilder.LINE_SEPARATOR);
                this.currentPrompt.set(PS1);
                promptFuture.complete(PS1);
            }
            this.currentLineNumber.set(this.consoleStringBuilder.getCurrentLineNumber());
            this.isInterpreterBusy.set(false);
        })).exceptionally(t -> {
            this.source = new StringJoiner(ConsoleTextBuilder.LINE_SEPARATOR);
            this.consoleStringBuilder.append("<interrupted>\n");
            this.currentPrompt.set(PS1);
            this.currentLineNumber.set(this.consoleStringBuilder.getCurrentLineNumber());
            this.isInterpreterBusy.set(false);
            promptFuture.complete(PS1);
            return null;
        });
        return promptFuture;
    }

    public @NonNull ReadOnlyBooleanProperty isInterpreterBusy() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.isInterpreterBusy.getReadOnlyProperty());
    }

    public @NonNull String getConsoleText() {
        return this.consoleStringBuilder.getText();
    }

    public void clear() {
        this.consoleStringBuilder.reset();
        this.currentLineNumber.set(this.consoleStringBuilder.getCurrentLineNumber());
        this.source = new StringJoiner(ConsoleTextBuilder.LINE_SEPARATOR);
    }

    public void stop() {
        this.interpreter.stop();
    }

    public void interrupt() {
        this.interpreter.interrupt();
    }

    public void reset() {
        this.interpreter.reset();
        this.monitor.finished();
    }

    public @NonNull ReadOnlyIntegerProperty caretPosition() {
        return (ReadOnlyIntegerProperty)NullUtils.neverNull((Object)this.caretPosition.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyIntegerProperty currentLineNumber() {
        return (ReadOnlyIntegerProperty)NullUtils.neverNull((Object)this.currentLineNumber.getReadOnlyProperty());
    }

    public @NonNull IConsoleCommandsHistory getConsoleCommandsHistory() {
        return this.consoleCommandsHistory;
    }

    public @NonNull ReadOnlyStringProperty currentPrompt() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.currentPrompt.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyDoubleProperty taskProgress() {
        return this.monitor.taskProgress();
    }

    public @NonNull ReadOnlyStringProperty taskLabel() {
        return this.monitor.taskName();
    }

    public @NonNull ReadOnlyBooleanProperty isStarted() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.started.getReadOnlyProperty());
    }

    public @NonNull DoubleProperty savedScrollTop() {
        return this.savedScrollTop;
    }

    public static class InterpreterOutputWriter
    extends Writer {
        private final @NonNull ConsoleTextBuilder consoleTextBuilder;
        private final @NonNull ReadOnlyIntegerWrapper currentLineNumber;
        private final @NonNull StringBuilder internalStringBuilder = new StringBuilder();

        public InterpreterOutputWriter(@NonNull ConsoleTextBuilder consoleStringBuilder, @NonNull ReadOnlyIntegerWrapper currentLineNumber) {
            this.consoleTextBuilder = consoleStringBuilder;
            this.currentLineNumber = currentLineNumber;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            assert (off < cbuf.length);
            int i = off;
            while (i < len) {
                this.internalStringBuilder.append(cbuf[i]);
                ++i;
            }
        }

        @Override
        public void flush() throws IOException {
            this.consoleTextBuilder.append((String)NullUtils.neverNull((Object)this.internalStringBuilder.toString()));
            this.internalStringBuilder.setLength(0);
            this.currentLineNumber.set(this.consoleTextBuilder.getCurrentLineNumber());
        }

        @Override
        public void close() throws IOException {
        }
    }
}

