/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.FileTarget;
import com.arm.mgd.core.target.io.ProcessMarshaller;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.io.connection.FileConnection;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controls.ProcessUploaderAndroidDeviceControl;
import com.arm.mgd.ui.dialogs.SimpleModalMessageDialog;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;

public class ProcessReplayUploaderDialogController {
    private static final @NonNull Set<IADBTask<?>> COMPLETED_TASKS = (Set)NullUtils.neverNull(Collections.newSetFromMap(new WeakHashMap()));
    private static final @NonNull ReadOnlyBooleanWrapper UPLOADING_PROPERTY = new ReadOnlyBooleanWrapper(false);
    private static final @NonNull ReadOnlyBooleanWrapper CANCELLED_PROPERTY = new ReadOnlyBooleanWrapper(false);
    private static final @NonNull ICoreProgressMonitor CANCELLED_MONITOR = new ICoreProgressMonitor(){

        public void setTask(String name, int totalWork) {
        }

        public boolean isCancelled() {
            return CANCELLED_PROPERTY.get();
        }

        public void incProgress(int n) {
        }
    };
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ADBTaskManager.PublicTaskListener listener;
    private final @NonNull ProcessUploaderAndroidDeviceControl androidDeviceControl = new ProcessUploaderAndroidDeviceControl(ProcessReplayUploaderDialogController.getUploadingProperty());
    private final @NonNull ExecutorService executor = (ExecutorService)NullUtils.neverNull((Object)Executors.newSingleThreadExecutor());
    private final int processID;
    private final @NonNull AbstractTarget target;

    public ProcessReplayUploaderDialogController(int processID, @NonNull AbstractTarget target) {
        this.processID = processID;
        this.target = target;
        this.listener = new ADBTaskManager.PublicTaskListener(){

            public void onTaskCompleted(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull ADBTaskManager.CompletedTask<Void> completedTask) {
                if (COMPLETED_TASKS.contains(completedTask.getTask())) {
                    return;
                }
                if (completedTask.getTask().getTag() != AndroidBridge.ConnectionOperationTag.REPLAY_UPLOAD_TAG) {
                    return;
                }
                UPLOADING_PROPERTY.set(false);
                COMPLETED_TASKS.add(completedTask.getTask());
                completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<Void>(){

                    public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IADBTask.TaskResult<Void> result) {
                        ProcessReplayUploaderDialogController.launchUploadOutcomeDialog(UploadOutcome.SUCCESS, null);
                    }

                    public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IADBTask.InvalidADBException exception) {
                        ProcessReplayUploaderDialogController.launchUploadOutcomeDialog(UploadOutcome.EXCEPTION_THROWN_UPLOAD, "Failed to upload the trace file:\n\n" + exception.getMessage());
                    }

                    public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IADBTask.ADBExecutionException exception) {
                        ProcessReplayUploaderDialogController.launchUploadOutcomeDialog(UploadOutcome.EXCEPTION_THROWN_UPLOAD, "Failed to upload the trace file:\n\n" + exception.getMessage());
                    }
                });
            }

            public void onTaskStarted(@NonNull IADBTask<Void> task) {
            }

            public void onTaskRemoved(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull ADBTaskManager.CompletedTask<Void> completedTask) {
            }

            public void onTaskAdded(@NonNull IADBTask<Void> task) {
            }
        };
        CoreInstance.getADBTaskManager().addListener(this.listener);
        UPLOADING_PROPERTY.addListener((observable, oldVal, newVal) -> {
            if (oldVal.booleanValue() && !newVal.booleanValue()) {
                CANCELLED_PROPERTY.set(false);
            }
        });
    }

    private static void launchUploadOutcomeDialog(@NonNull UploadOutcome outcome, @Nullable String customDescription) {
        String description = customDescription != null ? customDescription : outcome.description;
        switch (outcome) {
            case EXCEPTION_THROWN_MARSHALLING: 
            case EXCEPTION_THROWN_UPLOAD: {
                Platform.runLater(() -> new SimpleModalMessageDialog("Upload failed", description).showAndWait());
                return;
            }
            case SUCCESS: {
                Platform.runLater(() -> new SimpleModalMessageDialog("Upload successful", description).showAndWait());
                return;
            }
            case CANCELLED: {
                Platform.runLater(() -> new SimpleModalMessageDialog("Upload cancelled", description).showAndWait());
                return;
            }
        }
        assert (false);
    }

    public static @NonNull ReadOnlyBooleanProperty getUploadingProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)UPLOADING_PROPERTY.getReadOnlyProperty());
    }

    public static @NonNull ReadOnlyBooleanProperty getUploadingCancelledProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)CANCELLED_PROPERTY.getReadOnlyProperty());
    }

    public @NonNull ProcessUploaderAndroidDeviceControl getAndroidDeviceControl() {
        return this.androidDeviceControl;
    }

    public @NonNull ShellListener getShellListener() {
        return new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                if (UPLOADING_PROPERTY.get()) {
                    e.doit = false;
                }
            }

            public void shellActivated(ShellEvent e) {
            }
        };
    }

    public void uploadMarshalledTrace() {
        @Nullable AndroidDeviceControlItem item = (AndroidDeviceControlItem)this.androidDeviceControl.getSelectedItemProperty().get();
        if (item == null) {
            return;
        }
        this.androidDeviceControl.setUploaderIndicatorText(ProcessUploaderAndroidDeviceControl.UploaderState.MARSHALLING);
        this.executor.execute(() -> {
            try {
                FileTarget fileTarget;
                UPLOADING_PROPERTY.set(true);
                if (this.target instanceof FileTarget && (fileTarget = (FileTarget)this.target).getModels().size() == 1) {
                    FileConnection connection = (FileConnection)fileTarget.getConnection();
                    this.uploadToTarget(item, connection.getFile());
                    return;
                }
                ProcessTarget process = this.target.getProcessTarget(this.processID);
                if (process == null) {
                    assert (false);
                    return;
                }
                File temp = new File(FileUtils.getTemporaryDirectory().getAbsoluteFile() + File.separator + ProcessReplayUploaderDialogController.getNameForReplay(process) + ".mgd");
                if (temp.exists()) {
                    temp.delete();
                }
                if (!temp.createNewFile()) {
                    throw new IOException("MGD was unable to create a temporary file on disk for unknown reasons.");
                }
                ProcessMarshaller.marshallFunctionCallsForProcess((int)this.processID, (AbstractTarget)this.target, (File)temp, (ICoreProgressMonitor)CANCELLED_MONITOR);
                if (CANCELLED_PROPERTY.get()) {
                    UPLOADING_PROPERTY.set(false);
                    ProcessReplayUploaderDialogController.launchUploadOutcomeDialog(UploadOutcome.CANCELLED, null);
                    return;
                }
                this.uploadToTarget(item, temp);
            }
            catch (ProcessMarshaller.NoProcessFoundException | IOException e) {
                UPLOADING_PROPERTY.set(false);
                ProcessReplayUploaderDialogController.launchUploadOutcomeDialog(UploadOutcome.EXCEPTION_THROWN_MARSHALLING, null);
            }
            catch (UnsupportedTypeException e) {
                UPLOADING_PROPERTY.set(false);
                CoreLogging.severe((Throwable)e);
                ProcessReplayUploaderDialogController.launchUploadOutcomeDialog(UploadOutcome.EXCEPTION_THROWN_MARSHALLING, null);
            }
        });
    }

    private void uploadToTarget(@NonNull AndroidDeviceControlItem item, @NonNull File fileToUpload) {
        this.androidDeviceControl.setUploaderIndicatorText(ProcessUploaderAndroidDeviceControl.UploaderState.UPLOADING);
        CANCELLED_PROPERTY.set(true);
        item.uploadReplayFile(fileToUpload);
    }

    private static @NonNull String getNameForReplay(@NonNull ProcessTarget process) {
        return String.valueOf(process.getModel().getProcessName()) + "_" + process.getProcessID();
    }

    public void cancelMarshalling() {
        CANCELLED_PROPERTY.set(true);
    }

    private static enum UploadOutcome {
        SUCCESS("Trace file was uploaded successfully.\n\nYou can replay your trace file inside the " + VersionProperties.FULL_PRODUCT_NAME + " Android App on the device."),
        CANCELLED("Upload was cancelled."),
        EXCEPTION_THROWN_MARSHALLING("MGD could not upload the replay file because it encountered an internal error while marshalling the trace. The error has been logged."),
        EXCEPTION_THROWN_UPLOAD("Failed to upload the trace file.");

        private final @NonNull String description;

        private UploadOutcome(String description) {
            this.description = description;
        }
    }
}

