/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.IProcessConfigChangeListener;
import com.arm.mgd.core.target.io.ITargetEventListener;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.core.target.io.ProcessTarget;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessConfigStateController {
    private final @NonNull ObjectProperty<@Nullable FunctionCall> currentFunctionCallProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable ProcessTarget> currentProcessTargetProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable LiveProcessTarget> currentLiveProcessTargetProperty = new SimpleObjectProperty();
    private @Nullable ProcessConfigHistory currentProcessConfig = null;
    private final @NonNull ObjectProperty<@Nullable AbstractTarget> currentTargetProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable LiveTarget> currentLiveTargetProperty = new SimpleObjectProperty();
    private @Nullable ProcessConfig currentDefaultProcessConfig = null;
    private boolean isCurrentTargetDisconnected = true;
    private final @NonNull ObjectProperty<@Nullable ProcessConfigState> processConfigStateProperty = new SimpleObjectProperty();
    private final @NonNull INavigationChangedListener navigationChangeListener = new INavigationChangedListener(){

        public void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
            Platform.runLater(() -> navigationUriChangeEvent.getNewResolvedFunctionCall(functionCall -> {
                ProcessConfigStateController.this.currentFunctionCallProperty.set(functionCall);
                if (functionCall == null) {
                    ProcessConfigStateController.this.currentTargetProperty.set((Object)CoreInstance.getNavigationManager().getActiveTarget());
                }
                ProcessConfigStateController.this.updateConfigurationState();
                return null;
            }));
        }
    };
    private final @NonNull IProcessConfigChangeListener processTargetConfigChangeListener = new IProcessConfigChangeListener(){

        public void onConfigChanged(@NonNull Object parent, @NonNull ProcessConfig oldConfig, @NonNull ProcessConfig newConfig) {
            Platform.runLater(() -> {
                LiveProcessTarget currentLiveProcessTarget = (LiveProcessTarget)ProcessConfigStateController.this.currentLiveProcessTargetProperty.get();
                if (currentLiveProcessTarget == parent) {
                    ProcessConfigStateController.this.currentProcessConfig = currentLiveProcessTarget.getProcessConfig();
                    ProcessConfigStateController.this.updateConfigurationState();
                }
            });
        }
    };
    private final @NonNull ITargetEventListener targetDisconnectionListener = new ITargetEventListener(){

        public void onTargetDisconnected(@NonNull AbstractTarget abstractTarget) {
            Platform.runLater(() -> {
                if (ProcessConfigStateController.this.currentTargetProperty.get() == abstractTarget) {
                    ProcessConfigStateController.this.isCurrentTargetDisconnected = true;
                    ProcessConfigStateController.this.updateConfigurationState();
                }
            });
        }
    };
    private final @NonNull IProcessConfigChangeListener abstractTargetConfigChangeListener = new IProcessConfigChangeListener(){

        public void onConfigChanged(@NonNull Object parent, @NonNull ProcessConfig oldConfig, @NonNull ProcessConfig newConfig) {
            Platform.runLater(() -> {
                if (ProcessConfigStateController.this.currentTargetProperty.get() == parent) {
                    ProcessConfigStateController.this.currentDefaultProcessConfig = newConfig;
                    ProcessConfigStateController.this.updateConfigurationState();
                }
            });
        }
    };

    public ProcessConfigStateController() {
        this.currentFunctionCallProperty.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            ProcessTarget newTarget = newValue != null ? newValue.getModel().getParentProcessTarget() : null;
            this.currentProcessTargetProperty.set((Object)newTarget);
        });
        this.currentProcessTargetProperty.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            this.currentLiveProcessTargetProperty.set((Object)(newValue instanceof LiveProcessTarget ? (LiveProcessTarget)newValue : null));
            AbstractTarget newTarget = newValue != null ? newValue.getParentTarget() : null;
            this.currentTargetProperty.set((Object)newTarget);
        });
        this.currentLiveProcessTargetProperty.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.removeConfigChangedListener(this.processTargetConfigChangeListener);
            }
            this.currentProcessConfig = null;
            if (newValue != null) {
                newValue.addConfigChangedListener(this.processTargetConfigChangeListener);
                this.currentProcessConfig = newValue.getProcessConfig();
            }
        });
        this.currentTargetProperty.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.removeTargetEventListener(this.targetDisconnectionListener);
            }
            this.isCurrentTargetDisconnected = true;
            if (newValue != null) {
                this.isCurrentTargetDisconnected = newValue.isDisconnected();
                newValue.addTargetEventListener(this.targetDisconnectionListener);
            }
            this.currentLiveTargetProperty.set((Object)(newValue instanceof LiveTarget ? (LiveTarget)newValue : null));
        });
        this.currentLiveTargetProperty.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.removeConfigChangedListener(this.abstractTargetConfigChangeListener);
            }
            this.currentDefaultProcessConfig = null;
            if (newValue != null) {
                newValue.addConfigChangedListener(this.abstractTargetConfigChangeListener);
                this.currentDefaultProcessConfig = newValue.getProcessConfig();
            }
        });
        CoreInstance.getNavigationManager().addNavigationChangedListener(this.navigationChangeListener);
    }

    public void dispose() {
        assert (Platform.isFxApplicationThread());
        CoreInstance.getNavigationManager().removeNavigationChangedListener(this.navigationChangeListener);
        this.currentFunctionCallProperty.set(null);
        this.currentProcessTargetProperty.set(null);
        this.currentLiveProcessTargetProperty.set(null);
        this.currentProcessConfig = null;
        this.currentTargetProperty.set(null);
        this.currentLiveTargetProperty.set(null);
        this.currentDefaultProcessConfig = null;
        this.processConfigStateProperty.set(null);
    }

    private void updateConfigurationState() {
        ProcessConfigState newState;
        assert (Platform.isFxApplicationThread());
        @Nullable FunctionCall functionCall = (FunctionCall)this.currentFunctionCallProperty.get();
        @Nullable ProcessTarget processTarget = (ProcessTarget)this.currentProcessTargetProperty.get();
        @Nullable LiveProcessTarget liveProcessTarget = (LiveProcessTarget)this.currentLiveProcessTargetProperty.get();
        @Nullable ProcessConfigHistory processConfig = this.currentProcessConfig;
        @Nullable AbstractTarget target = (AbstractTarget)this.currentTargetProperty.get();
        @Nullable LiveTarget liveTarget = (LiveTarget)this.currentLiveTargetProperty.get();
        @Nullable ProcessConfig defaultProcessConfig = this.currentDefaultProcessConfig;
        boolean isTargetDisconnected = this.isCurrentTargetDisconnected;
        if (functionCall != null) {
            assert (processTarget != null);
            assert (target != null);
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ProcessConfigHistory.Range processConfigHistoryRange = processTarget.getProcessConfigsAtCallItem(functionCall);
            if (liveProcessTarget != null && !isTargetDisconnected) {
                assert (processConfig != null);
                assert (liveTarget != null);
                assert (defaultProcessConfig != null);
                newState = new ProcessConfigState.ConnectedProcessState(liveProcessTarget, processConfig);
            } else {
                newState = new ProcessConfigState.DisconnectedProcessState(functionCall, processConfigHistoryRange, processTarget, target);
            }
        } else if (liveTarget != null && !isTargetDisconnected) {
            assert (defaultProcessConfig != null);
            newState = new ProcessConfigState.DefaultConfigState(liveTarget, defaultProcessConfig);
        } else {
            newState = null;
        }
        this.processConfigStateProperty.set(newState);
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable ProcessConfigState> processConfigStateProperty() {
        return this.processConfigStateProperty;
    }

    static /* synthetic */ ObjectProperty access$0(ProcessConfigStateController processConfigStateController) {
        return processConfigStateController.currentFunctionCallProperty;
    }

    static /* synthetic */ ObjectProperty access$1(ProcessConfigStateController processConfigStateController) {
        return processConfigStateController.currentTargetProperty;
    }

    static /* synthetic */ void access$2(ProcessConfigStateController processConfigStateController) {
        processConfigStateController.updateConfigurationState();
    }

    public static abstract class ProcessConfigState {

        public static class ConnectedProcessState
        extends ProcessConfigState {
            public final @NonNull LiveProcessTarget processTarget;
            public final @NonNull ProcessConfigHistory processConfig;

            private ConnectedProcessState(@NonNull LiveProcessTarget processTarget, @NonNull ProcessConfigHistory processConfig) {
                this.processTarget = processTarget;
                this.processConfig = processConfig;
            }
        }

        public static class DefaultConfigState
        extends ProcessConfigState {
            public final @NonNull LiveTarget target;
            public final @NonNull ProcessConfig defaultProcessConfig;

            private DefaultConfigState(@NonNull LiveTarget target, @NonNull ProcessConfig defaultProcessConfig) {
                this.target = target;
                this.defaultProcessConfig = defaultProcessConfig;
            }
        }

        public static class DisconnectedProcessState
        extends ProcessConfigState {
            public final @NonNull FunctionCall functionCall;
            public final // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ProcessConfigHistory.Range processConfigHistoryRange;
            public final @NonNull ProcessTarget processTarget;
            public final @NonNull AbstractTarget target;

            private DisconnectedProcessState(@NonNull FunctionCall functionCall, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ProcessConfigHistory.Range processConfigHistoryRange, @NonNull ProcessTarget processTarget, @NonNull AbstractTarget target) {
                this.functionCall = functionCall;
                this.processConfigHistoryRange = processConfigHistoryRange;
                this.processTarget = processTarget;
                this.target = target;
            }
        }
    }
}

