/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.ui.controllers.ProcessConfigStateController;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessConfigController {
    private final @NonNull ProcessConfigStateController processConfigStateController = new ProcessConfigStateController();
    private final @NonNull ObjectProperty<@NonNull ProcessConfigInfo> processConfigInfoProperty = new SimpleObjectProperty((Object)new ProcessConfigInfo(false, null, null, false));
    private final @NonNull WeakHashMap<LiveTarget, Void> seenLiveTargets = new WeakHashMap();

    public ProcessConfigController() {
        this.processConfigStateController.processConfigStateProperty().addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            this.onConfigurationChange((ProcessConfigStateController.ProcessConfigState)newValue);
        });
        this.onConfigurationChange((ProcessConfigStateController.ProcessConfigState)this.processConfigStateController.processConfigStateProperty().get());
    }

    public void dispose() {
        this.processConfigStateController.dispose();
    }

    private void onConfigurationChange(@Nullable ProcessConfigStateController.ProcessConfigState configState) {
        @Nullable ProcessConfig processConfig = null;
        boolean isProcessConfigChangeable = false;
        ProcessConfigHistory.Range functionCallHistoryRangeProperty = null;
        boolean isFirstTimeWeveSeenLiveTarget = false;
        if (configState instanceof ProcessConfigStateController.ProcessConfigState.ConnectedProcessState) {
            ProcessConfigStateController.ProcessConfigState.ConnectedProcessState state = (ProcessConfigStateController.ProcessConfigState.ConnectedProcessState)configState;
            processConfig = state.processConfig.processConfig;
            isProcessConfigChangeable = true;
            functionCallHistoryRangeProperty = new ProcessConfigHistory.Range(state.processConfig, null);
        } else if (configState instanceof ProcessConfigStateController.ProcessConfigState.DisconnectedProcessState) {
            ProcessConfigStateController.ProcessConfigState.DisconnectedProcessState state = (ProcessConfigStateController.ProcessConfigState.DisconnectedProcessState)configState;
            processConfig = state.processConfigHistoryRange.processConfigStart.processConfig;
            functionCallHistoryRangeProperty = state.processConfigHistoryRange;
        } else if (configState instanceof ProcessConfigStateController.ProcessConfigState.DefaultConfigState) {
            ProcessConfigStateController.ProcessConfigState.DefaultConfigState state = (ProcessConfigStateController.ProcessConfigState.DefaultConfigState)configState;
            processConfig = state.defaultProcessConfig;
            isProcessConfigChangeable = true;
            if (!this.seenLiveTargets.containsKey(state.target)) {
                this.seenLiveTargets.put(state.target, null);
                isFirstTimeWeveSeenLiveTarget = true;
            }
        } else assert (configState == null);
        this.processConfigInfoProperty.set((Object)new ProcessConfigInfo(isProcessConfigChangeable, processConfig, functionCallHistoryRangeProperty, isFirstTimeWeveSeenLiveTarget));
    }

    public @NonNull ReadOnlyObjectProperty<@NonNull ProcessConfigInfo> activeProcessConfigProperty() {
        return this.processConfigInfoProperty;
    }

    public void setActiveProcessConfiguration(@NonNull ProcessConfig config) {
        assert (Platform.isFxApplicationThread());
        @Nullable ProcessConfigStateController.ProcessConfigState configState = (ProcessConfigStateController.ProcessConfigState)this.processConfigStateController.processConfigStateProperty().get();
        if (configState instanceof ProcessConfigStateController.ProcessConfigState.ConnectedProcessState) {
            ((ProcessConfigStateController.ProcessConfigState.ConnectedProcessState)configState).processTarget.setProcessConfig(config);
        } else if (configState instanceof ProcessConfigStateController.ProcessConfigState.DefaultConfigState) {
            ((ProcessConfigStateController.ProcessConfigState.DefaultConfigState)configState).target.setProcessConfig(config);
        }
    }

    public static class ProcessConfigInfo {
        public final boolean isProcessConfigChangeable;
        public final @Nullable ProcessConfig activeProcessConfig;
        public final // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ProcessConfigHistory.Range activeProcessConfigRange;
        public final boolean isFirstTimeWeveSeenProcess;

        private ProcessConfigInfo(boolean isProcessConfigChangeable, @Nullable ProcessConfig activeProcessConfig, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ProcessConfigHistory.Range activeProcessConfigRange, boolean isFirstTimeWeveSeenProcess) {
            this.isProcessConfigChangeable = isProcessConfigChangeable;
            this.activeProcessConfig = activeProcessConfig;
            this.activeProcessConfigRange = activeProcessConfigRange;
            this.isFirstTimeWeveSeenProcess = isFirstTimeWeveSeenProcess;
        }
    }
}

