/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.controllers.IClipboardCopyable;
import com.arm.mgd.ui.controllers.SimpleTableViewController;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import javafx.application.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class NavigationChangeTableViewController<T extends IClipboardCopyable>
extends SimpleTableViewController<T> {
    private final @NonNull INavigationChangedListener navigationChangedListener;
    private @NonNull WeakReference<@Nullable TraceDataModel> currentModel = NullUtils.emptyWeakReference();

    protected NavigationChangeTableViewController() {
        this.navigationChangedListener = event -> this.onNavigationChanged(event);
    }

    protected @NonNull INavigationChangedListener getNavigationChangedListener() {
        return this.navigationChangedListener;
    }

    protected abstract void refreshData(@Nullable TraceStateSnapshot var1);

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> {
            this.refreshData(snapshot);
            TraceDataModel newModel = snapshot != null ? snapshot.getModel() : null;
            Platform.runLater(() -> {
                this.currentModel = new WeakReference<TraceDataModel>(newModel);
            });
        });
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super T> command) {
        assert (Platform.isFxApplicationThread());
        command.execute((TraceDataModel)this.currentModel.get(), Commands.makeSelectionList((List<Integer>)this.selectedIndices, this.getItemList()));
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super T> command) {
        assert (Platform.isFxApplicationThread());
        return command.isEnabled((TraceDataModel)this.currentModel.get(), Commands.makeSelectionList((List<Integer>)this.selectedIndices, this.getItemList()));
    }
}

