/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.devicediscovery.DeviceDiscoveryManager;
import com.arm.mgd.core.devicediscovery.IDeviceDiscoveryListener;
import com.arm.mgd.core.devicediscovery.LanDevice;
import com.arm.mgd.ui.controllers.LinuxDevice;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LinuxDeviceControlController {
    private static final int DELAY_SECONDS_UNTIL_INITIALIZED = 3;
    private final @NonNull HashMap<@NonNull String, LinuxDevice> ipAddressToLinuxDeviceMap = new HashMap();
    private final @NonNull ListProperty<@NonNull LinuxDevice> linuxDevicesProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final @NonNull ObjectProperty<@NonNull StatusInfo> statusInfoProperty = new SimpleObjectProperty((Object)new StatusInfo(DeviceDiscoveryManager.Status.RUNNING, null));
    private final @NonNull BooleanProperty initializationInProgressProperty = new SimpleBooleanProperty(true);
    private final @NonNull IDeviceDiscoveryListener listener = new IDeviceDiscoveryListener(){

        public void onStatusChanged(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DeviceDiscoveryManager.Status s, @Nullable Throwable e) {
            Platform.runLater(() -> {
                if (s != DeviceDiscoveryManager.Status.RUNNING) {
                    LinuxDeviceControlController.this.ipAddressToLinuxDeviceMap.clear();
                    LinuxDeviceControlController.this.linuxDevicesProperty.clear();
                }
                LinuxDeviceControlController.this.statusInfoProperty.set((Object)new StatusInfo(s, e));
            });
        }

        public void onDeviceUpdated(@NonNull LanDevice device) {
            Platform.runLater(() -> {
                LinuxDeviceControlController.this.initializationInProgressProperty.set(false);
                String ipAddress = device.getIp();
                @Nullable LinuxDevice deviceInfo = LinuxDeviceControlController.this.ipAddressToLinuxDeviceMap.get(ipAddress);
                if (deviceInfo == null) {
                    deviceInfo = new LinuxDevice(device);
                    LinuxDeviceControlController.this.ipAddressToLinuxDeviceMap.put(ipAddress, deviceInfo);
                    LinuxDeviceControlController.this.linuxDevicesProperty.add((Object)deviceInfo);
                    if (!$assertionsDisabled && LinuxDeviceControlController.this.ipAddressToLinuxDeviceMap.size() != LinuxDeviceControlController.this.linuxDevicesProperty.size()) {
                        throw new AssertionError();
                    }
                } else {
                    deviceInfo.update(device);
                }
            });
        }

        public void onDeviceRemoved(@NonNull String ipAddress) {
            Platform.runLater(() -> {
                LinuxDevice info = LinuxDeviceControlController.this.ipAddressToLinuxDeviceMap.remove(ipAddress);
                if (info != null) {
                    boolean removed = LinuxDeviceControlController.this.linuxDevicesProperty.remove((Object)info);
                    if (!$assertionsDisabled && !removed) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && LinuxDeviceControlController.this.ipAddressToLinuxDeviceMap.size() != LinuxDeviceControlController.this.linuxDevicesProperty.size()) {
                        throw new AssertionError();
                    }
                }
            });
        }
    };

    public LinuxDeviceControlController() {
        CoreInstance.getDeviceDiscoveryManager().addListener(this.listener);
        CoreInstance.getScheduledExecutorService().schedule(() -> Platform.runLater(() -> this.initializationInProgressProperty.set(false)), 3L, TimeUnit.SECONDS);
    }

    public void dispose() {
        CoreInstance.getDeviceDiscoveryManager().removeListener(this.listener);
        this.ipAddressToLinuxDeviceMap.clear();
        this.linuxDevicesProperty.clear();
    }

    public @NonNull ReadOnlyListProperty<@NonNull LinuxDevice> linuxDevicesProperty() {
        return this.linuxDevicesProperty;
    }

    public @NonNull ReadOnlyObjectProperty<@NonNull StatusInfo> statusInfoProperty() {
        return this.statusInfoProperty;
    }

    public @NonNull ReadOnlyBooleanProperty initializationInProgressProperty() {
        return this.initializationInProgressProperty;
    }

    public static class StatusInfo {
        public final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DeviceDiscoveryManager.Status status;
        public final @Nullable Throwable statusException;

        private StatusInfo(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DeviceDiscoveryManager.Status status, @Nullable Throwable statusException) {
            this.status = status;
            this.statusException = statusException;
        }
    }
}

