/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.devicediscovery.LanDevice;
import com.arm.mgd.core.target.marshaller.AbstractLiveTraceMarshaller;
import com.arm.mgd.ui.handlers.ConnectTargetHandler;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LinuxDevice {
    private final @NonNull String ipAddress;
    private final @NonNull StringProperty identifierProperty = new SimpleStringProperty();
    private final @NonNull StringProperty daemonProtocolVersionProperty = new SimpleStringProperty();
    private final @NonNull StringProperty glVendorProperty = new SimpleStringProperty();
    private final @NonNull StringProperty glVersionProperty = new SimpleStringProperty();
    private final @NonNull StringProperty glRendererProperty = new SimpleStringProperty();
    private final @NonNull ObjectProperty<@NonNull ConnectionStatus> connectionStatusProperty = new SimpleObjectProperty();

    LinuxDevice(@NonNull LanDevice device) {
        this.ipAddress = device.getIp();
        this.update(device);
    }

    void update(@NonNull LanDevice device) {
        InetSocketAddress address;
        assert (device.getIp().equals(this.ipAddress));
        String hostName = device.getHostname();
        String identifier = !hostName.isEmpty() ? String.valueOf(hostName) + " (" + this.ipAddress + ")" : this.ipAddress;
        this.identifierProperty.set((Object)identifier);
        this.daemonProtocolVersionProperty.set((Object)device.getProtocolVersion());
        this.glVendorProperty.set((Object)device.getGlVendor());
        this.glVersionProperty.set((Object)device.getGlVersion());
        this.glRendererProperty.set((Object)device.getGlRenderer());
        if (this.connectionStatusProperty.get() == ConnectionStatus.OPERATION_IN_PROGRESS) {
            return;
        }
        @NonNull ConnectionStatus newStatus = device.isConnected() ? (TargetConnectionManager.getLiveConnectionToAddress(address = new InetSocketAddress(this.ipAddress, 5002)) != null ? ConnectionStatus.CONNECTED : ConnectionStatus.CONNECTED_TO_ANOTHER_MGD) : (AbstractLiveTraceMarshaller.isAcceptedLiveTargetVersion((String)device.getProtocolVersion()) ? ConnectionStatus.DISCONNECTED_AND_CAN_CONNECT : ConnectionStatus.DISCONNECTED_AND_CANT_CONNECT_WRONG_PROTOCOL_VERSION);
        this.connectionStatusProperty.set((Object)newStatus);
    }

    public @NonNull ReadOnlyStringProperty identifierProperty() {
        return this.identifierProperty;
    }

    public @NonNull ReadOnlyStringProperty daemonProtocolVersionProperty() {
        return this.daemonProtocolVersionProperty;
    }

    public @NonNull ReadOnlyStringProperty glVendorProperty() {
        return this.glVendorProperty;
    }

    public @NonNull ReadOnlyStringProperty glRendererProperty() {
        return this.glRendererProperty;
    }

    public @NonNull ReadOnlyStringProperty glVersionProperty() {
        return this.glVersionProperty;
    }

    public @NonNull ReadOnlyObjectProperty<@NonNull ConnectionStatus> connectionStatusProperty() {
        return this.connectionStatusProperty;
    }

    public void connect(@Nullable Consumer<@NonNull LiveTargetConnection> onConnectionSuccessCallback) {
        assert (Platform.isFxApplicationThread());
        if (this.connectionStatusProperty.get() != ConnectionStatus.DISCONNECTED_AND_CAN_CONNECT) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.connectionStatusProperty.set((Object)ConnectionStatus.OPERATION_IN_PROGRESS);
        new Thread(() -> {
            LiveTargetConnection connection = ConnectTargetHandler.doConnectTargetSynchronous(this.ipAddress, 5002, null, null, null, window);
            if (connection != null && onConnectionSuccessCallback != null) {
                onConnectionSuccessCallback.accept(connection);
            }
            @NonNull ConnectionStatus newInfo = connection != null ? ConnectionStatus.CONNECTED : ConnectionStatus.DISCONNECTED_AND_CAN_CONNECT;
            Platform.runLater(() -> this.connectionStatusProperty.set((Object)newInfo));
        }).start();
    }

    public void disconnect() {
        assert (Platform.isFxApplicationThread());
        if (this.connectionStatusProperty.get() != ConnectionStatus.CONNECTED) {
            return;
        }
        InetSocketAddress address = new InetSocketAddress(this.ipAddress, 5002);
        LiveTargetConnection connection = TargetConnectionManager.getLiveConnectionToAddress(address);
        if (connection == null) {
            return;
        }
        this.connectionStatusProperty.set((Object)ConnectionStatus.OPERATION_IN_PROGRESS);
        new Thread(() -> {
            connection.disconnect();
            Platform.runLater(() -> this.connectionStatusProperty.set((Object)ConnectionStatus.DISCONNECTED_AND_CAN_CONNECT));
        }).start();
    }

    public static enum ConnectionStatus {
        DISCONNECTED_AND_CAN_CONNECT,
        DISCONNECTED_AND_CANT_CONNECT_WRONG_PROTOCOL_VERSION,
        CONNECTED,
        CONNECTED_TO_ANOTHER_MGD,
        OPERATION_IN_PROGRESS;

    }
}

