/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.EditorInputManager;
import com.arm.mgd.ui.controllers.commands.IExportable;
import com.arm.mgd.ui.controllers.commands.IOpenable;
import com.arm.mgd.ui.views.widgets.WeakProxyImageProvider;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.StringJoiner;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImagesViewItem
implements IOpenable,
IExportable<VkImageAsset> {
    private @NonNull WeakReference<@Nullable VkImageAsset> imageAsset = NullUtils.emptyWeakReference();
    private final @NonNull ObjectProperty<@Nullable WeakProxyImageProvider> thumbnail = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable IImageProvider> imageProviderProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Handle> imageHandle = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Bitfield> flags = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> imageType = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> format = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Dimension> extent = new SimpleObjectProperty();
    private final @NonNull LongProperty width = new SimpleLongProperty();
    private final @NonNull LongProperty height = new SimpleLongProperty();
    private final @NonNull LongProperty depth = new SimpleLongProperty();
    private final @NonNull LongProperty mipLevels = new SimpleLongProperty();
    private final @NonNull LongProperty arrayLayers = new SimpleLongProperty();
    private final @NonNull ObjectProperty<@Nullable Bitfield> samples = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> tiling = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Bitfield> usage = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> sharingMode = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> initialLayout = new SimpleObjectProperty();
    private final @NonNull StringProperty note = new SimpleStringProperty();

    public ImagesViewItem() {
        this.imageProviderProperty.bind(this.thumbnail);
    }

    public void set(@NonNull VkImageAsset image) {
        @Nullable VkImageAsset oldImageAsset = (VkImageAsset)this.imageAsset.get();
        this.imageAsset = new WeakReference<VkImageAsset>(image);
        this.imageHandle.set((Object)image.getHandle());
        this.flags.set((Object)image.getFlags());
        this.imageType.set((Object)image.getImageType());
        this.format.set((Object)image.getFormat());
        this.width.set(image.getExtent().getWidth().longValue());
        this.height.set(image.getExtent().getHeight().longValue());
        this.depth.set(image.getExtent().getDepth().longValue());
        Dimension extentDimension = new Dimension(this.width.getValue().intValue(), this.height.getValue().intValue(), this.depth.getValue().intValue());
        this.extent.set((Object)extentDimension);
        this.mipLevels.set(image.getMipLevels());
        this.arrayLayers.set(image.getArrayLayers());
        this.samples.set((Object)image.getSamples());
        this.tiling.set((Object)image.getTiling());
        this.usage.set((Object)image.getUsage());
        this.sharingMode.set((Object)image.getSharingMode());
        this.initialLayout.set((Object)image.getInitialLayout());
        WeakProxyImageProvider proxyProvider = (WeakProxyImageProvider)this.thumbnail.get();
        if (proxyProvider == null || ImagesViewItem.hasImageContentChanged(oldImageAsset, image)) {
            this.thumbnail.set((Object)new WeakProxyImageProvider((IImageProvider)image));
        } else {
            proxyProvider.updateImageProvider((IImageProvider)image);
        }
    }

    private static boolean hasImageContentChanged(@Nullable VkImageAsset oldAsset, @NonNull VkImageAsset newAsset) {
        @Nullable FunctionCall oldLastModificationCall = oldAsset != null ? (FunctionCall)NullUtils.nonNullOrDefault((Object)oldAsset.getPreviousModificationFunction(), (Object)oldAsset.getCreatedByFunction()) : null;
        @NonNull FunctionCall newLastModificationCall = (FunctionCall)NullUtils.nonNullOrDefault((Object)newAsset.getPreviousModificationFunction(), (Object)newAsset.getCreatedByFunction());
        return !newLastModificationCall.equals((Object)oldLastModificationCall);
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Handle> imageHandleProperty() {
        return this.imageHandle;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Bitfield> flagsProperty() {
        return this.flags;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Bitfield> samplesProperty() {
        return this.samples;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Dimension> extentProperty() {
        return this.extent;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> imageTypeProperty() {
        return this.imageType;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> formatProperty() {
        return this.format;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> tilingProperty() {
        return this.tiling;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Bitfield> usageProperty() {
        return this.usage;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> sharingModeProperty() {
        return this.sharingMode;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> initialLayoutProperty() {
        return this.initialLayout;
    }

    public @NonNull ReadOnlyLongProperty widthProperty() {
        return this.width;
    }

    public @NonNull ReadOnlyLongProperty heightProperty() {
        return this.height;
    }

    public @NonNull ReadOnlyLongProperty depthProperty() {
        return this.depth;
    }

    public @NonNull ReadOnlyLongProperty mipLevelsProperty() {
        return this.mipLevels;
    }

    public @NonNull ReadOnlyLongProperty arrayLayersProperty() {
        return this.arrayLayers;
    }

    public @NonNull ReadOnlyStringProperty noteProperty() {
        return this.note;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable IImageProvider> imageProviderProperty() {
        return this.imageProviderProperty;
    }

    @Override
    public @Nullable VkImageAsset getAsset() {
        return (VkImageAsset)this.imageAsset.get();
    }

    @Override
    public @NonNull String getClipboardContent() {
        StringJoiner stringJoiner = new StringJoiner(", ");
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.imageHandle.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.flags.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.imageType.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.format.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.extent.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)this.width.getValue(), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)this.height.getValue(), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)this.depth.getValue(), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)this.mipLevels.getValue(), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)this.arrayLayers.getValue(), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.tiling.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.usage.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.sharingMode.getValue()), (Object)"")).toString());
        stringJoiner.add(((Serializable)NullUtils.nonNullOrDefault((Object)((Serializable)this.initialLayout.getValue()), (Object)"")).toString());
        stringJoiner.add(((String)NullUtils.nonNullOrDefault((Object)this.note.getValue(), (Object)"")).toString());
        return (String)NullUtils.neverNull((Object)stringJoiner.toString());
    }

    @Override
    public boolean isAvailable() {
        return this.thumbnail.get() != null;
    }

    @Override
    public void open() {
        VkImageAsset asset = this.getAsset();
        if (asset != null) {
            EditorInputManager.openEditor(asset);
        }
    }
}

