/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.help.ApiDocProvider;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.ui.utils.ArgumentHierarchyHTMLPrinter;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.AbstractMap;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;

public class FunctionCallInformationViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyStringWrapper argumentsHTML = new ReadOnlyStringWrapper();
    private final @NonNull ReadOnlyStringWrapper documentationURL = new ReadOnlyStringWrapper();
    private final @NonNull ObservableList<AbstractMap.SimpleImmutableEntry<String, String>> additionalInformationItems = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ReadOnlyBooleanWrapper noFunctionSelected = new ReadOnlyBooleanWrapper();
    private final @NonNull ArgumentHierarchyHTMLPrinter argumentHierarchyHTMLPrinter = new ArgumentHierarchyHTMLPrinter();

    public FunctionCallInformationViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
    }

    public ReadOnlyStringProperty argumentsHTMLProperty() {
        return this.argumentsHTML.getReadOnlyProperty();
    }

    public ReadOnlyStringProperty documentationURLProperty() {
        return this.documentationURL.getReadOnlyProperty();
    }

    public @NonNull ObservableList<AbstractMap.SimpleImmutableEntry<String, String>> getAdditionalInformationItems() {
        return this.additionalInformationItems;
    }

    public ReadOnlyBooleanProperty noFunctionCallSelectedProperty() {
        return this.noFunctionSelected.getReadOnlyProperty();
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> {
            this.noFunctionSelected.set(true);
            this.argumentsHTML.set(null);
            this.documentationURL.set(null);
            this.additionalInformationItems.clear();
        });
        navigationUriChangeEvent.getNewResolvedFunctionCall(fc -> {
            if (fc != null) {
                String contentValue;
                this.argumentHierarchyHTMLPrinter.reset();
                fc.getArgumentHierarchy().accept((ArgumentHierarchyNode.IArgumentHierarchyVisitor)this.argumentHierarchyHTMLPrinter);
                String functionCallHTML = this.argumentHierarchyHTMLPrinter.getHTML();
                ArgumentHierarchyNode returnHierachy = fc.getReturnHierachy();
                if (returnHierachy != null) {
                    this.argumentHierarchyHTMLPrinter.reset();
                    returnHierachy.accept((ArgumentHierarchyNode.IArgumentHierarchyVisitor)this.argumentHierarchyHTMLPrinter);
                    contentValue = String.valueOf(this.argumentHierarchyHTMLPrinter.getHTML()) + "\n" + functionCallHTML;
                } else {
                    contentValue = functionCallHTML;
                }
                Platform.runLater(() -> {
                    this.noFunctionSelected.set(false);
                    this.argumentsHTML.set(contentValue);
                    this.documentationURL.set(ApiDocProvider.getApiDocLocation((Object)fc.getFunctionSpec()).toExternalForm());
                    if (fc instanceof InterestingFunctionCall) {
                        InterestingFunctionCall call = (InterestingFunctionCall)fc;
                        this.additionalInformationItems.addAll((Collection)call.getInterestingCallData().getInformation());
                    }
                });
            }
            return null;
        });
    }
}

