/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.OverridesChangedListener;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.FrameOverridesViewListItem;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameOverridesViewController
implements ICommandDispatcher<FrameOverridesViewListItem> {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull BooleanProperty addButtonDisabled = new SimpleBooleanProperty(true);
    private final @NonNull BooleanProperty removeButtonDisabled = new SimpleBooleanProperty(true);
    private final @NonNull SimpleObjectProperty<@Nullable Frame> currentFrame = new SimpleObjectProperty();
    private final @NonNull SimpleObjectProperty<@Nullable TraceDataModel> currentModel = new SimpleObjectProperty();
    private final @NonNull ObservableList<FrameOverridesViewListItem> frameOverridesList = FXCollections.observableArrayList();
    private final @NonNull List<Integer> selectedIndices = new ArrayList<Integer>();
    private final @NonNull OverridesChangedListener overridesChangedListener = new OverridesChangedListener(){

        public void onOverridesChanged() {
            Platform.runLater(() -> FrameOverridesViewController.this.refreshListItems());
        }
    };

    public FrameOverridesViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.currentFrame.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.getFrameOverrides().removeOverridesChangedListener(this.overridesChangedListener);
            }
            if (newValue != null) {
                newValue.getFrameOverrides().addOverridesChangedListener(this.overridesChangedListener);
            }
            this.currentModel.set((Object)(newValue != null ? newValue.getParentModel() : null));
        });
        this.currentModel.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != null) {
                oldValue.getCurrentActiveOverrides().removeOverridesChangedListener(this.overridesChangedListener);
            }
            if (newValue != null) {
                newValue.getCurrentActiveOverrides().addOverridesChangedListener(this.overridesChangedListener);
            }
        });
        this.currentFrame.addListener((observable, oldValue, newValue) -> this.refreshListItems());
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        assert (Platform.isFxApplicationThread());
        this.navigationChangedListener.dispose();
        Platform.runLater(() -> this.currentFrame.set(null));
    }

    public @NonNull ReadOnlyBooleanProperty addButtonDisabledProperty() {
        return this.addButtonDisabled;
    }

    public void bindItems(@NonNull List<FrameOverridesViewListItem> viewItems) {
        Bindings.bindContent(viewItems, this.frameOverridesList);
    }

    public void bindSelectedIndices(@NonNull ObservableList<Integer> sourceList) {
        Bindings.bindContent(this.selectedIndices, sourceList);
        sourceList.addListener((ListChangeListener)new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> c) {
                FrameOverridesViewController.this.removeButtonDisabled.set(!FrameOverridesViewController.this.canDispatchCommand((ICommand<? super FrameOverridesViewListItem>)Commands.REMOVE_OVERRIDE_COMMAND));
            }
        });
    }

    @Override
    public boolean canDispatchCommand(@NonNull ICommand<? super FrameOverridesViewListItem> command) {
        assert (Platform.isFxApplicationThread());
        return command.isEnabled((TraceDataModel)this.currentModel.get(), Commands.makeSelectionList(this.selectedIndices, this.frameOverridesList));
    }

    @Override
    public void dispatchCommand(@NonNull ICommand<? super FrameOverridesViewListItem> command) {
        assert (Platform.isFxApplicationThread());
        command.execute((TraceDataModel)this.currentModel.get(), Commands.makeSelectionList(this.selectedIndices, this.frameOverridesList));
    }

    public void onAddNewOverrideClicked() {
        this.dispatchCommand((ICommand<? super FrameOverridesViewListItem>)Commands.ADD_OVERRIDE_COMMAND);
    }

    public void onRemoveSelectedOverridesClicked() {
        this.dispatchCommand((ICommand<? super FrameOverridesViewListItem>)Commands.REMOVE_OVERRIDE_COMMAND);
    }

    public @NonNull ReadOnlyBooleanProperty removeButtonDisabledProperty() {
        return this.removeButtonDisabled;
    }

    private static @NonNull List<@NonNull FrameOverridesViewListItem> getAllFrameOverrides(@NonNull Frame frame) {
        HashMap<@NonNull AbstractFrameOverride, @NonNull FrameOverridesViewListItem> map = new HashMap<AbstractFrameOverride, FrameOverridesViewListItem>();
        for (AbstractFrameOverride override : frame.getParentModel().getCurrentActiveOverrides()) {
            map.put(override, new FrameOverridesViewListItem(override, false, false));
        }
        Iterator iterator = frame.getFrameOverrides().iterator();
        while (iterator.hasNext()) {
            AbstractFrameOverride override;
            map.put(override, new FrameOverridesViewListItem(override, true, !map.containsKey(override = (AbstractFrameOverride)iterator.next())));
        }
        ArrayList<@NonNull FrameOverridesViewListItem> result = new ArrayList<FrameOverridesViewListItem>(map.values());
        Collections.sort(result);
        return result;
    }

    private void refreshListItems() {
        assert (Platform.isFxApplicationThread());
        Frame frame = (Frame)this.currentFrame.get();
        if (frame == null) {
            this.addButtonDisabled.set(true);
            this.frameOverridesList.clear();
        } else {
            this.addButtonDisabled.set(!this.canDispatchCommand((ICommand<? super FrameOverridesViewListItem>)Commands.ADD_OVERRIDE_COMMAND));
            this.frameOverridesList.clear();
            this.frameOverridesList.addAll(FrameOverridesViewController.getAllFrameOverrides(frame));
        }
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> this.currentFrame.set((Object)((Frame)navigationUriChangeEvent.getNewResolvedFunctionCall(fc -> fc != null ? fc.getParentFrame() : null))));
    }
}

