/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.VkRenderPassInstance;
import com.arm.mgd.core.asset.VkSubpass;
import com.arm.mgd.core.asset.objects.IVkAttachmentDescription;
import com.arm.mgd.core.asset.objects.IVkSubpassDescription;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.VulkanCommandIndex;
import com.arm.mgd.core.target.data.VulkanFramebufferAttachment;
import com.arm.mgd.core.target.data.VulkanImageCompositor;
import com.arm.mgd.core.target.data.VulkanImageDiffAttachment;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.image.IntegerTextureConverter;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.utils.JavaFXImageLoader;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.image.Image;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameCaptureViewData {

    public static class AttachmentImageData {
        private final @NonNull DrawCallData drawCallData;
        private final @NonNull AttachmentInfo attachmentInfo;
        private final @NonNull SimpleObjectProperty<@Nullable VulkanFramebufferAttachment> framebufferAttachment = new SimpleObjectProperty();

        public AttachmentImageData(@NonNull DrawCallData drawCallData, @NonNull AttachmentInfo attachmentInfo) {
            this.drawCallData = drawCallData;
            this.attachmentInfo = attachmentInfo;
        }

        public @NonNull AttachmentInfo getAttachmentInfo() {
            return this.attachmentInfo;
        }

        public @NonNull ReadOnlyObjectProperty<@Nullable VulkanFramebufferAttachment> framebufferAttachmentProperty() {
            return this.framebufferAttachment;
        }

        void setFramebufferAttachment(@NonNull VulkanFramebufferAttachment attachment) {
            this.framebufferAttachment.set((Object)attachment);
            this.drawCallData.hasImageData.set(true);
            this.drawCallData.subPassData.hasImageData.set(true);
            this.drawCallData.subPassData.renderPassData.hasImageData.set(true);
            this.drawCallData.subPassData.renderPassData.commandBufferData.hasImageData.set(true);
            this.drawCallData.subPassData.renderPassData.commandBufferData.submitInfoData.hasImageData.set(true);
        }
    }

    public static class AttachmentIndices {
        private final int submitInfoIndex;
        private final int attachmentIndex;
        private final @NonNull VulkanCommandIndex commandIndex;

        public AttachmentIndices(int submitInfoIndex, int attachmentIndex, @NonNull VulkanCommandIndex commandIndex) {
            this.submitInfoIndex = submitInfoIndex;
            this.attachmentIndex = attachmentIndex;
            this.commandIndex = commandIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttachmentIndices)) {
                return false;
            }
            AttachmentIndices other = (AttachmentIndices)obj;
            return this.submitInfoIndex == other.submitInfoIndex && this.attachmentIndex == other.attachmentIndex && Objects.equals(this.commandIndex, other.commandIndex);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.submitInfoIndex;
            result = 31 * result + this.attachmentIndex;
            result = 31 * result + this.commandIndex.hashCode();
            return result;
        }
    }

    public static class AttachmentInfo {
        public final int attachmentIndex;
        public final IVkAttachmentDescription attachmentDescription;
        public final Dimension dimensions;
        public final @NonNull AbstractConstantOrAliasSpecExtended imageFormat;
        public final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable IntegerTextureConverter.ImageConversionSpec conversionSpec;
        public final boolean isMultisampled;

        public AttachmentInfo(int attachmentIndex, @NonNull IVkAttachmentDescription attachmentDescription, @NonNull Dimension dimensions, @NonNull VkImageAsset imageAsset) {
            this.attachmentIndex = attachmentIndex;
            this.attachmentDescription = attachmentDescription;
            this.dimensions = dimensions;
            this.imageFormat = imageAsset.getFormat();
            this.conversionSpec = IntegerTextureConverter.getVulkanImageConversionSpec((AbstractConstantOrAliasSpecExtended)this.imageFormat);
            this.isMultisampled = !imageAsset.getSamples().contains((Object)KapiSpec.VULKAN.constants.VK_SAMPLE_COUNT_1_BIT);
        }
    }

    public static class CommandBufferData
    extends VulkanFrameCaptureTreeItemData {
        private final @NonNull SubmitInfoData submitInfoData;
        private final int commandBufferIndex;
        private final @NonNull WeakReference<VkCommandBufferAsset> commandBufferAsset;

        public CommandBufferData(@NonNull SubmitInfoData submitInfoData, int commandBufferIndex, @NonNull VkCommandBufferAsset commandBufferAsset) {
            this.submitInfoData = submitInfoData;
            this.commandBufferIndex = commandBufferIndex;
            this.commandBufferAsset = new WeakReference<VkCommandBufferAsset>(commandBufferAsset);
        }

        @Override
        public @NonNull String getName() {
            return (String)NullUtils.neverNull((Object)("Command Buffer " + this.commandBufferIndex));
        }

        @Override
        public @Nullable ArgumentHierarchyNode getArgumentHierarchy() {
            VkCommandBufferAsset commandBuffer = (VkCommandBufferAsset)this.commandBufferAsset.get();
            if (commandBuffer == null) {
                return null;
            }
            ArrayList<@NonNull ArgumentHierarchyLeaf> membersList = new ArrayList<ArgumentHierarchyLeaf>();
            membersList.add(new ArgumentHierarchyLeaf("commandBuffer", commandBuffer.getHandle().toString(), ArgumentHierarchyLeaf.LeafType.POINTER));
            membersList.add(new ArgumentHierarchyLeaf("commandCount", NullUtils.stringValueOf((long)commandBuffer.getCommands().size()), ArgumentHierarchyLeaf.LeafType.INTEGER));
            membersList.add(new ArgumentHierarchyLeaf("renderPassCount", NullUtils.stringValueOf((long)commandBuffer.getRenderPassInstances().size()), ArgumentHierarchyLeaf.LeafType.INTEGER));
            return ArgumentHierarchyBranch.structHierarchy((String)this.getName(), membersList);
        }

        public @NonNull SubmitInfoData getSubmitInfo() {
            return this.submitInfoData;
        }
    }

    public static class DrawCallData
    extends VulkanFrameCaptureTreeItemData {
        private final @NonNull SubpassData subPassData;
        private final @NonNull String drawCallLabel;
        private final @NonNull List<@NonNull AttachmentImageData> attachmentImageData;

        public DrawCallData(@NonNull SubpassData subPassData, @NonNull String drawCallLabel) {
            this.subPassData = subPassData;
            this.drawCallLabel = drawCallLabel;
            @NonNull ArrayList<@NonNull E> data = new ArrayList();
            subPassData.attachments.forEach(attachment -> {
                boolean bl = data.add(new AttachmentImageData(this, (AttachmentInfo)attachment));
            });
            this.attachmentImageData = NullUtils.unmodifiableList(data);
        }

        @Override
        public @NonNull String getName() {
            return this.drawCallLabel;
        }

        @Override
        public @Nullable ArgumentHierarchyNode getArgumentHierarchy() {
            return null;
        }

        public @NonNull SubpassData getSubPass() {
            return this.subPassData;
        }

        public @NonNull List<@NonNull AttachmentImageData> getAttachmentImageData() {
            return this.attachmentImageData;
        }
    }

    public static class FrameCaptureViewAttachmentImage {
        private final @NonNull AttachmentImageData attachmentImageData;
        private final @NonNull ReadOnlyObjectProperty<RGBAImage.AlphaMode> alphaModeProperty;
        private final @NonNull ChangeListener<RGBAImage.AlphaMode> alphaModeListener;
        private final @NonNull ObjectProperty<VulkanFramebufferAttachment> attachment = new SimpleObjectProperty();
        private final @NonNull ObjectProperty<FrameCaptureImageLoader> imageLoader = new SimpleObjectProperty();
        private final @NonNull ObjectProperty<Image> imageProperty = new SimpleObjectProperty();
        private final @NonNull StringProperty imageLoadError = new SimpleStringProperty();
        private final @NonNull ExecutorService executor;

        public FrameCaptureViewAttachmentImage(@NonNull ExecutorService executor, @NonNull VulkanImageCompositor compositor, @NonNull AttachmentImageData attachmentImageData, @NonNull ReadOnlyObjectProperty<RGBAImage.AlphaMode> alphaModeProperty) {
            assert (Platform.isFxApplicationThread());
            this.attachmentImageData = attachmentImageData;
            this.alphaModeProperty = alphaModeProperty;
            this.executor = executor;
            this.attachment.addListener((observable, oldValue, newValue) -> {
                FrameCaptureImageLoader newLoader = null;
                if (newValue != null) {
                    newLoader = new FrameCaptureImageLoader(new FrameCaptureImageProvider(attachmentImageData.getAttachmentInfo(), (VulkanFramebufferAttachment)newValue, compositor));
                }
                this.imageLoader.set(newLoader);
            });
            this.imageLoader.addListener((observable, oldValue, newValue) -> {
                if (oldValue != null) {
                    oldValue.isCancelled.set(true);
                }
                this.updateImage();
            });
            this.alphaModeListener = (observable, oldValue, newValue) -> this.updateImage();
            alphaModeProperty.addListener(this.alphaModeListener);
            this.attachment.bind(attachmentImageData.framebufferAttachmentProperty());
        }

        private void updateImage() {
            assert (Platform.isFxApplicationThread());
            this.imageProperty.set(null);
            this.imageLoadError.set(null);
            FrameCaptureImageLoader loader = (FrameCaptureImageLoader)this.imageLoader.get();
            RGBAImage.AlphaMode alphaMode = (RGBAImage.AlphaMode)((Object)this.alphaModeProperty.get());
            if (loader != null && alphaMode != null) {
                this.executor.execute(() -> {
                    if (frameCaptureImageLoader.isCancelled.get()) {
                        return;
                    }
                    Image image = null;
                    String loadError = null;
                    try {
                        image = frameCaptureImageLoader.getImage((RGBAImage.AlphaMode)alphaMode).image;
                    }
                    catch (Throwable t) {
                        loadError = t.getMessage();
                    }
                    Image finalImage = image;
                    String finalLoadError = loadError;
                    Platform.runLater(() -> {
                        RGBAImage.AlphaMode newAlphaMode = (RGBAImage.AlphaMode)((Object)((Object)((Object)this.alphaModeProperty.get())));
                        if (!frameCaptureImageLoader.isCancelled.get() && newAlphaMode == alphaMode) {
                            this.imageProperty.set((Object)finalImage);
                            this.imageLoadError.set((Object)finalLoadError);
                        }
                    });
                });
            }
        }

        public @NonNull AttachmentImageData getData() {
            return this.attachmentImageData;
        }

        public @NonNull ReadOnlyObjectProperty<Image> imageProperty() {
            assert (Platform.isFxApplicationThread());
            return this.imageProperty;
        }

        public @NonNull StringProperty imageLoadErrorProperty() {
            assert (Platform.isFxApplicationThread());
            return this.imageLoadError;
        }

        public boolean isImageLoading() {
            assert (Platform.isFxApplicationThread());
            return this.imageLoader.get() != null;
        }

        public void dispose() {
            assert (Platform.isFxApplicationThread());
            this.alphaModeProperty.removeListener(this.alphaModeListener);
            this.attachment.unbind();
            this.attachment.set(null);
        }

        private static class FrameCaptureImageLoader
        extends JavaFXImageLoader {
            private final @NonNull AtomicBoolean isCancelled = new AtomicBoolean();

            private FrameCaptureImageLoader(@NonNull FrameCaptureImageProvider provider) {
                super(provider);
            }
        }

        private static class FrameCaptureImageProvider
        implements IImageProvider {
            private final @NonNull AttachmentInfo info;
            private final @NonNull VulkanFramebufferAttachment framebufferAttachment;
            private final @NonNull VulkanImageCompositor compositor;

            private FrameCaptureImageProvider(@NonNull AttachmentInfo info, @NonNull VulkanFramebufferAttachment framebufferAttachment, @NonNull VulkanImageCompositor compositor) {
                this.info = info;
                this.framebufferAttachment = framebufferAttachment;
                this.compositor = compositor;
            }

            public RGBAImageData getImageData() throws IImageProvider.ImageDataUnavailableException, IOException, IImageProvider.ImageConversionException {
                assert (!Platform.isFxApplicationThread());
                VulkanImageDiffAttachment imageDiff = this.framebufferAttachment.getImageDiff();
                int format = imageDiff.getFormat();
                AbstractConstantOrAliasSpecExtended receivedAttachmentFormat = KapiSpec.VULKAN.constantGroups.VKFORMAT.getConstantSpecByValue(NullUtils.longValueOf((long)format));
                if (!this.info.imageFormat.equals(receivedAttachmentFormat)) {
                    throw new IImageProvider.ImageConversionException("Expected image data of format " + this.info.imageFormat + " but received data of format " + receivedAttachmentFormat);
                }
                Dimension dims = this.info.dimensions;
                int width = imageDiff.getWidth();
                int height = imageDiff.getHeight();
                int layers = imageDiff.getLayers();
                if (dims.getWidth() != width || dims.getHeight() != height || dims.getDepth() != layers) {
                    throw new IImageProvider.ImageConversionException("Expected image data with dimensions " + dims + " but received data with dimensions " + new Dimension(imageDiff.getWidth(), imageDiff.getHeight(), imageDiff.getLayers()));
                }
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable IntegerTextureConverter.ImageConversionSpec conversionSpec = this.info.conversionSpec;
                if (conversionSpec == null) {
                    throw new IImageProvider.ImageConversionException("Image data of format " + this.info.imageFormat + " is not supported");
                }
                if (this.info.isMultisampled) {
                    throw new IImageProvider.ImageConversionException("Multisampled images are not supported");
                }
                IByteDataProvider data = this.compositor.getCompositedData(imageDiff);
                Dimension dimension = new Dimension(width, height * layers);
                IntegerTextureConverter.Result texture = IntegerTextureConverter.convertTextureData((ByteBuffer)data.getData(), (Dimension)dimension, (IntegerTextureConverter.ImageConversionSpec)conversionSpec, (IntegerTextureConverter.AlphaChannel)IntegerTextureConverter.AlphaChannel.INLINE_ALPHA);
                IByteDataProvider provider = IByteDataProvider.createMemoryProvider((byte[])texture.getData());
                return new RGBAImageData(dimension, provider, RGBAImageData.CoordinateOrigin.BOTTOM_LEFT);
            }
        }
    }

    public static class RenderPassData
    extends VulkanFrameCaptureTreeItemData {
        private final @NonNull CommandBufferData commandBufferData;
        private final int renderPassIndex;
        private final @NonNull WeakReference<VkRenderPassInstance> renderPassInstance;
        private final @NonNull List<@NonNull AttachmentInfo> attachments;

        public RenderPassData(@NonNull CommandBufferData commandBufferData, int renderPassIndex, @NonNull VkRenderPassInstance renderPassInstance, @NonNull List<@NonNull AttachmentInfo> attachments) {
            this.commandBufferData = commandBufferData;
            this.renderPassIndex = renderPassIndex;
            this.renderPassInstance = new WeakReference<VkRenderPassInstance>(renderPassInstance);
            this.attachments = attachments;
        }

        @Override
        public @NonNull String getName() {
            return (String)NullUtils.neverNull((Object)("Render Pass " + this.renderPassIndex));
        }

        @Override
        public @Nullable ArgumentHierarchyNode getArgumentHierarchy() {
            FunctionCall vkCreateRenderPass;
            VULKAN.Structs.VkRenderPassCreateInfo renderPassCreateInfo;
            VkRenderPassInstance renderPass = (VkRenderPassInstance)this.renderPassInstance.get();
            if (renderPass == null) {
                return null;
            }
            ArrayList<@NonNull Object> membersList = new ArrayList<Object>();
            membersList.add(new ArgumentHierarchyLeaf("renderPass", renderPass.getParentRenderPass().getHandle().toString(), ArgumentHierarchyLeaf.LeafType.POINTER));
            membersList.add(new ArgumentHierarchyLeaf("framebuffer", renderPass.getFramebuffer().getHandle().toString(), ArgumentHierarchyLeaf.LeafType.POINTER));
            FunctionCall vkCreateFramebuffer = renderPass.getFramebuffer().getCreatedByFunction();
            VULKAN.Structs.VkFramebufferCreateInfo framebufferCreateInfo = VULKAN.VkCreateFramebufferDecorator.getArgumentPCreateInfo((FunctionCall)vkCreateFramebuffer);
            if (framebufferCreateInfo.getContainer() != null) {
                membersList.add(new ArgumentHierarchyLeaf("width", (String)NullUtils.neverNull((Object)framebufferCreateInfo.getWidth().toString()), ArgumentHierarchyLeaf.LeafType.INTEGER));
                membersList.add(new ArgumentHierarchyLeaf("height", (String)NullUtils.neverNull((Object)framebufferCreateInfo.getHeight().toString()), ArgumentHierarchyLeaf.LeafType.INTEGER));
                membersList.add(new ArgumentHierarchyLeaf("layers", (String)NullUtils.neverNull((Object)framebufferCreateInfo.getLayers().toString()), ArgumentHierarchyLeaf.LeafType.INTEGER));
            }
            if ((renderPassCreateInfo = VULKAN.VkCreateRenderPassDecorator.getArgumentPCreateInfo((FunctionCall)(vkCreateRenderPass = renderPass.getParentRenderPass().getCreatedByFunction()))).getContainer() != null) {
                membersList.add(new ArgumentHierarchyLeaf("attachmentCount", (String)NullUtils.neverNull((Object)renderPassCreateInfo.getAttachmentCount().toString()), ArgumentHierarchyLeaf.LeafType.INTEGER));
                ArrayList<@NonNull E> attachmentsList = new ArrayList(renderPassCreateInfo.getAttachmentCount().intValue());
                renderPassCreateInfo.getPAttachments().forEach(attachment -> attachmentsList.add(attachment.getContainer().getArgumentHierarchy()));
                membersList.add(ArgumentHierarchyBranch.arrayHierarchy((String)"pAttachments", attachmentsList));
            }
            return ArgumentHierarchyBranch.structHierarchy((String)this.getName(), membersList);
        }

        public @NonNull CommandBufferData getCommandBuffer() {
            return this.commandBufferData;
        }

        public @NonNull List<@NonNull AttachmentInfo> getAttachments() {
            return this.attachments;
        }
    }

    public static class SubmitInfoData
    extends VulkanFrameCaptureTreeItemData {
        private final int submitInfoIndex;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull VULKAN.Structs.VkSubmitInfo submitInfo;

        public SubmitInfoData(int submitInfoIndex, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull VULKAN.Structs.VkSubmitInfo submitInfo) {
            this.submitInfoIndex = submitInfoIndex;
            this.submitInfo = submitInfo;
        }

        @Override
        public @NonNull String getName() {
            return (String)NullUtils.neverNull((Object)("Submit Info " + this.submitInfoIndex));
        }

        @Override
        public @Nullable ArgumentHierarchyNode getArgumentHierarchy() {
            if (this.submitInfo.getContainer().isNull()) {
                return ArgumentHierarchyLeaf.nullPointer((String)this.getName());
            }
            List args = this.submitInfo.getContainer().getArguments();
            ArrayList<@NonNull ArgumentHierarchyNode> membersList = new ArrayList<ArgumentHierarchyNode>(args.size());
            for (IArgument arg : args) {
                membersList.add(arg.getArgumentHierarchy());
            }
            return ArgumentHierarchyBranch.structHierarchy((String)this.getName(), membersList);
        }
    }

    public static class SubpassData
    extends VulkanFrameCaptureTreeItemData {
        private final @NonNull RenderPassData renderPassData;
        private final int subpassIndex;
        private final @NonNull List<@NonNull AttachmentInfo> attachments;
        private final int numDrawCalls;

        public SubpassData(@NonNull RenderPassData renderPassData, int subpassIndex, @NonNull List<@NonNull AttachmentInfo> attachments, int numDrawCalls) {
            this.renderPassData = renderPassData;
            this.subpassIndex = subpassIndex;
            this.attachments = attachments;
            this.numDrawCalls = numDrawCalls;
        }

        @Override
        public @NonNull String getName() {
            return (String)NullUtils.neverNull((Object)("Subpass " + this.subpassIndex));
        }

        public @NonNull RenderPassData getRenderPass() {
            return this.renderPassData;
        }

        @Override
        public @Nullable ArgumentHierarchyNode getArgumentHierarchy() {
            VkSubpass subpass;
            VkRenderPassInstance renderPass = (VkRenderPassInstance)this.renderPassData.renderPassInstance.get();
            if (renderPass == null) {
                return null;
            }
            ArrayList<@NonNull Object> membersList = new ArrayList<Object>();
            VkSubpass vkSubpass = subpass = this.subpassIndex >= renderPass.getSubpasses().size() ? null : (VkSubpass)renderPass.getSubpasses().get(this.subpassIndex);
            if (subpass != null) {
                membersList.add(new ArgumentHierarchyLeaf("contents", (String)NullUtils.neverNull((Object)subpass.getSubpassContents().toString()), ArgumentHierarchyLeaf.LeafType.ENUM));
            }
            membersList.add(new ArgumentHierarchyLeaf("drawCallCount", NullUtils.stringValueOf((long)this.numDrawCalls), ArgumentHierarchyLeaf.LeafType.INTEGER));
            IVkSubpassDescription description = (IVkSubpassDescription)renderPass.getParentRenderPass().getSubpasses().get(this.subpassIndex);
            if (!description.getContainer().isNull()) {
                for (IArgument arg : description.getContainer().getArguments()) {
                    membersList.add(arg.getArgumentHierarchy());
                }
            }
            return ArgumentHierarchyBranch.structHierarchy((String)this.getName(), membersList);
        }

        public @NonNull List<@NonNull AttachmentInfo> getAttachments() {
            return this.attachments;
        }

        public int getNumDrawCalls() {
            return this.numDrawCalls;
        }
    }

    public static abstract class VulkanFrameCaptureTreeItemData {
        protected final @NonNull BooleanProperty hasImageData = new SimpleBooleanProperty();

        public abstract @NonNull String getName();

        public abstract @Nullable ArgumentHierarchyNode getArgumentHierarchy();

        public @NonNull ReadOnlyBooleanProperty hasImageDataProperty() {
            return this.hasImageData;
        }
    }
}

