/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.VkCommand;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkFramebufferAsset;
import com.arm.mgd.core.asset.VkImageViewAsset;
import com.arm.mgd.core.asset.VkRenderPassInstance;
import com.arm.mgd.core.asset.VkSubpassContentsSecondaryCommandBuffers;
import com.arm.mgd.core.asset.VkSubpassInline;
import com.arm.mgd.core.asset.objects.IVkAttachmentDescription;
import com.arm.mgd.core.asset.objects.IVkAttachmentReference;
import com.arm.mgd.core.asset.objects.IVkSubpassDescription;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.AsynchronousFunctionAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IAsynchronousDataListener;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.VulkanCommandIndex;
import com.arm.mgd.core.target.data.VulkanFramebufferAttachment;
import com.arm.mgd.core.target.data.VulkanSubmitAttachment;
import com.arm.mgd.core.target.data.VulkanSubmitData;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.ui.controllers.FrameCaptureViewData;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TreeItem;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameCaptureViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull NamedSingleThreadExecutor executor = new NamedSingleThreadExecutor("FrameCaptureViewController Tree Loader", true);
    private final @NonNull ObjectProperty<@Nullable FrameCaptureViewRoot> root = new SimpleObjectProperty();

    public FrameCaptureViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.root.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.dispose();
            }
        });
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, this::onNavigationChanged);
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        this.root.set(null);
        this.executor.shutdown();
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable FrameCaptureViewRoot> rootProperty() {
        return this.root;
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> this.executor.runLater(() -> {
            @Nullable FrameCaptureViewRoot newRoot = FrameCaptureViewController.createTree(snapshot);
            Platform.runLater(() -> this.root.set((Object)newRoot));
        }));
    }

    private static @Nullable FrameCaptureViewRoot createTree(@Nullable TraceStateSnapshot snapshot) {
        assert (!Platform.isFxApplicationThread());
        if (snapshot == null) {
            return null;
        }
        FunctionCall fc = snapshot.getCurrentFunctionCall();
        IFunctionOrAliasSpecExtended spec = fc.getFunctionSpec();
        if (!KapiSpec.VULKAN.functions.VKQUEUESUBMIT.equals(spec)) {
            return null;
        }
        return new FrameCaptureViewRoot(snapshot, fc, fc.getAsynchronousFunctionCallUid());
    }

    private static @NonNull List<@NonNull VulkanDrawCallCommandIndex> findDrawCallsInSubpassInline(VkSubpassInline subpass, VkCommandBufferAsset primaryCommandBufferAsset, int commandBuffersIndex) {
        ArrayList<@NonNull VulkanDrawCallCommandIndex> retList = new ArrayList<VulkanDrawCallCommandIndex>();
        List commands = primaryCommandBufferAsset.getCommands();
        for (VkCommand command : subpass.getCommands()) {
            if (!command.isDrawCommand()) continue;
            int indexWithinPrimaryCommandBuffer = commands.indexOf(command);
            VulkanCommandIndex vulkanCommandIndex = new VulkanCommandIndex(commandBuffersIndex, indexWithinPrimaryCommandBuffer, null);
            retList.add(new VulkanDrawCallCommandIndex(command.getFunction(), vulkanCommandIndex));
        }
        return retList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull List<@NonNull VulkanDrawCallCommandIndex> findDrawCallsInSubpassContentsSecondaryCommandBuffers(VkSubpassContentsSecondaryCommandBuffers subpass, VkCommandBufferAsset primaryCommandBufferAsset, int commandBuffersIndexInVkQueueSubmit) {
        ArrayList<@NonNull VulkanDrawCallCommandIndex> retList = new ArrayList<VulkanDrawCallCommandIndex>();
        List primaryCommandBufferCommands = primaryCommandBufferAsset.getCommands();
        for (VkSubpassContentsSecondaryCommandBuffers.ExecuteCommandsInfo secondaryCommandBufferExecuteInfo : subpass.getExecuteCommands()) {
            @NonNull List secondaryCommandBuffers = secondaryCommandBufferExecuteInfo.secondaryCommandBuffers;
            int commandBuffersIndexInExecuteCommand = 0;
            while (commandBuffersIndexInExecuteCommand < secondaryCommandBuffers.size()) {
                VkCommandBufferAsset secondaryCommandBufferAsset = (VkCommandBufferAsset)secondaryCommandBuffers.get(commandBuffersIndexInExecuteCommand);
                List secondaryCommandBufferCommands = secondaryCommandBufferAsset.getCommands();
                int commandIndexInSecondaryCommandBuffer = 0;
                while (commandIndexInSecondaryCommandBuffer < secondaryCommandBufferCommands.size()) {
                    VkCommand commandInSecondaryCommandBuffer = (VkCommand)secondaryCommandBufferCommands.get(commandIndexInSecondaryCommandBuffer);
                    if (commandInSecondaryCommandBuffer.isDrawCommand()) {
                        VulkanCommandIndex secondLevelVulkanCommandIndex = new VulkanCommandIndex(commandBuffersIndexInExecuteCommand, commandIndexInSecondaryCommandBuffer, null);
                        int executeCommandIndexInPrimaryCommandBuffer = primaryCommandBufferCommands.indexOf(secondaryCommandBufferExecuteInfo.vkCmdExecuteCommands);
                        VulkanCommandIndex vulkanCommandIndex = new VulkanCommandIndex(commandBuffersIndexInVkQueueSubmit, executeCommandIndexInPrimaryCommandBuffer, secondLevelVulkanCommandIndex);
                        retList.add(new VulkanDrawCallCommandIndex(commandInSecondaryCommandBuffer.getFunction(), vulkanCommandIndex));
                    }
                    ++commandIndexInSecondaryCommandBuffer;
                }
                ++commandBuffersIndexInExecuteCommand;
            }
        }
        return retList;
    }

    private static @NonNull List< @NonNull FrameCaptureViewData.AttachmentInfo> getRenderPassAttachments(@NonNull VkRenderPassInstance renderPassInstance) {
        List attachmentDescriptions = renderPassInstance.getParentRenderPass().getAttachments();
        VkFramebufferAsset framebuffer = renderPassInstance.getFramebuffer();
        List attachments = framebuffer.getAttachments();
        if (attachmentDescriptions.size() != attachments.size()) {
            return NullUtils.EMPTY_LIST;
        }
        ArrayList< @NonNull FrameCaptureViewData.AttachmentInfo> attachmentInfo = new ArrayList<FrameCaptureViewData.AttachmentInfo>();
        Dimension dimensions = new Dimension((int)framebuffer.getWidth(), (int)framebuffer.getHeight(), (int)framebuffer.getLayers());
        int i = 0;
        while (i < attachmentDescriptions.size()) {
            attachmentInfo.add(new FrameCaptureViewData.AttachmentInfo(i, (IVkAttachmentDescription)NullUtils.neverNull((Object)((IVkAttachmentDescription)attachmentDescriptions.get(i))), dimensions, ((VkImageViewAsset)attachments.get(i)).getImage()));
            ++i;
        }
        return NullUtils.unmodifiableList(attachmentInfo);
    }

    private static @NonNull List< @NonNull FrameCaptureViewData.AttachmentInfo> getAttachmentsWrittenBySubpass(@NonNull List< @NonNull FrameCaptureViewData.AttachmentInfo> attachments, @NonNull IVkSubpassDescription subpassDescription) {
        int attachmentIndex;
        if (subpassDescription.getContainer().isNull()) {
            return NullUtils.EMPTY_LIST;
        }
        ArrayList< @NonNull FrameCaptureViewData.AttachmentInfo> subpassAttachments = new ArrayList<FrameCaptureViewData.AttachmentInfo>();
        subpassDescription.getPColorAttachments().forEach(attachmentReference -> {
            int attachmentIndex;
            if (!attachmentReference.getContainer().isNull() && (attachmentIndex = attachmentReference.getAttachment().intValue()) < attachments.size()) {
                subpassAttachments.add((FrameCaptureViewData.AttachmentInfo)attachments.get(attachmentIndex));
            }
        });
        subpassDescription.getPResolveAttachments().forEach(attachmentReference -> {
            int attachmentIndex;
            if (!attachmentReference.getContainer().isNull() && (attachmentIndex = attachmentReference.getAttachment().intValue()) >= 0 && attachmentIndex < attachments.size()) {
                subpassAttachments.add((FrameCaptureViewData.AttachmentInfo)attachments.get(attachmentIndex));
            }
        });
        IVkAttachmentReference attachmentReference2 = subpassDescription.getPDepthStencilAttachment();
        if (!attachmentReference2.getContainer().isNull() && (attachmentIndex = attachmentReference2.getAttachment().intValue()) >= 0 && attachmentIndex < attachments.size()) {
            subpassAttachments.add(attachments.get(attachmentIndex));
        }
        subpassAttachments.sort((o1, o2) -> Integer.compare(o1.attachmentIndex, o2.attachmentIndex));
        return NullUtils.unmodifiableList(subpassAttachments);
    }

    private static String logVulkanCommandIndex(StringBuilder sb, VulkanCommandIndex index) {
        sb.append(index.getCommandBuffersIndex()).append(", ").append(index.getCommandIndex());
        if (index.getSecondaryCommand() == null) {
            return sb.toString();
        }
        sb.append(", ");
        return FrameCaptureViewController.logVulkanCommandIndex(sb, index.getSecondaryCommand());
    }

    public static class FrameCaptureViewRoot {
        public final @NonNull TraceStateSnapshot snapshot;
        public final @NonNull VulkanFrameCaptureTreeItem treeRoot;
        public final boolean isCaptured;
        private final @Nullable IAsynchronousDataListener dataArrivedListener;

        /*
         * Issues handling annotations - annotations may be inaccurate
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private FrameCaptureViewRoot(@NonNull TraceStateSnapshot snapshot, @NonNull FunctionCall vkQueueSubmit, @Nullable Integer asyncUID) {
            this.snapshot = snapshot;
            this.isCaptured = asyncUID != null;
            @NonNull List submitInfos = VULKAN.VkQueueSubmitDecorator.getArgumentPSubmits((FunctionCall)vkQueueSubmit);
            this.treeRoot = new VulkanFrameCaptureTreeItem(null);
            this.treeRoot.setExpanded(true);
            AssetTable assets = snapshot.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC);
            @NonNull HashMap<FrameCaptureViewData.AttachmentIndices, FrameCaptureViewData.AttachmentImageData> indicesToImageDataMap = new HashMap<FrameCaptureViewData.AttachmentIndices, FrameCaptureViewData.AttachmentImageData>();
            int submitInfosIndex = 0;
            while (submitInfosIndex < submitInfos.size()) {
                VULKAN.Structs.VkSubmitInfo submitInfo = (VULKAN.Structs.VkSubmitInfo)submitInfos.get(submitInfosIndex);
                FrameCaptureViewData.SubmitInfoData submitInfoData = new FrameCaptureViewData.SubmitInfoData(submitInfosIndex, submitInfo);
                VulkanFrameCaptureTreeItem submitInfoNode = new VulkanFrameCaptureTreeItem(submitInfoData);
                submitInfoNode.setExpanded(true);
                @NonNull LongsArgAttachment values = submitInfo.getPCommandBuffers();
                int commandBuffersIndex = 0;
                while (commandBuffersIndex < values.size()) {
                    Long commandBuffer = values.get(commandBuffersIndex);
                    VkCommandBufferAsset primaryCommandBufferAsset = (VkCommandBufferAsset)assets.get(commandBuffer);
                    @NonNull List renderPassInstances = primaryCommandBufferAsset.getRenderPassInstances();
                    FrameCaptureViewData.CommandBufferData commandBufferData = new FrameCaptureViewData.CommandBufferData(submitInfoData, commandBuffersIndex, primaryCommandBufferAsset);
                    VulkanFrameCaptureTreeItem commandBufferNode = new VulkanFrameCaptureTreeItem(commandBufferData);
                    commandBufferNode.setExpanded(true);
                    int renderPassIndex = 0;
                    while (renderPassIndex < renderPassInstances.size()) {
                        VkRenderPassInstance renderPassInstance = (VkRenderPassInstance)renderPassInstances.get(renderPassIndex);
                        @NonNull List< @NonNull FrameCaptureViewData.AttachmentInfo> renderPassAttachments = FrameCaptureViewController.getRenderPassAttachments(renderPassInstance);
                        FrameCaptureViewData.RenderPassData renderPassData = new FrameCaptureViewData.RenderPassData(commandBufferData, renderPassIndex, renderPassInstance, renderPassAttachments);
                        VulkanFrameCaptureTreeItem renderPassInstanceNode = new VulkanFrameCaptureTreeItem(renderPassData);
                        renderPassInstanceNode.setExpanded(true);
                        List subpassDescriptions = renderPassInstance.getParentRenderPass().getSubpasses();
                        @NonNull List subpasses = renderPassInstance.getSubpasses();
                        int subpassIndex = 0;
                        while (subpassIndex < subpassDescriptions.size()) {
                            List<VulkanDrawCallCommandIndex> drawCallCommandIndices;
                            @NonNull List< @NonNull FrameCaptureViewData.AttachmentInfo> attachments = FrameCaptureViewController.getAttachmentsWrittenBySubpass(renderPassAttachments, (IVkSubpassDescription)NullUtils.neverNull((Object)((IVkSubpassDescription)subpassDescriptions.get(subpassIndex))));
                            if (subpassIndex < subpasses.size()) {
                                VkSubpassInline subpass;
                                if (subpasses.get(subpassIndex) instanceof VkSubpassInline) {
                                    subpass = (VkSubpassInline)subpasses.get(subpassIndex);
                                    drawCallCommandIndices = FrameCaptureViewController.findDrawCallsInSubpassInline(subpass, primaryCommandBufferAsset, commandBuffersIndex);
                                } else {
                                    if (!(subpasses.get(subpassIndex) instanceof VkSubpassContentsSecondaryCommandBuffers)) throw new AssertionError((Object)("Unhandled subpass subclass: " + subpasses.get(subpassIndex)));
                                    subpass = (VkSubpassContentsSecondaryCommandBuffers)subpasses.get(subpassIndex);
                                    drawCallCommandIndices = FrameCaptureViewController.findDrawCallsInSubpassContentsSecondaryCommandBuffers((VkSubpassContentsSecondaryCommandBuffers)subpass, primaryCommandBufferAsset, commandBuffersIndex);
                                }
                            } else {
                                drawCallCommandIndices = NullUtils.EMPTY_LIST;
                            }
                             @NonNull FrameCaptureViewData.SubpassData subPassData = new FrameCaptureViewData.SubpassData(renderPassData, subpassIndex, attachments, drawCallCommandIndices.size());
                            VulkanFrameCaptureTreeItem subpassInstanceNode = new VulkanFrameCaptureTreeItem(subPassData);
                            for (VulkanDrawCallCommandIndex item : drawCallCommandIndices) {
                                FrameCaptureViewData.DrawCallData drawCallData = new FrameCaptureViewData.DrawCallData(subPassData, item.drawCall.getLabelText());
                                for (FrameCaptureViewData.AttachmentImageData imageData : drawCallData.getAttachmentImageData()) {
                                    indicesToImageDataMap.put(new FrameCaptureViewData.AttachmentIndices(submitInfosIndex, imageData.getAttachmentInfo().attachmentIndex, item.commandIndex), imageData);
                                }
                                subpassInstanceNode.getChildren().add((Object)new VulkanFrameCaptureTreeItem(drawCallData));
                            }
                            renderPassInstanceNode.getChildren().add((Object)subpassInstanceNode);
                            ++subpassIndex;
                        }
                        commandBufferNode.getChildren().add((Object)renderPassInstanceNode);
                        ++renderPassIndex;
                    }
                    submitInfoNode.getChildren().add((Object)commandBufferNode);
                    ++commandBuffersIndex;
                }
                this.treeRoot.getChildren().add((Object)submitInfoNode);
                ++submitInfosIndex;
            }
            Consumer<AsynchronousFunctionAttachment> asyncAttachmentConsumer = asyncAttachment -> {
                VulkanSubmitData submitData;
                VulkanSubmitAttachment submitAttachment;
                if (asyncAttachment instanceof VulkanSubmitData && (submitAttachment = (submitData = (VulkanSubmitData)asyncAttachment).getAttachment()) instanceof VulkanFramebufferAttachment) {
                    @NonNull VulkanFramebufferAttachment framebufferAttachment = (VulkanFramebufferAttachment)submitAttachment;
                    FrameCaptureViewData.AttachmentIndices indices = new FrameCaptureViewData.AttachmentIndices(submitData.getSubmitInfosIndex(), framebufferAttachment.getAttachmentIndex(), submitData.getCommand());
                    FrameCaptureViewData.AttachmentImageData imageData = (FrameCaptureViewData.AttachmentImageData)indicesToImageDataMap.get(indices);
                    if (imageData != null) {
                        imageData.setFramebufferAttachment(framebufferAttachment);
                    }
                }
            };
            if (asyncUID != null) {
                this.dataArrivedListener = (functionCallUID, assetData) -> {
                    if (functionCallUID.equals(asyncUID)) {
                        Platform.runLater(() -> asyncAttachmentConsumer.accept(assetData));
                    }
                };
                snapshot.getModel().getAsynchronousDataModel().addListener((IAsynchronousDataListener)NullUtils.neverNull((Object)this.dataArrivedListener));
                snapshot.getModel().getAsynchronousDataModel().getAsynchronousAssetData(asyncUID).forEach(asyncAttachmentConsumer);
                return;
            } else {
                this.dataArrivedListener = null;
            }
        }

        private void dispose() {
            if (this.dataArrivedListener != null) {
                this.snapshot.getModel().getAsynchronousDataModel().removeListener((IAsynchronousDataListener)NullUtils.neverNull((Object)this.dataArrivedListener));
            }
        }
    }

    private static class VulkanDrawCallCommandIndex {
        private final @NonNull FunctionCall drawCall;
        private final @NonNull VulkanCommandIndex commandIndex;

        private VulkanDrawCallCommandIndex(@NonNull FunctionCall drawCall, @NonNull VulkanCommandIndex commandIndex) {
            this.drawCall = drawCall;
            this.commandIndex = commandIndex;
        }
    }

    public static class VulkanFrameCaptureTreeItem
    extends TreeItem<FrameCaptureViewData.VulkanFrameCaptureTreeItemData> {
        private VulkanFrameCaptureTreeItem( @Nullable FrameCaptureViewData.VulkanFrameCaptureTreeItemData data) {
            super((Object)data);
        }
    }
}

