/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.IUserFileStore;
import com.arm.mgd.core.util.SerializationUtils;
import com.arm.mgd.ui.controllers.RunnableWatchService;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TreeItem;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FileExplorerController {
    private final @NonNull RootTreeItem rootItem = new RootTreeItem(this);
    private final @NonNull ReadOnlyObjectWrapper<FileTreeItem> rootProperty = new ReadOnlyObjectWrapper((Object)this.rootItem);
    private final @NonNull Map<File, FileTreeItem> explicitlyAddedLocations = new HashMap<File, FileTreeItem>();
    private final @NonNull Thread watcherThread;
    private final @Nullable RunnableWatchService<FileTreeItem> watcher;
    private final @NonNull Predicate<@NonNull File> interestingFilePredicate;
    private final @NonNull PredicateFileFilter filter = new PredicateFileFilter();

    private @NonNull ArrayList<@NonNull ExplicitlyAddedLocation> createRecords() {
        ArrayList<@NonNull ExplicitlyAddedLocation> records = new ArrayList<ExplicitlyAddedLocation>();
        for (FileTreeItem fileTreeItem : this.explicitlyAddedLocations.values()) {
            records.add(new ExplicitlyAddedLocation(((FileExplorerItem)fileTreeItem.getValue()).isDirectory(), ((FileExplorerItem)fileTreeItem.getValue()).file));
        }
        return records;
    }

    public void saveExplicitlyAddedLocations(@NonNull IUserFileStore store, @NonNull Path storePath) {
        try {
            store.store(storePath, SerializationUtils.serialize(this.createRecords()));
        }
        catch (IOException e) {
            CoreLogging.severe(null, (Throwable)e, (String)("Failed to store explicitly added script locations to " + storePath));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void loadSavedExplicitlyAddedLocations(@NonNull IUserFileStore store, @NonNull Path loadPath) {
        @NonNull ArrayList records = null;
        try {
            byte @Nullable [] data = store.load(loadPath);
            if (data != null) {
                records = (ArrayList)SerializationUtils.deserialize((byte[])data, (ClassLoader)this.getClass().getClassLoader());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            CoreLogging.severe(null, (Throwable)e, (String)("Failed to load explicity added script locations from " + loadPath));
        }
        if (records != null) {
            for (ExplicitlyAddedLocation record : records) {
                this.addFileSystemLocation(record.file, record.directory);
            }
        }
    }

    public FileExplorerController(@NonNull Predicate<@NonNull File> interestingFilePredicate) {
        this.interestingFilePredicate = interestingFilePredicate;
        RunnableWatchService<FileTreeItem> localWatcher = null;
        try {
            localWatcher = new RunnableWatchService<FileTreeItem>(new RunnableWatchService.IFileChangedEventListener<FileTreeItem>(){

                @Override
                public void directoryUpdated(FileTreeItem itemToUpdate) {
                    itemToUpdate.update();
                }
            });
        }
        catch (IOException e) {
            CoreLogging.severe(null, (Throwable)e, (String)"Failed to a file system watch.");
        }
        this.watcher = localWatcher;
        this.watcherThread = new Thread(this.watcher, "FileExplorerController watcher thread");
        this.watcherThread.start();
    }

    public ReadOnlyObjectProperty<FileTreeItem> treeRootProperty() {
        return this.rootProperty.getReadOnlyProperty();
    }

    public void addFileSystemLocation(@NonNull File location, boolean directory) {
        if (this.explicitlyAddedLocations.get(location) == null) {
            FileTreeItem newTreeItem = this.createTreeItem(location, true, directory);
            Platform.runLater(() -> this.rootItem.addChild(newTreeItem));
            this.explicitlyAddedLocations.put(location, newTreeItem);
        }
    }

    public void removeFileSystemLocation(@NonNull File location) {
        FileTreeItem itemToRemove = this.explicitlyAddedLocations.remove(location);
        if (itemToRemove != null) {
            itemToRemove.stopWatching();
            Platform.runLater(() -> this.rootItem.removeChild(itemToRemove));
        }
    }

    private @NonNull FileTreeItem createTreeItem(@NonNull File location, boolean topLevelItem, boolean isDirectory) {
        if (!isDirectory) {
            return new FileTreeItem(new FileExplorerItem(location, topLevelItem, false));
        }
        return new DirectoryTreeItem(new FileExplorerItem(location, topLevelItem, true));
    }

    public void shutdown() {
        if (this.watcher != null) {
            this.watcher.shutdown();
        }
    }

    private class DirectoryTreeItem
    extends FileTreeItem {
        private final List<FileTreeItem> files;
        private boolean childWatchSetup;
        private boolean childrenInitialised;
        private boolean isLeafCalculated;
        private boolean isLeaf;

        DirectoryTreeItem(FileExplorerItem file) {
            super(file);
            this.files = new ArrayList<FileTreeItem>();
            this.childWatchSetup = false;
            this.childrenInitialised = false;
            this.isLeafCalculated = false;
            this.isLeaf = true;
            this.addChildWatch();
        }

        private void addChildWatch() {
            if (!this.childWatchSetup && FileExplorerController.this.watcher != null) {
                try {
                    this.childWatchSetup = FileExplorerController.this.watcher.watchDirectory(((FileExplorerItem)this.getValue()).file, this, FileExplorerController.this.filter);
                }
                catch (IOException e) {
                    CoreLogging.severe(null, (Throwable)e, (String)("Failed to add watchers for the children of " + ((FileExplorerItem)this.getValue()).getFile()));
                }
            }
        }

        public boolean isLeaf() {
            if (!this.isLeafCalculated) {
                this.isLeafCalculated = true;
                this.calculateIsLeaf();
            }
            return this.isLeaf;
        }

        public ObservableList<TreeItem<@NonNull FileExplorerItem>> getChildren() {
            if (!this.childrenInitialised) {
                this.childrenInitialised = true;
                this.populate();
            }
            return super.getChildren();
        }

        private void calculateIsLeaf() {
            try {
                this.isLeaf = !((FileExplorerItem)this.getValue()).isAccessible.get() || !Files.list(((FileExplorerItem)this.getValue()).file.toPath()).anyMatch(new Predicate<Path>(){

                    @Override
                    public boolean test(Path t) {
                        return t.toFile().canRead() && (t.toFile().isDirectory() || ((DirectoryTreeItem)DirectoryTreeItem.this).FileExplorerController.this.interestingFilePredicate.test((File)NullUtils.neverNull((Object)t.toFile())));
                    }
                });
            }
            catch (IOException e) {
                CoreLogging.severe(null, (Throwable)e, (String)("Failed to list contents of " + ((FileExplorerItem)this.getValue()).file));
            }
        }

        private synchronized void populate() {
            if (!((FileExplorerItem)this.getValue()).isAccessible.get()) {
                return;
            }
            this.files.clear();
            File[] fileArray = (File[])NullUtils.neverNull((Object[])((FileExplorerItem)this.getValue()).file.listFiles(FileExplorerController.this.filter));
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File location = fileArray[n2];
                assert (location != null);
                if (location.canRead()) {
                    this.files.add(FileExplorerController.this.createTreeItem(location, false, location.isDirectory()));
                }
                ++n2;
            }
            Collections.sort(this.files);
            Platform.runLater(() -> super.getChildren().setAll(this.files));
        }

        @Override
        protected void update() {
            super.update();
            this.calculateIsLeaf();
            this.addChildWatch();
            if (this.childrenInitialised) {
                this.removeWatchersForChildren();
                this.populate();
            }
            Platform.runLater(() -> {
                super.getChildren().add(null);
                super.getChildren().remove(super.getChildren().size() - 1);
            });
        }

        private void removeWatchersForChildren() {
            for (TreeItem treeItem : this.files) {
                assert (treeItem instanceof FileTreeItem);
                FileTreeItem fileTreeItem = (FileTreeItem)treeItem;
                fileTreeItem.stopWatching();
            }
        }

        @Override
        protected void stopWatching() {
            super.stopWatching();
            if (this.childrenInitialised) {
                this.removeWatchersForChildren();
                this.files.clear();
            }
            if (FileExplorerController.this.watcher != null && this.childWatchSetup) {
                FileExplorerController.this.watcher.stopWatchingDirectory(((FileExplorerItem)this.getValue()).file, this);
            }
        }
    }

    private static class ExplicitlyAddedLocation
    implements Serializable {
        private static final long serialVersionUID = -2466822908708444821L;
        private final boolean directory;
        private final @NonNull File file;

        private ExplicitlyAddedLocation(boolean directory, @NonNull File file) {
            this.directory = directory;
            this.file = file;
        }
    }

    public class FileExplorerItem
    implements Comparable<FileExplorerItem> {
        private final boolean directory;
        private final boolean explicitlyAdded;
        private final @NonNull ReadOnlyBooleanWrapper isAccessible = new ReadOnlyBooleanWrapper();
        private final @NonNull File file;

        public FileExplorerItem(File file, boolean explicitlyAdded, boolean isDirectory) {
            this.file = file;
            this.directory = isDirectory;
            this.explicitlyAdded = explicitlyAdded;
        }

        public void updateAccessibility() {
            this.isAccessible.set(this.file.canRead() && this.file.isDirectory() == this.directory);
        }

        public @NonNull File getFile() {
            return this.file;
        }

        public ReadOnlyBooleanProperty accessible() {
            return this.isAccessible.getReadOnlyProperty();
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public String toString() {
            return "FileExplorerItem: [ file: " + this.getFile() + ", isDirectory: " + this.directory + ", isAccessible: " + this.isAccessible;
        }

        public boolean wasExplicitlyAdded() {
            return this.explicitlyAdded;
        }

        @Override
        public int compareTo(FileExplorerItem other) {
            if (other == null) {
                return 1;
            }
            return this.file.compareTo(other.file);
        }
    }

    private class FileTreeItem
    extends TreeItem<FileExplorerItem>
    implements Comparable<FileTreeItem> {
        private boolean parentWatchSetup;

        FileTreeItem(FileExplorerItem file) {
            super((Object)file);
            this.parentWatchSetup = false;
            ((FileExplorerItem)this.getValue()).updateAccessibility();
            this.addParentWatch();
        }

        FileTreeItem() {
            this.parentWatchSetup = false;
        }

        private void addParentWatch() {
            if (((FileExplorerItem)this.getValue()).explicitlyAdded && FileExplorerController.this.watcher != null && !this.parentWatchSetup) {
                try {
                    this.parentWatchSetup = FileExplorerController.this.watcher.watchParents(((FileExplorerItem)this.getValue()).getFile(), this);
                }
                catch (IOException e) {
                    CoreLogging.severe(null, (Throwable)e, (String)("Failed to add watchers for the parents of " + ((FileExplorerItem)this.getValue()).getFile()));
                }
            }
        }

        protected void update() {
            ((FileExplorerItem)this.getValue()).updateAccessibility();
            this.addParentWatch();
        }

        protected void stopWatching() {
            if (((FileExplorerItem)this.getValue()).explicitlyAdded && FileExplorerController.this.watcher != null && this.parentWatchSetup) {
                FileExplorerController.this.watcher.stopWatchingParents(((FileExplorerItem)this.getValue()).getFile(), this);
            }
        }

        @Override
        public int compareTo(FileTreeItem other) {
            if (other == null) {
                return 1;
            }
            return ((FileExplorerItem)this.getValue()).compareTo((FileExplorerItem)other.getValue());
        }
    }

    private final class PredicateFileFilter
    implements FileFilter {
        private PredicateFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.exists() || pathname.isDirectory() || FileExplorerController.this.interestingFilePredicate.test(pathname);
        }
    }

    private class RootTreeItem
    extends FileTreeItem {
        private final @NonNull ObservableList<FileTreeItem> children;
        private final @NonNull SortedList<FileTreeItem> sortedChildren;
        final /* synthetic */ FileExplorerController this$0;

        /*
         * Exception decompiling
         */
        private RootTreeItem(FileExplorerController fileExplorerController) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.pathIterator()" because the return value of "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.access$300(org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated)" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated$Iterator.moveNested(JavaRefTypeInstance.java:200)
             *     at org.benf.cfr.reader.entities.attributes.TypePathPartNested.apply(TypePathPartNested.java:14)
             *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:54)
             *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:45)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.handleStatement(TypeAnnotationTransformer.java:141)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:144)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:61)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:55)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.applyTypeAnnotations(Op04StructuredStatement.java:733)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:957)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void addChild(@NonNull FileTreeItem child) {
            this.children.add((Object)child);
        }

        void removeChild(@NonNull FileTreeItem child) {
            this.children.remove((Object)child);
        }
    }
}

