/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ConsoleTextBuilder {
    protected final String @NonNull [] lines;
    protected final int maxConsoleLines;
    protected int currentLineNumber = 0;
    protected int currentCaretPosition = 0;
    public static @NonNull String LINE_SEPARATOR = "\n";

    public ConsoleTextBuilder(int maxConsoleLines) {
        this.maxConsoleLines = maxConsoleLines;
        this.lines = new String[maxConsoleLines];
    }

    public synchronized void append(@NonNull String newLine) {
        assert (this.currentLineNumber < ((String[])NullUtils.neverNull((Object[])this.lines)).length);
        String currentLine = this.lines[this.currentLineNumber];
        if (currentLine == null) {
            boolean oldLineLength = false;
            this.currentCaretPosition = this.currentCaretPosition - 0 + newLine.length();
            this.lines[this.currentLineNumber] = newLine;
        } else if (ConsoleTextBuilder.isComplete(currentLine)) {
            int oldLineLength = currentLine.length();
            this.currentCaretPosition = this.currentCaretPosition - oldLineLength + newLine.length();
            this.lines[this.currentLineNumber] = newLine;
        } else {
            this.currentCaretPosition += newLine.length();
            this.lines[this.currentLineNumber] = String.valueOf(currentLine) + newLine;
        }
        if (ConsoleTextBuilder.isComplete(this.lines[this.currentLineNumber])) {
            this.currentLineNumber = (this.currentLineNumber + 1) % this.maxConsoleLines;
        }
    }

    public synchronized @NonNull String getPreviouslyCompletedLine() {
        assert (this.currentLineNumber < ((String[])NullUtils.neverNull((Object[])this.lines)).length);
        int previouslyCompletedLineNumber = this.currentLineNumber == 0 ? this.maxConsoleLines - 1 : this.currentLineNumber - 1;
        String previouslyCompletedLine = this.lines[previouslyCompletedLineNumber];
        if (previouslyCompletedLine == null) {
            return "";
        }
        return previouslyCompletedLine;
    }

    public synchronized @NonNull String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        int startingLineNumber = this.currentLineNumber;
        if (ConsoleTextBuilder.isPartial(this.lines[this.currentLineNumber])) {
            ++startingLineNumber;
        }
        int i = 0;
        while (i < this.maxConsoleLines) {
            int lineNo = (i + startingLineNumber) % this.maxConsoleLines;
            if (this.lines[lineNo] != null) {
                stringBuilder.append(this.lines[lineNo]);
            }
            ++i;
        }
        return (String)NullUtils.neverNull((Object)stringBuilder.toString());
    }

    private static boolean isPartial(@Nullable String line) {
        return line != null && !line.endsWith(LINE_SEPARATOR);
    }

    private static boolean isComplete(@Nullable String line) {
        return line != null && line.endsWith(LINE_SEPARATOR);
    }

    public synchronized int getCaretPosition() {
        return this.currentCaretPosition;
    }

    public synchronized int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    public synchronized void reset() {
        int i = 0;
        while (i < this.maxConsoleLines) {
            this.lines[i] = null;
            ++i;
        }
        this.currentCaretPosition = 0;
    }
}

