/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.ui.controllers.ConsoleTextBuilder;
import com.arm.mgd.ui.controllers.IConsoleCommandsHistory;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ConsoleCommandsHistory
extends ConsoleTextBuilder
implements IConsoleCommandsHistory {
    private int previousIndex = -1;
    private int nextIndex = -1;
    private boolean lastRequestedCommandPrev = true;
    private boolean getPreviousCalledBefore = false;

    public ConsoleCommandsHistory(int maxNoOfLines) {
        super(maxNoOfLines);
        assert (maxNoOfLines != 0);
    }

    @Override
    public synchronized void append(@NonNull String newLine) {
        if (this.getPreviousCalledBefore) {
            boolean oldLineLength = false;
            this.currentCaretPosition = this.currentCaretPosition - 0 + newLine.length();
            this.lines[ConsoleCommandsHistory.getIndexBefore((int)this.currentLineNumber, (int)this.maxConsoleLines)] = newLine;
        } else {
            super.append(newLine);
        }
        this.previousIndex = this.currentLineNumber;
        this.nextIndex = -1;
        this.lastRequestedCommandPrev = true;
        this.getPreviousCalledBefore = false;
    }

    @Override
    public @NonNull String getPrevious() {
        return this.getPrevious(null);
    }

    @Override
    public @NonNull String getPrevious(@Nullable String replacingLine) {
        if (this.previousIndex == -1) {
            return "";
        }
        int newIndexPrev = this.previousIndex;
        if (this.lastRequestedCommandPrev) {
            if (!this.historyTop(newIndexPrev = ConsoleCommandsHistory.getIndexBefore(newIndexPrev, this.maxConsoleLines))) {
                this.nextIndex = this.previousIndex;
                this.previousIndex = newIndexPrev;
                this.editCurrentHistoryLine(this.nextIndex, replacingLine, this.getPreviousCalledBefore);
                this.getPreviousCalledBefore = true;
            }
        } else {
            this.editCurrentHistoryLine(this.nextIndex, replacingLine, this.getPreviousCalledBefore);
        }
        this.lastRequestedCommandPrev = true;
        @Nullable String previousCommand = this.lines[this.previousIndex];
        if (previousCommand == null) {
            return "";
        }
        return ConsoleCommandsHistory.trimLeadingNewLine(previousCommand);
    }

    private void editCurrentHistoryLine(int position, @Nullable String replacingLine, boolean replace) {
        if (replacingLine == null) {
            return;
        }
        if (replace) {
            this.lines[position] = replacingLine;
        } else {
            super.append(replacingLine);
        }
    }

    @Override
    public @NonNull String getNext() {
        return this.getNext(null);
    }

    @Override
    public @NonNull String getNext(@Nullable String replacingLine) {
        if (this.nextIndex == -1) {
            return "";
        }
        int newIndexNext = this.nextIndex;
        if (!this.lastRequestedCommandPrev) {
            if (!this.historyBottom(newIndexNext = ConsoleCommandsHistory.getIndexAfter(newIndexNext, this.maxConsoleLines))) {
                this.previousIndex = this.nextIndex;
                this.nextIndex = newIndexNext;
                this.editCurrentHistoryLine(this.previousIndex, replacingLine, true);
            }
        } else {
            this.editCurrentHistoryLine(this.previousIndex, replacingLine, true);
        }
        this.lastRequestedCommandPrev = false;
        @Nullable String nextCommand = this.lines[this.nextIndex];
        if (nextCommand == null) {
            return "";
        }
        return ConsoleCommandsHistory.trimLeadingNewLine(nextCommand);
    }

    private static @NonNull String trimLeadingNewLine(@NonNull String historyLine) {
        int newLineIndex = historyLine.indexOf(ConsoleTextBuilder.LINE_SEPARATOR);
        if (newLineIndex > -1) {
            return (String)NullUtils.neverNull((Object)historyLine.substring(0, newLineIndex));
        }
        return historyLine;
    }

    private boolean historyTop(int newIndexPrev) {
        return newIndexPrev == ConsoleCommandsHistory.getIndexBefore(this.currentLineNumber, this.maxConsoleLines) && this.nextIndex != -1 || this.lines[newIndexPrev] == null;
    }

    private boolean historyBottom(int newIndexNext) {
        return newIndexNext == this.currentLineNumber || this.lines[newIndexNext] == null;
    }

    private static int getIndexAfter(int index, int max) {
        if (index == max - 1) {
            return 0;
        }
        return index + 1;
    }

    private static int getIndexBefore(int index, int max) {
        if (index == 0) {
            return max - 1;
        }
        return index - 1;
    }
}

