/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class CaptureModeController {
    private static boolean allFramebufferAttachmentsEnabled = false;
    private static boolean overdrawEnabled = false;
    private static boolean shaderMapEnabled = false;
    private static boolean fragmentCountStatisticsEnabled = false;
    private static final @NonNull Set<@NonNull CaptureModeEnabledListener> listeners = new HashSet<CaptureModeEnabledListener>();

    public static void addCaptureModeEnabledListener(@NonNull CaptureModeEnabledListener listener) {
        listeners.add(listener);
    }

    public static void setCaptureMode(@NonNull ModifyStateInterceptorCommand commandToSet, boolean enabled) {
        switch (commandToSet) {
            case ALLATTACHMENTSMODE_ENABLED: {
                allFramebufferAttachmentsEnabled = enabled;
                break;
            }
            case FRAGMENTCOUNT_ENABLED: {
                fragmentCountStatisticsEnabled = enabled;
                break;
            }
            case OVERDRAW_ENABLED: {
                overdrawEnabled = enabled;
                break;
            }
            case SHADERMAP_ENABLED: {
                shaderMapEnabled = enabled;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (enabled) {
            listeners.forEach(listener -> listener.onCaptureModeEnabled(commandToSet));
        }
    }

    public static @NonNull ModifyStateInterceptorCommand getCaptureMode() {
        CaptureModeController.assertStateIsValid();
        if (allFramebufferAttachmentsEnabled) {
            return ModifyStateInterceptorCommand.ALLATTACHMENTSMODE_ENABLED;
        }
        if (overdrawEnabled) {
            return ModifyStateInterceptorCommand.OVERDRAW_ENABLED;
        }
        if (shaderMapEnabled) {
            return ModifyStateInterceptorCommand.SHADERMAP_ENABLED;
        }
        if (fragmentCountStatisticsEnabled) {
            return ModifyStateInterceptorCommand.FRAGMENTCOUNT_ENABLED;
        }
        return ModifyStateInterceptorCommand.ALL_DISABLED;
    }

    private static void assertStateIsValid() {
        assert (Stream.of(allFramebufferAttachmentsEnabled, overdrawEnabled, shaderMapEnabled, fragmentCountStatisticsEnabled).filter(bool -> bool).count() <= 1L);
    }

    @FunctionalInterface
    public static interface CaptureModeEnabledListener {
        public void onCaptureModeEnabled(@NonNull ModifyStateInterceptorCommand var1);
    }
}

