/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.StringJoiner;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BuffersViewItem
implements IAssetWrapper<IBufferItem> {
    public static final String PROPERTY_SIZE = "size";
    public static final String PROPERTY_USAGE = "usage";
    public static final String PROPERTY_LAST_BOUND_TARGET = "lastBoundTarget";
    public static final String PROPERTY_BUFFER_NAME = "bufferName";
    private final @NonNull ReadOnlyObjectWrapper<@NonNull BufferName> bufferName = new ReadOnlyObjectWrapper();
    private final @NonNull ReadOnlyLongWrapper size = new ReadOnlyLongWrapper();
    private final @NonNull ReadOnlyObjectWrapper<@NonNull IBufferUsage> usage = new ReadOnlyObjectWrapper();
    private final @NonNull ReadOnlyObjectWrapper<@Nullable AbstractConstantOrAliasSpecExtended> lastBoundTarget = new ReadOnlyObjectWrapper();
    private @NonNull WeakReference<IBufferItem> bufferAsset;

    public BuffersViewItem(@NonNull IBufferItem bufferAsset) {
        this.bufferAsset = new WeakReference<IBufferItem>(bufferAsset);
        this.setBufferAsset(bufferAsset);
    }

    public void setBufferAsset(@NonNull IBufferItem asset) {
        this.bufferAsset = new WeakReference<IBufferItem>(asset);
        this.bufferName.set((Object)new BufferName(asset));
        this.size.set(asset.getSizeOfBuffer());
        this.usage.set((Object)asset.getBufferUsage());
        if (asset instanceof GlBufferAsset) {
            GlBufferAsset glAsset = (GlBufferAsset)asset;
            this.lastBoundTarget.set((Object)glAsset.getLastBoundTarget());
        } else {
            this.lastBoundTarget.set(null);
        }
    }

    public @Nullable IBufferItem getBufferAsset() {
        return (IBufferItem)this.bufferAsset.get();
    }

    public ReadOnlyLongProperty sizeProperty() {
        return this.size.getReadOnlyProperty();
    }

    public ReadOnlyObjectProperty<@NonNull IBufferUsage> usageProperty() {
        return this.usage.getReadOnlyProperty();
    }

    public ReadOnlyObjectProperty<@Nullable AbstractConstantOrAliasSpecExtended> lastBoundTargetProperty() {
        return this.lastBoundTarget.getReadOnlyProperty();
    }

    public ReadOnlyObjectProperty<@NonNull BufferName> bufferNameProperty() {
        return this.bufferName.getReadOnlyProperty();
    }

    @Override
    public @Nullable IBufferItem getAsset() {
        return (IBufferItem)this.bufferAsset.get();
    }

    @Override
    public @NonNull String getClipboardContent() {
        StringJoiner stringJoiner = new StringJoiner(", ");
        stringJoiner.add(((BufferName)this.bufferNameProperty().getValue()).getName());
        stringJoiner.add(this.sizeProperty().getValue().toString());
        stringJoiner.add(((IBufferUsage)this.usageProperty().getValue()).getLabelText());
        @Nullable AbstractConstantOrAliasSpecExtended lastBoundTargetPropertyValue = (AbstractConstantOrAliasSpecExtended)this.lastBoundTargetProperty().getValue();
        stringJoiner = stringJoiner.add(lastBoundTargetPropertyValue != null ? lastBoundTargetPropertyValue.getName() : "");
        return (String)NullUtils.neverNull((Object)stringJoiner.toString());
    }

    public class BufferName
    implements Comparable<BufferName> {
        private final long value;
        private final String name;

        public BufferName(IBufferItem asset) {
            this.value = asset.getId();
            this.name = asset instanceof VkBufferAsset || asset instanceof ClMemoryAsset ? asset.toString() : Long.toString(this.value);
        }

        @Override
        public int compareTo(BufferName other) {
            if (other == null) {
                return 1;
            }
            return Long.compare(this.value, other.value);
        }

        public String getName() {
            return this.name;
        }
    }
}

