/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.BuffersViewItem;
import com.arm.mgd.ui.controllers.NavigationChangeTableViewController;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BuffersViewController
extends NavigationChangeTableViewController<BuffersViewItem> {
    private final @NonNull ReadOnlyStringWrapper buffersMemoryUsageMessage;
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private static final @NonNull String DEFAULT_CONTEXT_INFO_MESSAGE = "The filter will be applied to the buffer ID, the usage, and the last bound target field.";
    private final @NonNull ReadOnlyStringWrapper filterPatternContextMessage = new ReadOnlyStringWrapper("The filter will be applied to the buffer ID, the usage, and the last bound target field.");
    private final @NonNull ReadOnlyBooleanWrapper filterPatternIsValid = new ReadOnlyBooleanWrapper(true);
    private final @NonNull StringProperty filterText = new SimpleStringProperty();
    private @NonNull Map<IBufferItem, BuffersViewItem> cachedViewItems = new HashMap<IBufferItem, BuffersViewItem>();

    public BuffersViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.buffersMemoryUsageMessage = new ReadOnlyStringWrapper("");
        InvalidationListener onItemsOrSelectionChanged = observable -> {
            assert (Platform.isFxApplicationThread());
            ObservableList items = this.getItemList();
            if (this.selectedIndices.isEmpty()) {
                long buffersMemoryUsage = items.stream().mapToLong(item -> item.sizeProperty().longValue()).sum();
                this.buffersMemoryUsageMessage.set("All buffers: " + buffersMemoryUsage + " bytes");
            } else {
                int noOfSelectedItems = 0;
                long buffersMemoryUsage = 0L;
                for (Integer index : this.selectedIndices) {
                    BuffersViewItem item2;
                    if (index == -1) continue;
                    BuffersViewItem buffersViewItem = item2 = items.size() > index ? (BuffersViewItem)items.get(index) : null;
                    if (item2 == null) continue;
                    ++noOfSelectedItems;
                    buffersMemoryUsage += item2.sizeProperty().longValue();
                }
                this.buffersMemoryUsageMessage.set(String.valueOf(noOfSelectedItems) + " selected " + StringUtils.formatQuantity((long)noOfSelectedItems, (String)"buffer", (String)"buffers") + ": " + buffersMemoryUsage + " bytes");
            }
        };
        this.getItemList().addListener(onItemsOrSelectionChanged);
        this.selectedIndices.addListener(onItemsOrSelectionChanged);
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, this.getNavigationChangedListener());
    }

    @Override
    public void dispose() {
        this.navigationChangedListener.dispose();
    }

    public ReadOnlyStringProperty buffersMemoryUsageMessageProperty() {
        return this.buffersMemoryUsageMessage.getReadOnlyProperty();
    }

    private @NonNull BuffersViewItem getCachedOrNewViewItem(@NonNull IBufferItem item) {
        BuffersViewItem viewItem = this.cachedViewItems.get(item);
        if (viewItem == null) {
            viewItem = new BuffersViewItem(item);
        } else {
            viewItem.setBufferAsset(item);
        }
        return viewItem;
    }

    @Override
    protected void refreshData(@Nullable TraceStateSnapshot snapshot) {
        HashMap<IBufferItem, BuffersViewItem> newCachedViewItems = new HashMap<IBufferItem, BuffersViewItem>();
        LinkedHashSet<@NonNull E> newItems = new LinkedHashSet();
        if (snapshot != null) {
            Consumer<IAssetItem> bufferAdder = item -> {
                if (item instanceof IBufferItem) {
                    IBufferItem buffer = (IBufferItem)item;
                    BuffersViewItem viewItem = this.getCachedOrNewViewItem(buffer);
                    newItems.add(viewItem);
                    newCachedViewItems.put(buffer, viewItem);
                }
            };
            snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC).forEach(bufferAdder);
            snapshot.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC).forEach(bufferAdder);
            snapshot.getAssetTableBySpec(KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC).forEach(bufferAdder);
        }
        this.cachedViewItems = newCachedViewItems;
        Platform.runLater(() -> this.setItems(newItems));
    }

    public ObservableStringValue getBuffersMemoryUsageMessage() {
        return this.buffersMemoryUsageMessage;
    }

    public void bindFilterText(StringProperty viewFilterText) {
        this.filterText.bind((ObservableValue)viewFilterText);
        this.filterText.addListener((observable, oldValue, newValue) -> {
            BuffersViewItemPredicate filteredListPredicate = null;
            @NonNull String contextMessage = DEFAULT_CONTEXT_INFO_MESSAGE;
            this.filterPatternIsValid.set(true);
            if (newValue != null && !newValue.isEmpty()) {
                try {
                    @NonNull Pattern filterPattern = (Pattern)NullUtils.neverNull((Object)Pattern.compile(newValue, 2));
                    filteredListPredicate = new BuffersViewItemPredicate(filterPattern);
                }
                catch (PatternSyntaxException exception) {
                    contextMessage = "This regular expression is invalid. Specifically:\n\n" + exception.getMessage() + "\n\nSee the Help for more information.";
                    this.filterPatternIsValid.set(false);
                }
            }
            this.filterPatternContextMessage.set(contextMessage);
            this.setFilteredListPredicate(filteredListPredicate);
        });
    }

    public ReadOnlyStringProperty filterPatternContextMessageProperty() {
        return this.filterPatternContextMessage.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty filterPatternIsValidProperty() {
        return this.filterPatternIsValid.getReadOnlyProperty();
    }

    private static class BuffersViewItemPredicate
    implements Predicate<BuffersViewItem> {
        private final @NonNull Pattern filterPattern;

        public BuffersViewItemPredicate(@NonNull Pattern filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public boolean test(BuffersViewItem buffersViewItem) {
            if (buffersViewItem != null) {
                String targetName;
                String name = ((BuffersViewItem.BufferName)buffersViewItem.bufferNameProperty().getValue()).getName();
                String usage = ((IBufferUsage)buffersViewItem.usageProperty().getValue()).getLabelText();
                @Nullable AbstractConstantOrAliasSpecExtended target = (AbstractConstantOrAliasSpecExtended)buffersViewItem.lastBoundTargetProperty().get();
                String string = targetName = target == null ? "" : target.getName();
                return this.filterPattern.matcher(usage).find() || this.filterPattern.matcher(targetName).find() || this.filterPattern.matcher(name).find();
            }
            return false;
        }
    }
}

