/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.INavigationStackChangedListener;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BreadcrumbBarController
implements INavigationChangedListener,
INavigationStackChangedListener {
    private final @NonNull ReadOnlyObjectWrapper<@Nullable NavigationUri> currentLocation = new ReadOnlyObjectWrapper(null);
    private final @NonNull ReadOnlyBooleanWrapper uriStackEmpty = new ReadOnlyBooleanWrapper(true);
    private final @NonNull ReadOnlyBooleanWrapper homeAvailable = new ReadOnlyBooleanWrapper(false);

    public BreadcrumbBarController() {
        CoreInstance.getNavigationManager().addNavigationChangedListener((INavigationChangedListener)this);
        CoreInstance.getNavigationManager().addNavigationStackChangedListener((INavigationStackChangedListener)this);
        this.homeAvailable.bind((ObservableValue)this.currentLocation.isNotNull());
    }

    public void setNavigationUri(@NonNull NavigationUri newURI) {
        CoreInstance.getNavigationManager().setNavigationURI(newURI, (Object)this);
        this.currentLocation.set((Object)newURI);
    }

    public ReadOnlyObjectProperty<NavigationUri> currentNavigationURIProperty() {
        return this.currentLocation.getReadOnlyProperty();
    }

    public void close() {
        CoreInstance.getNavigationManager().removeNavigationChangedListener((INavigationChangedListener)this);
        CoreInstance.getNavigationManager().removeNavigationStackChangedListener((INavigationStackChangedListener)this);
    }

    public void onNavigationChanged(NavigationUriChangeEvent newURIChangeEvent) {
        if (newURIChangeEvent.didNotOriginateHere((Object)this)) {
            NavigationUri newUri = newURIChangeEvent.getNewNavigationUri();
            this.currentLocation.set((Object)newUri);
        }
    }

    public void onNavigationStackChanged(boolean emtpty) {
        Platform.runLater(() -> this.uriStackEmpty.set(emtpty));
    }

    public void backCommand() {
        CoreInstance.getNavigationManager().goBack();
    }

    public ReadOnlyBooleanProperty getUriStackEmptyProperty() {
        return this.uriStackEmpty.getReadOnlyProperty();
    }

    public void homeCommand() {
        NavigationUri uri = (NavigationUri)this.currentLocation.get();
        if (uri != null) {
            uri.getTarget(target -> {
                if (target != null) {
                    this.setNavigationUri(new NavigationUri((INavigationElement)target));
                }
                return null;
            });
        }
    }

    public @NonNull ReadOnlyBooleanProperty homeAvailableProperty() {
        return this.homeAvailable;
    }
}

