/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.BookmarkModel;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BookmarksViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyObjectWrapper<Boolean> addButtonDisabled = new ReadOnlyObjectWrapper();
    private final @NonNull ObjectProperty<@Nullable TraceDataModel> currentModel = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable FunctionCall> currentFunction = new SimpleObjectProperty();
    private final @NonNull ObservableList<@NonNull BookmarksViewItem> bookmarkItems = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull Map<@NonNull FunctionCall, BookmarksViewItem> bookmarkItemsMap = new HashMap<FunctionCall, BookmarksViewItem>();
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BookmarkModel.IBookmarkChangeListener bookmarkListener;
    private final @NonNull AtomicBoolean isUpdatingBookmarks = new AtomicBoolean(false);

    public BookmarksViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.bookmarkListener = new BookmarkModel.IBookmarkChangeListener(){

            public boolean onBookmarksChange(@NonNull TraceDataModel model, @NonNull Map<@NonNull FunctionCall, // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable BookmarkModel.Bookmark> modifiedBookmarks) {
                if (!BookmarksViewController.this.isUpdatingBookmarks.compareAndSet(false, true)) {
                    return false;
                }
                Platform.runLater(() -> {
                    try {
                        BookmarksViewController.this.updateBookmarks(model, modifiedBookmarks);
                    }
                    finally {
                        BookmarksViewController.this.isUpdatingBookmarks.set(false);
                    }
                });
                return true;
            }
        };
        this.currentFunction.addListener((observable, oldValue, newValue) -> this.currentModel.set((Object)(newValue != null ? newValue.getModel() : null)));
        this.currentModel.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.getBookmarkModel().removeListener(this.bookmarkListener);
                this.bookmarkItems.clear();
                this.bookmarkItemsMap.clear();
            }
            if (newValue != null) {
                assert (this.bookmarkItems.isEmpty());
                ArrayList<@NonNull E> newViewItems = new ArrayList();
                newValue.getBookmarkModel().addListener((fc, bookmark) -> {
                    BookmarksViewItem item = new BookmarksViewItem((FunctionCall)fc);
                    item.note.set((Object)bookmark.getNote());
                    newViewItems.add(item);
                    this.bookmarkItemsMap.put((FunctionCall)fc, item);
                }, this.bookmarkListener);
                this.bookmarkItems.addAll(newViewItems);
            }
        });
        this.addButtonDisabled.bind((ObservableValue)this.currentFunction.isNull());
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public @NonNull ReadOnlyObjectProperty<Boolean> addButtonDisabledProperty() {
        return (ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.addButtonDisabled.getReadOnlyProperty());
    }

    public @NonNull ObservableList<@NonNull BookmarksViewItem> getBookmarkViewItems() {
        return this.bookmarkItems;
    }

    public void close() {
        this.navigationChangedListener.dispose();
        this.currentModel.set(null);
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> navigationUriChangeEvent.getNewResolvedFunctionCall(fc -> {
            this.currentFunction.set(fc);
            return null;
        }));
    }

    public void addBookmarkAtCurrentNavigationLocation() {
        BookmarkModel model;
        FunctionCall fc = (FunctionCall)this.currentFunction.get();
        if (fc != null && (model = fc.getModel().getBookmarkModel()).getBookmark(fc) == null) {
            model.addBookmark(fc, "");
        }
    }

    public void navigateTo(int functionCallIndex) {
        TraceDataModel model = (TraceDataModel)this.currentModel.get();
        if (model != null) {
            CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)model.getCallItem(functionCallIndex)), (Object)this);
        }
    }

    public void updateBookmark(@NonNull BookmarksViewItem bookmarkItem, @NonNull String newValue) {
        FunctionCall functionCall = bookmarkItem.getFunctionCall();
        if (functionCall != null) {
            functionCall.getModel().getBookmarkModel().addBookmark(functionCall, newValue);
        }
    }

    public void removeBookmark(@NonNull BookmarksViewItem bookmarkItem) {
        FunctionCall functionCall = bookmarkItem.getFunctionCall();
        if (functionCall != null) {
            functionCall.getModel().getBookmarkModel().removeBookmark(functionCall);
        }
    }

    public void removeBookmarks(@NonNull Collection<BookmarksViewItem> bookmarksToRemove) {
        ArrayList<@NonNull FunctionCall> fcs = new ArrayList<FunctionCall>(bookmarksToRemove.size());
        TraceDataModel model = null;
        for (BookmarksViewItem bookmarkItem : bookmarksToRemove) {
            FunctionCall functionCall;
            if (bookmarkItem == null || (functionCall = bookmarkItem.getFunctionCall()) == null) continue;
            if (model == null) {
                model = functionCall.getModel();
            }
            assert (model == functionCall.getModel());
            fcs.add(functionCall);
        }
        if (model != null) {
            model.getBookmarkModel().removeBookmarks(fcs);
        }
    }

    private void updateBookmarks(@NonNull TraceDataModel model, @NonNull Map<@NonNull FunctionCall, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable BookmarkModel.Bookmark> modifiedBookmarks) {
        if (model.equals(this.currentModel.get())) {
            @NonNull ArrayList<@NonNull BookmarksViewItem> additions = new ArrayList<BookmarksViewItem>();
            @NonNull HashSet<@NonNull BookmarksViewItem> removals = new HashSet<BookmarksViewItem>();
            for (Map.Entry<FunctionCall, BookmarkModel.Bookmark> entry : modifiedBookmarks.entrySet()) {
                @NonNull FunctionCall fc = entry.getKey();
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable BookmarkModel.Bookmark bookmark = entry.getValue();
                if (bookmark != null) {
                    BookmarksViewItem viewItem = this.bookmarkItemsMap.get(fc);
                    if (viewItem == null) {
                        viewItem = new BookmarksViewItem(fc);
                        additions.add(viewItem);
                        this.bookmarkItemsMap.put(fc, viewItem);
                    }
                    viewItem.note.set((Object)bookmark.getNote());
                    continue;
                }
                @Nullable BookmarksViewItem oldItem = this.bookmarkItemsMap.remove(fc);
                if (oldItem == null) continue;
                removals.add(oldItem);
            }
            if (removals.size() != 0) {
                ArrayList<@NonNull BookmarksViewItem> newItems = new ArrayList<BookmarksViewItem>(this.bookmarkItems.size());
                for (BookmarksViewItem item : this.bookmarkItems) {
                    if (removals.contains(item)) continue;
                    newItems.add(item);
                }
                this.bookmarkItems.clear();
                this.bookmarkItems.addAll(newItems);
            }
            if (additions.size() != 0) {
                this.bookmarkItems.addAll(additions);
            }
            assert (this.bookmarkItems.size() == this.bookmarkItemsMap.size());
        }
    }

    public static class BookmarksViewItem {
        private final @NonNull WeakReference<FunctionCall> functionCall;
        private final int index;
        private final @NonNull StringProperty note = new SimpleStringProperty("");

        private BookmarksViewItem(@NonNull FunctionCall functionCall) {
            this.functionCall = new WeakReference<FunctionCall>(functionCall);
            this.index = functionCall.getIndex();
        }

        private @Nullable FunctionCall getFunctionCall() {
            return (FunctionCall)this.functionCall.get();
        }

        public int getIndex() {
            return this.index;
        }

        public @NonNull ReadOnlyStringProperty getNote() {
            return this.note;
        }
    }
}

