/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.IAutomatedTraceCommandListener;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.UIUpdateTimerListener;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.util.Pair;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AutomatedTraceViewController
implements UIUpdateTimerListener,
IAutomatedTraceCommandListener {
    private final @NonNull ObservableList<AutomatedTraceCommand> currentModelCommands = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull SortedList<AutomatedTraceCommand> sortedCurrentModelCommands = new SortedList(this.currentModelCommands);
    private final @NonNull ObservableList<AutomatedTraceCommand> selectedItems = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ReadOnlyBooleanWrapper areAutomatedTraceCommandsAvailable = new ReadOnlyBooleanWrapper();
    private final @NonNull ReadOnlyBooleanWrapper authorised = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyStringWrapper authorisationUserMessage = new ReadOnlyStringWrapper();
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private @Nullable TraceDataModel currentModel;

    public AutomatedTraceViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.areAutomatedTraceCommandsAvailable.set(AutomatedTraceViewController.calculateAreAutomatedTraceCommandsAvailable());
        Activator.uiUpdateTimer.addListener(this);
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
        ApplicationFeatureAuthoriser.AUTOMATED_TRACE.registerAuthorisationConsumer(authorisation -> {
            String userMessage;
            if (authorisation.isAuthorised()) {
                userMessage = authorisation.getReason();
            } else {
                String unauthorisedMessage = "Automated tracing is not supported by the current license";
                userMessage = "Automated tracing is not supported by the current license";
                CoreLogging.info(null, (String)("Automated tracing is not supported by the current license: " + authorisation.getReason()));
            }
            Platform.runLater(() -> {
                this.authorised.set(authorisation.isAuthorised());
                this.authorisationUserMessage.set(userMessage);
            });
        });
    }

    public @NonNull ReadOnlyBooleanProperty authorised() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.authorised.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyStringProperty getAuthorisationUserMessage() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.authorisationUserMessage.getReadOnlyProperty());
    }

    public void close() {
        this.navigationChangedListener.dispose();
        Activator.uiUpdateTimer.removeListener(this);
        if (this.currentModel != null) {
            this.currentModel.getAutomatedTraceCommandManager().removeListener((IAutomatedTraceCommandListener)this);
            this.currentModel = null;
        }
    }

    public SortedList<AutomatedTraceCommand> getCommands() {
        return this.sortedCurrentModelCommands;
    }

    public void addCommandButtonPressed(Optional<Pair<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AutomatedTraceCommand.AutomatedCommandType, @NonNull List<@NonNull Integer>>> result) {
        AbstractTargetConnection currentTargetConnection = TargetConnectionManager.getCurrentConnection();
        if (currentTargetConnection == null || !currentTargetConnection.isLive()) {
            return;
        }
        TraceDataModel model = currentTargetConnection.getActiveModel();
        if (model == null) {
            return;
        }
        result.ifPresent(resultPair -> {
            try {
                for (Integer frameNumber : (List)resultPair.getValue()) {
                    TraceDataModel localCurrentModel;
                    if (frameNumber <= model.getFrames().getLatestFrame().getId() || (localCurrentModel = this.currentModel) == null) continue;
                    AutomatedTraceCommand atc = new AutomatedTraceCommand((AutomatedTraceCommand.AutomatedCommandType)resultPair.getKey(), frameNumber.intValue());
                    currentTargetConnection.addAutomatedTraceCommand(atc);
                    localCurrentModel.getAutomatedTraceCommandManager().addAutomatedCommand(atc);
                }
            }
            catch (Exception e) {
                CoreLogging.severe(null, (String)"Couldn't send automated trace command to the target");
            }
        });
    }

    public void deleteCommandButtonPressed() {
        AbstractTargetConnection currentTargetConnection = TargetConnectionManager.getCurrentConnection();
        if (currentTargetConnection == null || !currentTargetConnection.isLive()) {
            return;
        }
        ArrayList<AutomatedTraceCommand> copiedList = new ArrayList<AutomatedTraceCommand>((Collection<AutomatedTraceCommand>)this.selectedItems);
        for (AutomatedTraceCommand atc : copiedList) {
            TraceDataModel localCurrentModel = this.currentModel;
            if (localCurrentModel == null) continue;
            currentTargetConnection.deleteAutomatedTraceCommand(atc);
            localCurrentModel.getAutomatedTraceCommandManager().deleteAutomatedCommand(atc);
        }
    }

    public void setSelectedItems(ObservableList<? extends AutomatedTraceCommand> newSelectedItems) {
        this.selectedItems.clear();
        for (AutomatedTraceCommand atc : newSelectedItems) {
            this.selectedItems.add((Object)atc);
        }
    }

    @Override
    public void onTick() {
        this.areAutomatedTraceCommandsAvailable.set(AutomatedTraceViewController.calculateAreAutomatedTraceCommandsAvailable());
    }

    private static boolean calculateAreAutomatedTraceCommandsAvailable() {
        AbstractTargetConnection currentTargetConnection = TargetConnectionManager.getCurrentConnection();
        if (currentTargetConnection != null) {
            @Nullable TraceDataModel activeModel = currentTargetConnection.getActiveModel();
            if (currentTargetConnection.canResume() && activeModel != null && !activeModel.processStartedBeforeTracing() && !activeModel.hasEverBeenReattached()) {
                return true;
            }
        }
        return false;
    }

    public ReadOnlyBooleanProperty areAutomatedTraceCommandsAvailableProperty() {
        return this.areAutomatedTraceCommandsAvailable.getReadOnlyProperty();
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewModel(newModel -> {
            if (newModel != this.currentModel) {
                if (this.currentModel != null) {
                    this.currentModel.getAutomatedTraceCommandManager().removeListener((IAutomatedTraceCommandListener)this);
                }
                this.currentModel = newModel;
                if (this.currentModel != null) {
                    this.currentModel.getAutomatedTraceCommandManager().addListener((IAutomatedTraceCommandListener)this);
                }
            }
            return null;
        });
    }

    public void automatedTraceCommandsChanged(@NonNull ArrayList<AutomatedTraceCommand> completeList) {
        this.currentModelCommands.clear();
        this.currentModelCommands.addAll(completeList);
    }
}

