/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.AutomatedTraceCommandManager;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AutomatedTraceDialogController {
    private final @NonNull ReadOnlyBooleanWrapper isTextValid = new ReadOnlyBooleanWrapper();
    private final @NonNull ReadOnlyStringWrapper textIsNotValidReason = new ReadOnlyStringWrapper();
    private final @NonNull StringProperty frameNumberText = new SimpleStringProperty();

    public AutomatedTraceDialogController() {
        ValidationChangeListener validationChangeListener = new ValidationChangeListener();
        this.frameNumberText.addListener((ChangeListener)validationChangeListener);
        validationChangeListener.changed((ObservableValue<? extends String>)this.frameNumberText, null, "");
    }

    public ReadOnlyBooleanProperty isTextValidProperty() {
        return this.isTextValid.getReadOnlyProperty();
    }

    public ReadOnlyStringProperty textIsNotValidReasonProperty() {
        return this.textIsNotValidReason.getReadOnlyProperty();
    }

    public StringProperty frameNumbersTextProperty() {
        return this.frameNumberText;
    }

    public @NonNull List<@NonNull Integer> getFrameNumberFromString(@NonNull String frameNumbersString) throws FrameNumbersInvalidException {
        String[] frameNumbersStrings = frameNumbersString.split(",");
        ArrayList<@NonNull Integer> frameNumbers = new ArrayList<Integer>();
        String[] stringArray = frameNumbersStrings;
        int n = frameNumbersStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String frameNumberString = stringArray[n2];
            if (!frameNumberString.isEmpty()) {
                frameNumberString = frameNumberString.trim();
                try {
                    @NonNull Integer integerToAdd = NullUtils.intValueOf((String)frameNumberString);
                    if (!frameNumbers.contains(integerToAdd)) {
                        frameNumbers.add(integerToAdd);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FrameNumbersInvalidException("Entry '" + frameNumberString + "' is not an integer.");
                }
            }
            ++n2;
        }
        return frameNumbers;
    }

    private void validateFrameNumbers(@NonNull String frameNumbersString) throws FrameNumbersInvalidException {
        @Nullable NavigationUri uri = CoreInstance.getNavigationManager().getActiveNavigationUri();
        if (uri == null) {
            throw new FrameNumbersInvalidException("No current uri.");
        }
        FrameNumbersInvalidException e = (FrameNumbersInvalidException)uri.getModel(model -> {
            try {
                if (model == null) {
                    throw new FrameNumbersInvalidException("No current uri.");
                }
                List<@NonNull Integer> frameNumbers = this.getFrameNumberFromString(frameNumbersString);
                if (frameNumbers.isEmpty()) {
                    throw new FrameNumbersInvalidException("You must specify at least one frame.");
                }
                @NonNull AutomatedTraceCommandManager automatedTraceCommandManager = model.getAutomatedTraceCommandManager();
                for (Integer frameNumber : frameNumbers) {
                    if (frameNumber <= model.getFrames().count()) {
                        throw new FrameNumbersInvalidException("Entry '" + frameNumber + "' is invalid. You can only add commands starting at the next frame (" + (model.getFrames().count() + 1) + ").");
                    }
                    if (!automatedTraceCommandManager.containsCommandForFrame(frameNumber.intValue())) continue;
                    throw new FrameNumbersInvalidException("Entry '" + frameNumber + "' is invalid. There is already a command for this frame.");
                }
            }
            catch (FrameNumbersInvalidException exception) {
                return exception;
            }
            return null;
        });
        if (e != null) {
            throw e;
        }
    }

    private class FrameNumbersInvalidException
    extends Exception {
        private static final long serialVersionUID = -787799177908062867L;

        private FrameNumbersInvalidException(String string) {
            super(string);
        }
    }

    private final class ValidationChangeListener
    implements ChangeListener<String> {
        private ValidationChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            AutomatedTraceDialogController.this.isTextValid.set(true);
            AutomatedTraceDialogController.this.textIsNotValidReason.set("Enter a comma separated list of frame numbers.");
            if (newValue == null) {
                return;
            }
            try {
                AutomatedTraceDialogController.this.validateFrameNumbers(newValue);
            }
            catch (FrameNumbersInvalidException frameNumbersInvalidException) {
                AutomatedTraceDialogController.this.isTextValid.set(false);
                AutomatedTraceDialogController.this.textIsNotValidReason.set(frameNumbersInvalidException.getMessage());
            }
        }
    }
}

